/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.comments.dto;

import java.util.ArrayList;
import java.util.List;
import org.lamsfoundation.lams.comments.Comment;

public class CommentDTO {
    private Comment comment;
    private String authorname;
    private boolean isAuthor;
    private boolean hasAttachment;
    private short level;
    private int threadNum;
    private boolean liked;
    private boolean disliked;

    public static CommentDTO getCommentDTO(Comment comment) {
        if (comment == null) {
            return null;
        }
        CommentDTO dto = new CommentDTO();
        dto.setComment(comment);
        if (comment.getCreatedBy() != null) {
            dto.setAuthorname(comment.getCreatedBy().getFirstName() + " " + comment.getCreatedBy().getLastName());
        }
        dto.liked = false;
        dto.disliked = false;
        return dto;
    }

    public static List<CommentDTO> getCommentDTO(List<Comment> commentList) {
        ArrayList<CommentDTO> retSet = new ArrayList<CommentDTO>();
        if (commentList == null || commentList.isEmpty()) {
            return retSet;
        }
        for (Comment msg : commentList) {
            retSet.add(CommentDTO.getCommentDTO(msg));
        }
        return retSet;
    }

    public String getAuthorname() {
        return this.authorname;
    }

    public void setAuthorname(String authorname) {
        this.authorname = authorname;
    }

    public boolean getHasAttachment() {
        return this.hasAttachment;
    }

    public void setHasAttachment(boolean isAttachment) {
        this.hasAttachment = isAttachment;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public short getLevel() {
        return this.level;
    }

    public void setLevel(short level) {
        this.level = level;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public boolean isAuthor() {
        return this.isAuthor;
    }

    public void setIsAuthor(boolean isAuthor) {
        this.isAuthor = isAuthor;
    }

    public boolean isLiked() {
        return this.liked;
    }

    public void setLiked(boolean liked) {
        this.liked = liked;
    }

    public boolean isDisliked() {
        return this.disliked;
    }

    public void setDisliked(boolean disliked) {
        this.disliked = disliked;
    }
}

