/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.ISystemToolActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.strategy.GateActivityStrategy;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.usermanagement.User;

public abstract class GateActivity
extends SimpleActivity
implements Serializable,
ISystemToolActivity {
    public static final int LEARNER_GATE_LEVEL = 1;
    public static final int GROUP_GATE_LEVEL = 2;
    public static final int CLASS_GATE_LEVEL = 3;
    private SystemTool systemTool;
    private Integer gateActivityLevelId;
    private Boolean gateOpen;
    private Set<User> allowedToPassLearners;

    public GateActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Boolean stopAfterActivity, Set inputActivities, Integer gateActivityLevelId, SystemTool sysTool, Set branchActivityEntries) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile, stopAfterActivity, inputActivities, branchActivityEntries);
        this.gateActivityLevelId = gateActivityLevelId;
        this.systemTool = sysTool;
    }

    public GateActivity() {
    }

    public GateActivity(Long activityId, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Integer gateActivityLevelId) {
        super(activityId, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom);
        this.gateActivityLevelId = gateActivityLevelId;
    }

    public Integer getGateActivityLevelId() {
        return this.gateActivityLevelId;
    }

    public void setGateActivityLevelId(Integer gateActivityLevelId) {
        this.gateActivityLevelId = gateActivityLevelId;
    }

    public Boolean getGateOpen() {
        return this.gateOpen;
    }

    public void setGateOpen(Boolean gateOpen) {
        this.gateOpen = gateOpen;
    }

    public boolean shouldOpenGateFor(User learner, int expectedLearnerCount, int waitingLearnerCount) {
        if (this.getGateOpen() == null) {
            this.setGateOpen(false);
        }
        return ((GateActivityStrategy)this.simpleActivityStrategy).shouldOpenGateFor(learner, expectedLearnerCount, waitingLearnerCount);
    }

    public void forceGateOpen() {
        this.setGateOpen(true);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    @Override
    public SystemTool getSystemTool() {
        return this.systemTool;
    }

    @Override
    public void setSystemTool(SystemTool systemTool) {
        this.systemTool = systemTool;
    }

    protected void copyToNewActivity(GateActivity newActivity, int uiidOffset) {
        super.copyToNewActivity(newActivity, uiidOffset);
        newActivity.setSystemTool(this.getSystemTool());
    }

    public Set<User> getAllowedToPassLearners() {
        return this.allowedToPassLearners;
    }

    public void setAllowedToPassLearners(Set<User> allowedToPassLearners) {
        this.allowedToPassLearners = allowedToPassLearners;
    }
}

