/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.util.MessageService;

public class GroupBranchingActivity
extends BranchingActivity
implements Serializable {
    private static final long serialVersionUID = 7426228060060498158L;

    public GroupBranchingActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Integer startXcoord, Integer startYcoord, Integer endXcoord, Integer endYcoord, Boolean stopAfterActivity, Set inputActivities, Set activities, Activity defaultActivity, SystemTool systemTool, Set branchActivityEntries) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile, startXcoord, startYcoord, endXcoord, endYcoord, stopAfterActivity, inputActivities, activities, defaultActivity, systemTool, branchActivityEntries);
    }

    public GroupBranchingActivity() {
    }

    public GroupBranchingActivity(Long activityId, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Set activities) {
        super(activityId, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, activities);
    }

    @Override
    public Activity createCopy(int uiidOffset) {
        GroupBranchingActivity newBranchingActivity = new GroupBranchingActivity();
        this.copyBranchingFields(newBranchingActivity);
        this.copyToNewComplexActivity(newBranchingActivity, uiidOffset);
        return newBranchingActivity;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    @Override
    public Vector validateActivity(MessageService messageService) {
        Vector<ValidationErrorDTO> listOfValidationErrors = new Vector<ValidationErrorDTO>();
        if (this.getActivities() == null || this.getActivities().size() == 0) {
            listOfValidationErrors.add(new ValidationErrorDTO("BB", messageService.getMessage("validation.error.branching.must.have.a.branch"), this.getActivityUIID()));
        }
        if (this.getGrouping() == null) {
            listOfValidationErrors.add(new ValidationErrorDTO("BGG", messageService.getMessage("validation.error.groupedBranchingMustHaveAGrouping"), this.getActivityUIID()));
        } else {
            Set groups = this.getGrouping().getGroups();
            if (groups == null || groups.size() == 0) {
                listOfValidationErrors.add(new ValidationErrorDTO("BGG", messageService.getMessage("validation.error.groupedBranchingMustHaveAGrouping"), this.getActivityUIID()));
            } else {
                for (Group group : groups) {
                    boolean foundEntry = false;
                    if (group.getBranchActivities() != null) {
                        Iterator iter = group.getBranchActivities().iterator();
                        while (iter.hasNext() && !foundEntry) {
                            BranchActivityEntry entry = (BranchActivityEntry)iter.next();
                            foundEntry = entry.getBranchingActivity().equals(this);
                        }
                    }
                    if (foundEntry) continue;
                    listOfValidationErrors.add(new ValidationErrorDTO("BGM", messageService.getMessage("validation.error.groupedBranchingMustHaveBranchForGroup"), this.getActivityUIID()));
                    break;
                }
            }
        }
        return listOfValidationErrors;
    }
}

