/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.util.List;
import java.util.SortedMap;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.RequiredGroupMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.dao.DataIntegrityViolationException;

public interface ILamsCoreToolService {
    public ToolSession createToolSession(User var1, ToolActivity var2, Lesson var3) throws DataIntegrityViolationException, RequiredGroupMissingException;

    public ToolSession getToolSessionByLearner(User var1, Activity var2) throws LamsToolServiceException;

    public ToolSession getToolSessionById(Long var1);

    public ToolSession getToolSessionByActivity(User var1, ToolActivity var2) throws LamsToolServiceException;

    public void notifyToolsToCreateSession(ToolSession var1, ToolActivity var2) throws ToolException;

    public Long notifyToolToCopyContent(ToolActivity var1, String var2) throws DataMissingException, ToolException;

    public Long notifyToolToCopyContent(Long var1, String var2) throws DataMissingException, ToolException;

    public void notifyToolToDeleteContent(ToolActivity var1) throws ToolException;

    public void notifyToolToDeleteLearnerContent(ToolActivity var1, Integer var2) throws ToolException;

    public SortedMap<String, ToolOutputDefinition> getOutputDefinitionsFromTool(Long var1, int var2) throws ToolException;

    public SortedMap<String, ToolOutputDefinition> getOutputDefinitionsFromToolFiltered(Long var1, int var2, Long var3) throws ToolException;

    public ToolOutput getOutputFromTool(String var1, Long var2, Integer var3) throws ToolException;

    public ToolOutput getOutputFromTool(String var1, ToolSession var2, Integer var3) throws ToolException;

    public List<ToolOutput> getOutputsFromTool(String var1, ToolActivity var2) throws ToolException;

    public SortedMap<String, ToolOutput> getOutputFromTool(List<String> var1, Long var2, Integer var3) throws ToolException;

    public SortedMap<String, ToolOutput> getOutputFromTool(List<String> var1, ToolSession var2, Integer var3) throws ToolException;

    public void forceCompleteActivity(ToolSession var1, User var2) throws ToolException;

    public Long getActivityMaxPossibleMark(ToolActivity var1);

    public void updateToolSession(ToolSession var1);

    public String getToolLearnerURL(Long var1, Activity var2, User var3) throws LamsToolServiceException;

    public String getToolLearnerPreviewURL(Long var1, Activity var2, User var3) throws LamsToolServiceException;

    public String getToolLearnerProgressURL(Long var1, Activity var2, User var3) throws LamsToolServiceException;

    public String getToolMonitoringURL(Long var1, Activity var2) throws LamsToolServiceException;

    public String getToolContributionURL(Long var1, Activity var2) throws LamsToolServiceException;

    public boolean isContentEdited(Activity var1);

    public String getToolAuthorURL(Long var1, ToolActivity var2, ToolAccessMode var3);

    public List getToolSessionsByLesson(Lesson var1);

    public void deleteToolSession(ToolSession var1);

    public String setupToolURLWithToolSession(ToolActivity var1, User var2, String var3) throws LamsToolServiceException;

    public String setupToolURLWithToolContent(ToolActivity var1, String var2);

    public Object findToolService(Tool var1) throws NoSuchBeanDefinitionException;
}

