/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouper;
import org.lamsfoundation.lams.learningdesign.NullGroup;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.usermanagement.User;

public abstract class Grouping
implements Serializable {
    public static final Integer RANDOM_GROUPING_TYPE = new Integer(1);
    public static final Integer CHOSEN_GROUPING_TYPE = new Integer(2);
    public static final Integer CLASS_GROUPING_TYPE = new Integer(3);
    private Long groupingId;
    private Integer maxNumberOfGroups;
    private Integer groupingUIID;
    private Set groups;
    private Set activities;
    protected Set learners;
    protected Grouper grouper;
    public static final int GROUPING_SUPPORT_NONE = 1;
    public static final int GROUPING_SUPPORT_OPTIONAL = 2;
    public static final int GROUPING_SUPPORT_REQUIRED = 3;

    public Grouping(Long groupingId, Set groups, Set activities, Grouper grouper) {
        this.groupingId = groupingId;
        this.groups = groups;
        this.activities = activities;
        this.grouper = grouper;
    }

    public Grouping() {
    }

    public Grouping(Long groupingId) {
        this.groupingId = groupingId;
    }

    public abstract Grouping createCopy();

    protected void copyGroupingFields(Grouping newGrouping) {
        newGrouping.setMaxNumberOfGroups(this.getMaxNumberOfGroups());
        newGrouping.setGroupingUIID(this.getGroupingUIID());
        if (this.getGroups() != null && this.getGroups().size() > 0) {
            for (Group oldGroup : this.getGroups()) {
                Group newGroup = oldGroup.createCopy(newGrouping);
                newGrouping.getGroups().add(newGroup);
            }
        }
    }

    public Long getGroupingId() {
        return this.groupingId;
    }

    public void setGroupingId(Long groupingId) {
        this.groupingId = groupingId;
    }

    public Integer getGroupingTypeId() {
        if (this instanceof LessonClass) {
            return CLASS_GROUPING_TYPE;
        }
        if (this instanceof ChosenGrouping) {
            return CHOSEN_GROUPING_TYPE;
        }
        return RANDOM_GROUPING_TYPE;
    }

    public Set getGroups() {
        if (this.groups == null) {
            this.setGroups(new TreeSet());
        }
        return this.groups;
    }

    public void setGroups(Set groups) {
        this.groups = groups;
    }

    public Set getActivities() {
        if (this.activities == null) {
            this.setActivities(new TreeSet(new ActivityOrderComparator()));
        }
        return this.activities;
    }

    public void setActivities(Set activities) {
        this.activities = activities;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("groupingId", (Object)this.getGroupingId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Grouping)) {
            return false;
        }
        Grouping castOther = (Grouping)other;
        return new EqualsBuilder().append((Object)this.getGroupingId(), (Object)castOther.getGroupingId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getGroupingId()).toHashCode();
    }

    public Integer getMaxNumberOfGroups() {
        return this.maxNumberOfGroups;
    }

    public void setMaxNumberOfGroups(Integer maxNumberOfGroups) {
        this.maxNumberOfGroups = maxNumberOfGroups;
    }

    public Integer getGroupingUIID() {
        return this.groupingUIID;
    }

    public void setGroupingUIID(Integer groupingUIID) {
        this.groupingUIID = groupingUIID;
    }

    public synchronized int getNextGroupOrderIdCheckName(String proposedName) {
        int maxOrderId = 0;
        if (this.getGroups() != null) {
            for (Group element : this.getGroups()) {
                int n = maxOrderId = element.getOrderId() > maxOrderId ? element.getOrderId() : maxOrderId;
                if (!proposedName.equals(element.getGroupName())) continue;
                return -1;
            }
        }
        return ++maxOrderId;
    }

    public Set getLearners() {
        this.learners = new HashSet();
        for (Group group : this.getGroups()) {
            if (!this.isLearnerGroup(group)) continue;
            this.learners.addAll(group.getUsers());
        }
        return this.learners;
    }

    public Group getGroupBy(User learner) {
        for (Group group : this.getGroups()) {
            if (!this.isLearnerGroup(group) || !group.hasLearner(learner)) continue;
            return group;
        }
        return new NullGroup();
    }

    public Group getGroupWithLeastMember() {
        ArrayList groups = new ArrayList(this.getGroups());
        Group minGroup = (Group)groups.get(0);
        for (int i = 1; i < groups.size(); ++i) {
            Group tempGroup = (Group)groups.get(i);
            if (tempGroup.getUsers().size() >= minGroup.getUsers().size()) continue;
            minGroup = tempGroup;
        }
        return minGroup;
    }

    public abstract boolean isLearnerGroup(Group var1);

    public boolean doesLearnerExist(User learner) {
        return !this.getGroupBy(learner).isNull();
    }

    public GroupingDTO getGroupingDTO() {
        return new GroupingDTO(this);
    }

    public static Object getGroupingInstance(Integer groupingType) {
        if (groupingType.equals(RANDOM_GROUPING_TYPE)) {
            return new RandomGrouping();
        }
        if (groupingType.equals(CHOSEN_GROUPING_TYPE)) {
            return new ChosenGrouping();
        }
        return new LessonClass();
    }

    public boolean isRandomGrouping() {
        return this.getGroupingTypeId() == RANDOM_GROUPING_TYPE;
    }

    public boolean isChosenGrouping() {
        return this.getGroupingTypeId() == CHOSEN_GROUPING_TYPE;
    }

    public boolean isClassGrouping() {
        return this.getGroupingTypeId() == CLASS_GROUPING_TYPE;
    }

    public Grouper getGrouper() {
        return this.grouper;
    }

    public void setGrouper(Grouper grouper) {
        this.grouper = grouper;
    }
}

