/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.Date;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class TransitionDTO
extends BaseDTO {
    private Long transitionID;
    private Integer transitionUIID;
    private Integer toUIID;
    private Integer fromUIID;
    private String description;
    private String title;
    private Date createDateTime;
    private Long toActivityID;
    private Long fromActivityID;
    private Long learningDesignID;

    public TransitionDTO() {
    }

    public TransitionDTO(Long transitionId, Integer transitionUIID, Integer toUIID, Integer fromUIID, String description, String title, Date createDateTime, Long toActivityID, Long fromActivityID, Long learningDesignID) {
        this.transitionID = transitionId;
        this.transitionUIID = transitionUIID;
        this.toUIID = toUIID;
        this.fromUIID = fromUIID;
        this.description = description;
        this.title = title;
        this.createDateTime = createDateTime;
        this.toActivityID = toActivityID;
        this.fromActivityID = fromActivityID;
        this.learningDesignID = learningDesignID;
    }

    public TransitionDTO(Transition transition) {
        this.transitionID = transition.getTransitionId();
        this.transitionUIID = transition.getTransitionUIID();
        this.toUIID = transition.getToUIID();
        this.fromUIID = transition.getFromUIID();
        this.description = transition.getDescription();
        this.title = transition.getTitle();
        this.createDateTime = transition.getCreateDateTime();
        this.toActivityID = transition.getToActivity().getActivityId();
        this.fromActivityID = transition.getFromActivity().getActivityId();
        this.learningDesignID = transition.getLearningDesign().getLearningDesignId();
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getFromActivityID() {
        return this.fromActivityID;
    }

    public Integer getFromUIID() {
        return this.fromUIID;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public String getTitle() {
        return this.title;
    }

    public Long getToActivityID() {
        return this.toActivityID;
    }

    public Integer getToUIID() {
        return this.toUIID;
    }

    public Long getTransitionID() {
        return this.transitionID;
    }

    public Integer getTransitionUIID() {
        return this.transitionUIID;
    }

    public void setCreateDateTime(Date createDateTime) {
        if (!createDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.createDateTime = createDateTime;
        }
    }

    public void setDescription(String description) {
        if (!description.equals("string_null_value")) {
            this.description = description;
        }
    }

    public void setFromActivityID(Long fromActivityID) {
        if (!fromActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.fromActivityID = fromActivityID;
        }
    }

    public void setFromUIID(Integer fromUIID) {
        if (!fromUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.fromUIID = fromUIID;
        }
    }

    public void setLearningDesignID(Long learningDesignID) {
        if (!learningDesignID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.learningDesignID = learningDesignID;
        }
    }

    public void setTitle(String title) {
        if (!title.equals("string_null_value")) {
            this.title = title;
        }
    }

    public void setToActivityID(Long toActivityID) {
        if (!toActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.toActivityID = toActivityID;
        }
    }

    public void setToUIID(Integer toUIID) {
        if (!toUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.toUIID = toUIID;
        }
    }

    public void setTransitionID(Long transitionId) {
        if (!transitionId.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.transitionID = transitionId;
        }
    }

    public void setTransitionUIID(Integer transitionUIID) {
        if (!transitionUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.transitionUIID = transitionUIID;
        }
    }
}

