/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class ToolContentVersionFilter {
    private static final Logger log = Logger.getLogger(ToolContentVersionFilter.class);
    private List<RemovedField> removedFieldList = new ArrayList<RemovedField>();
    private List<AddedField> addedFieldList = new ArrayList<AddedField>();

    public void removeField(Class ownerClass, String fieldname) {
        this.removedFieldList.add(new RemovedField(ownerClass, fieldname));
    }

    public void addField(Class ownerClass, String fieldname, Object defaultValue) {
        this.addedFieldList.add(new AddedField(ownerClass, fieldname, defaultValue));
    }

    public void transformXML(String toolFilePath) throws JDOMException, IOException {
        File toolFile = new File(toolFilePath);
        SAXBuilder sax = new SAXBuilder();
        Document doc = sax.build((InputStream)new FileInputStream(toolFile));
        Element root = doc.getRootElement();
        this.retrieveXML(root);
        toolFile.renameTo(new File(toolFilePath + "_oldver"));
        File newToolFile = new File(toolFilePath);
        XMLOutputter output = new XMLOutputter();
        output.output(doc, (OutputStream)new FileOutputStream(newToolFile));
    }

    private void retrieveXML(Element root) throws JDOMException {
        ArrayList<String> clzRemoveFlds = new ArrayList<String>();
        for (RemovedField remove : this.removedFieldList) {
            if (!StringUtils.equals((String)root.getName(), (String)remove.ownerClass.getName())) continue;
            clzRemoveFlds.add(remove.fieldname);
            log.debug((Object)("Field " + remove.fieldname + " in class " + remove.ownerClass.getName() + " is going to leave."));
        }
        for (AddedField added : this.addedFieldList) {
            if (!StringUtils.equals((String)root.getName(), (String)added.ownerClass.getName())) continue;
            StringWriter eleWriter = new StringWriter();
            XStream eleX = new XStream();
            eleX.toXML(added.defaultValue, (Writer)eleWriter);
            SAXBuilder eleBuilder = new SAXBuilder();
            Document eledoc = eleBuilder.build((Reader)new StringReader(((Object)eleWriter).toString()));
            Element eleRoot = eledoc.getRootElement();
            eleRoot.setName(added.fieldname);
            root.addContent(eleRoot);
            log.debug((Object)("Field " + added.fieldname + " in class " + added.ownerClass.getName() + " is add by value " + added.defaultValue));
        }
        List children = root.getChildren();
        for (Object child : children) {
            Element ele;
            if (!(child instanceof Element) || clzRemoveFlds.contains((ele = (Element)child).getName())) continue;
            this.retrieveXML(ele);
        }
        for (String name : clzRemoveFlds) {
            if (root.removeChild(name)) {
                log.debug((Object)("Field " + name + " is removed."));
                continue;
            }
            log.debug((Object)("Failed remove field " + name + "."));
        }
    }

    class AddedField {
        public Class ownerClass;
        public String fieldname;
        public Object defaultValue;

        public AddedField(Class ownerClass2, String fieldname2, Object defaultValue2) {
            this.ownerClass = ownerClass2;
            this.fieldname = fieldname2;
            this.defaultValue = defaultValue2;
        }
    }

    class RemovedField {
        public Class ownerClass;
        public String fieldname;

        public RemovedField(Class ownerClass, String fieldname) {
            this.ownerClass = ownerClass;
            this.fieldname = fieldname;
        }
    }
}

