/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.strategy;

import java.util.ArrayList;
import java.util.List;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.strategy.SimpleActivityStrategy;
import org.lamsfoundation.lams.usermanagement.User;

public abstract class GateActivityStrategy
extends SimpleActivityStrategy {
    protected GateActivity gateActivity = null;

    public GateActivityStrategy(GateActivity gateActivity) {
        this.gateActivity = gateActivity;
    }

    public boolean shouldOpenGateFor(User learner, List lessonLearners) {
        this.gateActivity.addLeaner(learner, false);
        boolean isOpen = this.gateActivity.getGateOpen();
        if (!isOpen) {
            if (this.isOpenConditionMet(lessonLearners)) {
                this.gateActivity.setGateOpen(new Boolean(true));
            } else {
                return this.gateActivity.getAllowedToPassLearners().contains(learner);
            }
        }
        this.gateActivity.getAllGateUsers().clear();
        this.gateActivity.getWaitingLearners().clear();
        this.gateActivity.getAllowedToPassLearners().clear();
        return isOpen;
    }

    protected abstract boolean isOpenConditionMet(List var1);

    @Override
    protected abstract void setUpContributionType(ArrayList<Integer> var1);

    @Override
    protected Activity getActivity() {
        return this.gateActivity;
    }
}

