/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.strategy;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ContributionTypes;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.strategy.GateActivityStrategy;
import org.lamsfoundation.lams.lesson.CompletedActivityProgress;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.usermanagement.User;

public class ScheduleGateActivityStrategy
extends GateActivityStrategy {
    public ScheduleGateActivityStrategy(GateActivity gateActivity) {
        super(gateActivity);
    }

    @Override
    protected void setUpContributionType(ArrayList<Integer> contributionTypes) {
        contributionTypes.add(ContributionTypes.SCHEDULE_GATE);
    }

    @Override
    protected boolean isOpenConditionMet(List lessonLearners) {
        if (this.gateActivity != null) {
            return this.gateActivity.getGateOpen();
        }
        return true;
    }

    @Override
    public boolean shouldOpenGateFor(User learner, List lessonLearners) {
        ScheduleGateActivity scheduleGate = (ScheduleGateActivity)this.gateActivity;
        if (Boolean.TRUE.equals(scheduleGate.getGateActivityCompletionBased())) {
            Date openTime;
            Date previousActivityCompletionTime = ScheduleGateActivityStrategy.getPreviousActivityCompletionDate(scheduleGate, learner);
            if (previousActivityCompletionTime != null && (openTime = scheduleGate.getGateOpenTime(previousActivityCompletionTime)).compareTo(new Date()) <= 0) {
                this.gateActivity.addLeaner(learner, true);
                return true;
            }
            return false;
        }
        return super.shouldOpenGateFor(learner, lessonLearners);
    }

    public static Date getPreviousActivityCompletionDate(ScheduleGateActivity scheduleGate, User learner) {
        Activity previousActivity = scheduleGate.getTransitionTo().getFromActivity();
        if (previousActivity != null) {
            for (LearnerProgress progress : learner.getLearnerProgresses()) {
                CompletedActivityProgress completion = progress.getCompletedActivities().get(previousActivity);
                if (completion == null) continue;
                return completion.getFinishDate();
            }
        }
        return null;
    }
}

