/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class LearnerProgressDAO
extends HibernateDaoSupport
implements ILearnerProgressDAO {
    protected Logger log = Logger.getLogger(LearnerProgressDAO.class);
    private static final String LOAD_PROGRESS_BY_LEARNER = "from LearnerProgress p where p.user.id = :learnerId and p.lesson.id = :lessonId";
    private static final String LOAD_PROGRESS_BY_ACTIVITY = "from LearnerProgress p where p.previousActivity = :activity or p.currentActivity = :activity or p.nextActivity = :activity ";
    private static final String LOAD_COMPLETED_PROGRESS_BY_LESSON = "from LearnerProgress p where p.lessonComplete > 0 and p.lesson.id = :lessonId";
    private static final String COUNT_ATTEMPTED_ACTIVITY = "select count(*) from LearnerProgress prog,  Activity act join prog.attemptedActivities attAct  where act.id = :activityId and  index(attAct) = act";
    private static final String COUNT_COMPLETED_ACTIVITY = "select count(*) from LearnerProgress prog,  Activity act join prog.completedActivities compAct  where act.id = :activityId and  index(compAct) = act";
    private static final String COUNT_PROGRESS_BY_LESSON = "select count(*) from LearnerProgress p where p.lesson.id = :lessonId";
    private static final String LOAD_PROGRESS_BY_LESSON = "from LearnerProgress p where p.lesson.id = :lessonId order by p.user.lastName, p.user.firstName, p.user.userId";
    private static final String LOAD_NEXT_BATCH_PROGRESS_BY_LESSON = "from LearnerProgress p where p.lesson.id = :lessonId  and (( p.user.lastName > :lastUserLastName) or ( p.user.lastName = :lastUserLastName and p.user.firstName > :lastUserFirstName)  or ( p.user.lastName = :lastUserLastName and p.user.firstName = :lastUserFirstName and p.user.userId > :lastUserId)) order by p.user.lastName, p.user.firstName, p.user.userId";

    @Override
    public LearnerProgress getLearnerProgress(Long learnerProgressId) {
        return (LearnerProgress)this.getHibernateTemplate().get(LearnerProgress.class, (Serializable)learnerProgressId);
    }

    @Override
    public void saveLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().save((Object)learnerProgress);
    }

    @Override
    public void deleteLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().delete((Object)learnerProgress);
    }

    @Override
    public LearnerProgress getLearnerProgressByLearner(final Integer learnerId, final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (LearnerProgress)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_LEARNER).setInteger("learnerId", learnerId.intValue()).setLong("lessonId", lessonId.longValue()).uniqueResult();
            }
        });
    }

    @Override
    public void updateLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().update((Object)learnerProgress);
    }

    @Override
    public List getLearnerProgressReferringToActivity(final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_ACTIVITY).setEntity("activity", (Object)activity).list();
            }
        });
    }

    @Override
    public List getCompletedLearnerProgressForLesson(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_COMPLETED_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).list();
            }
        });
    }

    @Override
    public List getLearnerProgressForLesson(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).list();
            }
        });
    }

    @Override
    public List<User> getLearnersHaveAttemptedActivity(final Activity activity) {
        List learners = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        learners = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("usersAttemptedActivity").setLong("activityId", activity.getActivityId().longValue()).list();
            }
        });
        return learners;
    }

    @Override
    public Integer getNumUsersAttemptedActivity(final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        Integer attempted = (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object value = session.createQuery(LearnerProgressDAO.COUNT_ATTEMPTED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
        return new Integer(attempted + this.getNumUsersCompletedActivity(activity));
    }

    @Override
    public List<User> getLearnersHaveCompletedActivity(final Activity activity) {
        List learners = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        learners = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("usersCompletedActivity").setLong("activityId", activity.getActivityId().longValue()).list();
            }
        });
        return learners;
    }

    @Override
    public Integer getNumUsersCompletedActivity(final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object value = session.createQuery(LearnerProgressDAO.COUNT_COMPLETED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
    }

    @Override
    public Integer getNumAllLearnerProgress(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object value = session.createQuery(LearnerProgressDAO.COUNT_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
    }

    @Override
    public List<LearnerProgress> getBatchLearnerProgress(final Long lessonId, final User lastUser, final int batchSize) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        if (lastUser == null) {
            return (List)hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).setMaxResults(batchSize).list();
                }
            });
        }
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_NEXT_BATCH_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).setString("lastUserLastName", lastUser.getLastName()).setString("lastUserFirstName", lastUser.getFirstName()).setInteger("lastUserId", lastUser.getUserId().intValue()).setMaxResults(batchSize).list();
            }
        });
    }
}

