/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dto;

import java.util.Date;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.Organisation;

public class LessonDTO {
    private Long lessonID;
    private String lessonName;
    private String lessonDescription;
    private Integer lessonStateID;
    private Integer organisationID;
    private Date createDateTime;
    private String createDateTimeString;
    private Date startDateTime;
    private Long learningDesignID;
    private Boolean learnerExportAvailable;
    private Boolean learnerPresenceAvailable;
    private Boolean learnerImAvailable;
    private Boolean displayMonitor;

    public LessonDTO(Lesson lesson) {
        this.lessonID = lesson.getLessonId();
        this.lessonName = lesson.getLessonName();
        this.lessonDescription = lesson.getLessonDescription();
        this.lessonStateID = lesson.getLessonStateId();
        LearningDesign design = lesson.getLearningDesign();
        this.learningDesignID = design != null ? design.getLearningDesignId() : null;
        Organisation org = lesson.getOrganisation();
        this.organisationID = org != null ? org.getOrganisationId() : null;
        this.createDateTime = lesson.getCreateDateTime();
        this.createDateTimeString = lesson.getCreateDateTime().toString();
        this.startDateTime = lesson.getStartDateTime();
        this.learnerExportAvailable = lesson.getLearnerExportAvailable();
        this.learnerPresenceAvailable = lesson.getLearnerPresenceAvailable();
        this.learnerImAvailable = lesson.getLearnerImAvailable();
    }

    public Long getLessonID() {
        return this.lessonID;
    }

    public String getLessonName() {
        return this.lessonName;
    }

    public String getLessonDescription() {
        return this.lessonDescription;
    }

    public Integer getLessonStateID() {
        return this.lessonStateID;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public String getCreateDateTimeString() {
        return this.createDateTimeString;
    }

    public Integer getOrganisationID() {
        return this.organisationID;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public Boolean getLearnerExportAvailable() {
        return this.learnerExportAvailable;
    }

    public Boolean getLearnerPresenceAvailable() {
        return this.learnerPresenceAvailable;
    }

    public Boolean getLearnerImAvailable() {
        return this.learnerImAvailable;
    }

    public Boolean getDisplayMonitor() {
        return this.displayMonitor;
    }

    public void setDisplayMonitor(Boolean displayMonitor) {
        this.displayMonitor = displayMonitor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append("lessonID='" + this.getLessonID() + "'; ");
        sb.append("lessonName='" + this.getLessonName() + "';");
        sb.append("lessonDescription='" + this.getLessonDescription() + "'; ");
        sb.append("lessonStateID='" + this.getLessonStateID() + "'; ");
        sb.append("learningDesignID='" + this.getLearningDesignID() + "'; ");
        sb.append("organisationID='" + this.getOrganisationID() + "'; ");
        sb.append("createDateTime='" + this.getCreateDateTime() + "'; ");
        sb.append("createDateTimeString='" + this.getCreateDateTimeString() + "'; ");
        sb.append("startDateTime='" + this.getStartDateTime() + "'; ");
        sb.append("learnerExportAvailable='" + this.getLearnerExportAvailable() + "'; ");
        sb.append("learnerPresenceAvailable='" + this.getLearnerPresenceAvailable() + "'; ");
        sb.append("learnerImAvailable='" + this.getLearnerImAvailable() + "'; ");
        sb.append("displayMonitor='" + this.getDisplayMonitor() + "'; ");
        return sb.toString();
    }
}

