/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.rating.dao.IRatingCriteriaDAO;
import org.lamsfoundation.lams.rating.model.AuthoredItemRatingCriteria;
import org.lamsfoundation.lams.rating.model.LearnerItemRatingCriteria;
import org.lamsfoundation.lams.rating.model.LessonRatingCriteria;
import org.lamsfoundation.lams.rating.model.RatingCriteria;
import org.lamsfoundation.lams.rating.model.ToolActivityRatingCriteria;
import org.springframework.dao.DataRetrievalFailureException;

public class RatingCriteriaDAO
extends BaseDAO
implements IRatingCriteriaDAO {
    private static final String FIND_BY_TOOL_CONTENT_ID = "from " + RatingCriteria.class.getName() + " as r where r.toolContentId=? order by r.orderId asc";

    @Override
    public void saveOrUpdate(RatingCriteria criteria) {
        this.getHibernateTemplate().saveOrUpdate((Object)criteria);
        this.getHibernateTemplate().flush();
    }

    @Override
    public void deleteRatingCriteria(Long ratingCriteriaId) {
        this.deleteById(RatingCriteria.class, ratingCriteriaId);
    }

    @Override
    public List<RatingCriteria> getByToolContentId(Long toolContentId) {
        return this.getHibernateTemplate().find(FIND_BY_TOOL_CONTENT_ID, new Object[]{toolContentId});
    }

    @Override
    public RatingCriteria getByRatingCriteriaId(Long ratingCriteriaId) {
        if (ratingCriteriaId == null) {
            return null;
        }
        RatingCriteria criteria = (RatingCriteria)this.getHibernateTemplate().get(RatingCriteria.class, (Serializable)ratingCriteriaId);
        if (criteria != null) {
            Integer criteriaType = criteria.getRatingCriteriaTypeId();
            if (criteriaType != null) {
                switch (criteriaType) {
                    case 1: {
                        return this.getByRatingCriteriaId(ratingCriteriaId, ToolActivityRatingCriteria.class);
                    }
                    case 2: {
                        return this.getByRatingCriteriaId(ratingCriteriaId, AuthoredItemRatingCriteria.class);
                    }
                    case 3: {
                        return this.getByRatingCriteriaId(ratingCriteriaId, LearnerItemRatingCriteria.class);
                    }
                    case 4: {
                        return this.getByRatingCriteriaId(ratingCriteriaId, LessonRatingCriteria.class);
                    }
                }
            }
            throw new DataRetrievalFailureException("Unable to get RatingCriteria as the RatingCriteria type is unknown or missing. RatingCriteria type is " + criteriaType);
        }
        return null;
    }

    @Override
    public RatingCriteria getByRatingCriteriaId(Long ratingCriteriaId, Class clasz) {
        return (RatingCriteria)super.find(clasz, ratingCriteriaId);
    }
}

