/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.io.Serializable;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.security.ISecurityDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class SecurityDAO
extends HibernateDaoSupport
implements ISecurityDAO {
    private static final String CHECK_LESSON_MONITOR = "FROM " + Lesson.class.getName() + " AS lesson INNER JOIN lesson.lessonClass.staffGroup.users AS monitor " + "WHERE lesson.lessonId = ? AND monitor.userId = ?";
    private static final String CHECK_LESSON_LEARNER = "SELECT 1 FROM lams_lesson AS l JOIN lams_grouping AS ging ON l.lesson_id = ? AND l.class_grouping_id = ging.grouping_id JOIN lams_group AS g USING (grouping_id) JOIN lams_user_group AS ug USING (group_id) WHERE ug.user_id = ?";
    private static final String CHECK_ORG_ROLE = "FROM " + UserOrganisation.class.getName() + " AS userOrganisation INNER JOIN userOrganisation.userOrganisationRoles AS userOrganisationRole " + "WHERE userOrganisation.organisation.organisationId = :orgId AND userOrganisation.user.userId = :userId " + "AND userOrganisationRole.role.name IN (:roles)";
    private static final String CHECK_SYSADMIN = "FROM " + UserOrganisation.class.getName() + " AS userOrganisation INNER JOIN userOrganisation.userOrganisationRoles AS userOrganisationRole " + "WHERE userOrganisation.organisation.organisationType.organisationTypeId = 1 AND userOrganisation.user.userId = ? " + "AND userOrganisationRole.role.name = '" + "SYSADMIN" + "'";

    @Override
    public Object find(Class clazz, Serializable id) {
        return this.getHibernateTemplate().get(clazz, id);
    }

    @Override
    public boolean hasOrgRole(Integer orgId, Integer userId, String ... roles) {
        Query query = this.getHibernateTemplate().getSessionFactory().getCurrentSession().createQuery(CHECK_ORG_ROLE);
        query.setParameter("orgId", (Object)orgId);
        query.setParameter("userId", (Object)userId);
        query.setParameterList("roles", (Object[])roles);
        return !query.list().isEmpty();
    }

    @Override
    public boolean isGroupManager(Integer orgId, Integer userId) {
        Organisation organisation = (Organisation)this.find(Organisation.class, orgId);
        if (organisation == null) {
            return false;
        }
        if (OrganisationType.CLASS_TYPE.equals(organisation.getOrganisationType().getOrganisationTypeId())) {
            organisation = organisation.getParentOrganisation();
        }
        return this.hasOrgRole(organisation.getOrganisationId(), userId, "GROUP MANAGER");
    }

    @Override
    public boolean isLessonLearner(Long lessonId, Integer userId) {
        SQLQuery query = this.getHibernateTemplate().getSessionFactory().getCurrentSession().createSQLQuery(CHECK_LESSON_LEARNER);
        query.setLong(0, lessonId.longValue());
        query.setInteger(1, userId.intValue());
        return !query.list().isEmpty();
    }

    @Override
    public boolean isLessonMonitor(Long lessonId, Integer userId, boolean ownerAccepted) {
        boolean result = !this.getHibernateTemplate().find(CHECK_LESSON_MONITOR, new Object[]{lessonId, userId}).isEmpty();
        Lesson lesson = null;
        if (!result && ownerAccepted) {
            lesson = (Lesson)this.find(Lesson.class, lessonId);
            result = lesson != null && userId.equals(lesson.getUser().getUserId());
        }
        return result;
    }

    @Override
    public boolean isSysadmin(Integer userId) {
        return !this.getHibernateTemplate().find(CHECK_SYSADMIN, new Object[]{userId}).isEmpty();
    }
}

