/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes.dto;

import java.util.Hashtable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;

public class CSSThemeDTO
extends BaseDTO {
    protected Logger log = Logger.getLogger(CSSThemeDTO.class);
    public static final String ID_TAG = "id";
    public static final String NAME_TAG = "name";
    public static final String DESCRIPTION_TAG = "description";
    public static final String BASE_STYLE_OBJECT_TAG = "baseStyleObject";
    public static final String VISUAL_ELEMENTS_TAG = "visualElements";
    public static final String TEXT_FORMAT_TAG = "_tf";
    public static final String STYLE_OBJECT_TAG = "styleObject";
    private Long id;
    private String name;
    private String description;

    public CSSThemeDTO(Hashtable wddxData) throws WDDXProcessorConversionException {
        if (wddxData != null) {
            this.id = WDDXProcessor.convertToLong(wddxData, ID_TAG);
            this.name = WDDXProcessor.convertToString(wddxData, NAME_TAG);
            this.description = WDDXProcessor.convertToString(wddxData, DESCRIPTION_TAG);
        }
    }

    public CSSThemeDTO(Theme theme) {
        if (theme != null) {
            this.id = theme.getThemeId();
            this.name = theme.getName();
            this.description = theme.getDescription();
        }
    }

    public Theme createCSSThemeVisualElement() {
        Theme theme = new Theme();
        theme.setDescription(this.description);
        theme.setName(this.name);
        theme.setThemeId(this.id);
        return theme;
    }

    public Theme updateCSSTheme(Theme currentTheme) {
        currentTheme.setDescription(this.description);
        currentTheme.setName(this.name);
        return currentTheme;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(ID_TAG, (Object)this.id).append(NAME_TAG, (Object)this.name).append(DESCRIPTION_TAG, (Object)this.description).toString();
    }
}

