/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dto;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;

public class OrganisationDTOFactory {
    public static OrganisationDTO createTree(Collection<OrganisationDTO> orgs) {
        int count = 0;
        OrganisationDTO rootOrgDTO = null;
        Iterator<OrganisationDTO> it = orgs.iterator();
        while (it.hasNext()) {
            if (rootOrgDTO == null) {
                OrganisationDTO rt = new OrganisationDTO(new Integer(-1), new Integer(-1), "Root", "Root Description", new Integer(1));
                OrganisationDTO initial = it.next();
                rt.addNode(initial);
                rootOrgDTO = rt;
                continue;
            }
            OrganisationDTO organisationDTO = it.next();
            OrganisationDTO parent = OrganisationDTOFactory.findParent(rootOrgDTO, organisationDTO);
            if (parent != null) {
                rootOrgDTO = parent;
                continue;
            }
            rootOrgDTO.addNode(organisationDTO);
            ++count;
        }
        if (count > 0) {
            Vector<OrganisationDTO> nodes = rootOrgDTO.getNodes();
            Iterator<OrganisationDTO> i = nodes.iterator();
            while (i.hasNext()) {
                OrganisationDTO dto = i.next();
                OrganisationDTO parent = OrganisationDTOFactory.findParent(rootOrgDTO, dto);
                if (parent == null) continue;
                i.remove();
                rootOrgDTO = parent;
            }
        }
        return rootOrgDTO;
    }

    private static OrganisationDTO findParent(OrganisationDTO root, OrganisationDTO tmp) {
        if (OrganisationDTOFactory.checkNodes(root, tmp)) {
            return root;
        }
        return null;
    }

    private static boolean checkNodes(OrganisationDTO root, OrganisationDTO tmp) {
        if (root.equals(tmp)) {
            return false;
        }
        Vector<OrganisationDTO> nodes = root.getNodes();
        if (nodes.size() > 0) {
            Iterator<OrganisationDTO> it = nodes.iterator();
            while (it.hasNext()) {
                OrganisationDTO child = it.next();
                if (child.getOrganisationID().equals(tmp.getParentID())) {
                    child.addNode(tmp);
                    return true;
                }
                if (child.getParentID().equals(tmp.getOrganisationID())) {
                    OrganisationDTO temp = child;
                    it.remove();
                    tmp.addNode(temp);
                    root.addNode(tmp);
                    return true;
                }
                if (!OrganisationDTOFactory.checkNodes(child, tmp)) continue;
                return true;
            }
        }
        return false;
    }
}

