/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.dto.BranchConditionDTO;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputValue;

public class BranchCondition
implements Comparable {
    public static final String OUTPUT_TYPE_STRING = "OUTPUT_STRING";
    public static final String OUTPUT_TYPE_BOOLEAN = "OUTPUT_BOOLEAN";
    public static final String OUTPUT_TYPE_DOUBLE = "OUTPUT_DOUBLE";
    public static final String OUTPUT_TYPE_LONG = "OUTPUT_LONG";
    public static final String OUTPUT_TYPE_COMPLEX = "OUTPUT_COMPLEX";
    private static Logger log = Logger.getLogger(BranchCondition.class);
    protected Long conditionId;
    protected Integer conditionUIID;
    protected Integer orderId;
    protected String name;
    protected String displayName;
    protected String type;
    protected String startValue;
    protected String endValue;
    protected String exactMatchValue;

    public BranchCondition() {
    }

    public BranchCondition(Long conditionId, Integer conditionUIID, Integer orderId, String name, String displayName, String type, String startValue, String endValue, String exactMatchValue) {
        this.conditionId = conditionId;
        this.conditionUIID = conditionUIID;
        this.orderId = orderId;
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.startValue = startValue;
        this.endValue = endValue;
        this.exactMatchValue = exactMatchValue;
    }

    public BranchCondition(BranchConditionDTO conditionDTO) {
        this(conditionDTO.getConditionId(), conditionDTO.getConditionUIID(), conditionDTO.getOrderID(), conditionDTO.getName(), conditionDTO.getDisplayName(), conditionDTO.getType(), conditionDTO.getStartValue(), conditionDTO.getEndValue(), conditionDTO.getExactMatchValue());
    }

    public Long getConditionId() {
        return this.conditionId;
    }

    public void setConditionId(Long conditionId) {
        this.conditionId = conditionId;
    }

    public Integer getConditionUIID() {
        return this.conditionUIID;
    }

    public void setConditionUIID(Integer conditionUIID) {
        this.conditionUIID = conditionUIID;
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStartValue() {
        return this.startValue;
    }

    public void setStartValue(String startValue) {
        this.startValue = startValue;
    }

    public String getEndValue() {
        return this.endValue;
    }

    public void setEndValue(String endValue) {
        this.endValue = endValue;
    }

    public String getExactMatchValue() {
        return this.exactMatchValue;
    }

    public void setExactMatchValue(String exactMatchValue) {
        this.exactMatchValue = exactMatchValue;
    }

    public BranchConditionDTO getBranchConditionDTO(Integer toolActivityUIID) {
        return new BranchConditionDTO(this, toolActivityUIID);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("conditionId", (Object)this.conditionId).append("conditionUIID", (Object)this.conditionUIID).append("orderId", (Object)this.orderId).append("name", (Object)this.name).append("displayName", (Object)this.displayName).append("type", (Object)this.type).append("startValue", (Object)this.startValue).append("endValue", (Object)this.endValue).append("exactMatchValue", (Object)this.exactMatchValue).toString();
    }

    public BranchActivityEntry allocateBranchToCondition(Integer entryUIID, SequenceActivity branch, Activity outputBasedActivity) {
        BranchActivityEntry entry = new BranchActivityEntry(null, entryUIID, branch, outputBasedActivity, this);
        return entry;
    }

    public BranchCondition clone(int uiidOffset) {
        Integer newConditionUIID = LearningDesign.addOffset(this.conditionUIID, uiidOffset);
        return new BranchCondition(null, newConditionUIID, this.orderId, this.name, this.displayName, this.type, this.startValue, this.endValue, this.exactMatchValue);
    }

    public Object clone() {
        return new BranchCondition(null, null, this.orderId, this.name, this.displayName, this.type, this.startValue, this.endValue, this.exactMatchValue);
    }

    public int compareTo(Object arg0) {
        BranchCondition other = (BranchCondition)arg0;
        return new CompareToBuilder().append((Object)this.orderId, (Object)other.getOrderId()).append((Object)this.conditionId, (Object)other.getConditionId()).append((Object)this.name, (Object)other.getName()).append((Object)this.conditionUIID, (Object)other.getConditionUIID()).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.orderId).append((Object)this.conditionId).append((Object)this.name).append((Object)this.conditionUIID).toHashCode();
    }

    public boolean equals(Object arg0) {
        BranchCondition other = (BranchCondition)arg0;
        return new EqualsBuilder().append((Object)this.orderId, (Object)other.getOrderId()).append((Object)this.conditionId, (Object)other.getConditionId()).append((Object)this.name, (Object)other.getName()).append((Object)this.conditionUIID, (Object)other.getConditionUIID()).isEquals();
    }

    public boolean isMet(ToolOutput output) {
        if (output != null) {
            if (this.exactMatchValue != null) {
                return this.exactMatchMet(output.getValue());
            }
            if (this.startValue != null || this.endValue != null) {
                return this.inRange(output.getValue());
            }
        }
        return false;
    }

    public boolean exactMatchMet(ToolOutputValue outputValue) {
        if (OUTPUT_TYPE_LONG.equals(this.type)) {
            Long exactMatchObj = this.exactMatchValue != null ? this.convertToLong(this.exactMatchValue) : null;
            Long actualValue = outputValue.getLong();
            return actualValue != null && actualValue.equals(exactMatchObj);
        }
        if (OUTPUT_TYPE_DOUBLE.equals(this.type)) {
            Double exactMatchObj = this.exactMatchValue != null ? Double.valueOf(Double.parseDouble(this.exactMatchValue)) : null;
            Double actualValue = outputValue.getDouble();
            return actualValue != null && actualValue.equals(exactMatchObj);
        }
        if (OUTPUT_TYPE_BOOLEAN.equals(this.type)) {
            Boolean exactMatchObj = this.exactMatchValue != null ? Boolean.valueOf(Boolean.parseBoolean(this.exactMatchValue)) : null;
            Boolean actualValue = outputValue.getBoolean();
            return actualValue != null && actualValue.equals(exactMatchObj);
        }
        if (OUTPUT_TYPE_STRING.equals(this.type)) {
            Double actualValue = outputValue.getDouble();
            return actualValue != null && actualValue.equals(this.exactMatchValue);
        }
        return false;
    }

    public boolean inRange(ToolOutputValue outputValue) {
        if (OUTPUT_TYPE_LONG.equals(this.type)) {
            Long startValueLong = this.startValue != null ? this.convertToLong(this.startValue) : null;
            Long endValueLong = this.endValue != null ? this.convertToLong(this.endValue) : null;
            Long actualValue = outputValue.getLong();
            return !(actualValue == null || startValueLong != null && actualValue.compareTo(startValueLong) < 0 || endValueLong != null && actualValue.compareTo(endValueLong) > 0);
        }
        if (OUTPUT_TYPE_DOUBLE.equals(this.type)) {
            Double startValueDouble = this.startValue != null ? Double.valueOf(Double.parseDouble(this.startValue)) : null;
            Double endValueDouble = this.endValue != null ? Double.valueOf(Double.parseDouble(this.endValue)) : null;
            Double actualValue = outputValue.getDouble();
            return !(actualValue == null || startValueDouble != null && actualValue.compareTo(startValueDouble) < 0 || endValueDouble != null && actualValue.compareTo(endValueDouble) > 0);
        }
        if (OUTPUT_TYPE_BOOLEAN.equals(this.type)) {
            Boolean startValueBoolean = this.startValue != null ? Boolean.valueOf(Boolean.parseBoolean(this.startValue)) : null;
            Boolean endValueBoolean = this.endValue != null ? Boolean.valueOf(Boolean.parseBoolean(this.endValue)) : null;
            Boolean actualValue = outputValue.getBoolean();
            return !(actualValue == null || startValueBoolean != null && actualValue.compareTo(startValueBoolean) < 0 || endValueBoolean != null && actualValue.compareTo(endValueBoolean) > 0);
        }
        if (OUTPUT_TYPE_STRING.equals(this.type)) {
            String actualValue = outputValue.getString();
            return !(actualValue == null || this.startValue != null && actualValue.compareTo(this.startValue) < 0 || this.endValue != null && actualValue.compareTo(this.endValue) > 0);
        }
        return false;
    }

    private Long convertToLong(String textValue) {
        if (textValue.length() == 0) {
            return null;
        }
        int posPeriod = textValue.indexOf(46);
        if (posPeriod > 0) {
            textValue = textValue.substring(0, posPeriod);
        }
        return new Long(textValue);
    }

    protected boolean isValid() {
        if (this.exactMatchValue != null) {
            try {
                if (this.getTypedValue(this.exactMatchValue) != null) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)("Condition contains an unconvertible value for exactMatchValue. Type is " + this.type + " value " + this.exactMatchValue));
            return false;
        }
        Comparable typedStartValue = null;
        Comparable typedEndValue = null;
        try {
            if (this.startValue != null) {
                typedStartValue = this.getTypedValue(this.startValue);
            }
        }
        catch (Exception e) {
            log.error((Object)("Condition contains an unconvertible value for startValue. Type is " + this.type + " value " + this.startValue));
            return false;
        }
        try {
            if (this.endValue != null) {
                typedEndValue = this.getTypedValue(this.endValue);
            }
        }
        catch (Exception e) {
            log.error((Object)("Condition contains an unconvertible value for endValue. Type is " + this.type + " value " + this.endValue));
            return false;
        }
        if (typedStartValue == null && typedEndValue != null) {
            return true;
        }
        return typedEndValue == null || typedEndValue.compareTo(typedStartValue) >= 0;
    }

    private Comparable getTypedValue(String untypedValue) {
        if (OUTPUT_TYPE_LONG.equals(this.type)) {
            return this.convertToLong(untypedValue);
        }
        if (OUTPUT_TYPE_DOUBLE.equals(this.type)) {
            return Double.valueOf(Double.parseDouble(untypedValue));
        }
        if (OUTPUT_TYPE_BOOLEAN.equals(this.type)) {
            return Boolean.valueOf(Boolean.parseBoolean(untypedValue));
        }
        if (OUTPUT_TYPE_STRING.equals(this.type)) {
            return untypedValue;
        }
        return null;
    }
}

