/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouper;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.exception.GroupingException;
import org.lamsfoundation.lams.usermanagement.User;

public class LearnerChoiceGrouper
extends Grouper
implements Serializable {
    private static final long serialVersionUID = -8498560084860150033L;
    private static Logger log = Logger.getLogger(LearnerChoiceGrouper.class);

    public void doGrouping(Grouping learnerChoiceGrouping, String groupName, User learner) {
        ArrayList<User> learners = new ArrayList<User>();
        learners.add(learner);
        this.doGrouping(learnerChoiceGrouping, groupName, learners);
    }

    public void doGrouping(Grouping learnerChoiceGrouping, String groupName, List learners) {
        String trimmedName;
        Group selectedGroup = null;
        String string = trimmedName = groupName != null ? groupName.trim() : null;
        if (trimmedName == null || trimmedName.length() == 0) {
            trimmedName = this.generateGroupName(learnerChoiceGrouping);
        } else {
            Iterator iter = learnerChoiceGrouping.getGroups().iterator();
            while (iter.hasNext() && selectedGroup == null) {
                Group group = (Group)iter.next();
                if (!trimmedName.equals(group.getGroupName())) continue;
                selectedGroup = group;
            }
        }
        this.doGrouping(learnerChoiceGrouping, selectedGroup, trimmedName, learners);
    }

    private String generateGroupName(Grouping learnerChoiceGrouping) {
        String prefix = this.getPrefix();
        String trimmedName = prefix + " " + System.currentTimeMillis();
        log.info((Object)("Chosen grouper for grouping " + learnerChoiceGrouping.toString() + " did not get a group name. Selecting default name of " + trimmedName));
        return trimmedName;
    }

    public void doGrouping(Grouping learnerChoiceGrouping, Long groupId, List learners) throws GroupingException {
        if (groupId != null) {
            Iterator iter = learnerChoiceGrouping.getGroups().iterator();
            Group selectedGroup = null;
            while (iter.hasNext() && selectedGroup == null) {
                Group group = (Group)iter.next();
                if (!group.getGroupId().equals(groupId)) continue;
                selectedGroup = group;
            }
            if (selectedGroup == null) {
                String error = "Tried to add users to group " + groupId + " but group cannot be found.";
                log.error((Object)error);
                throw new GroupingException(error);
            }
            this.doGrouping(learnerChoiceGrouping, selectedGroup, null, learners);
        } else {
            String groupName = this.generateGroupName(learnerChoiceGrouping);
            this.doGrouping(learnerChoiceGrouping, null, groupName, learners);
        }
    }

    private void doGrouping(Grouping learnerChoiceGrouping, Group group, String groupName, List learners) {
        if (group != null) {
            group.getUsers().addAll(learners);
        } else {
            learnerChoiceGrouping.getGroups().add(Group.createLearnerGroup(learnerChoiceGrouping, groupName, new HashSet(learners)));
        }
    }

    public Group createGroup(Grouping grouping, String name) throws GroupingException {
        int currentSize = grouping.getGroups().size();
        if (grouping.getMaxNumberOfGroups() != null && currentSize == grouping.getMaxNumberOfGroups()) {
            String error = "Tried to add group " + name + " to grouping " + grouping + ". Exceeded max number of groups - current size is " + currentSize;
            log.error((Object)error);
            throw new GroupingException(error);
        }
        return super.createGroup(grouping, name);
    }

    public void createGroups(LearnerChoiceGrouping learnerChoiceGrouping, int numOfGroupsTobeCreated) {
        String prefix = this.getPrefix();
        int size = learnerChoiceGrouping.getGroups().size();
        int numCreated = 0;
        int groupIndex = size + 1;
        while (numCreated < numOfGroupsTobeCreated) {
            String groupName = prefix + " " + new Integer(groupIndex).toString();
            Group newGroup = Group.createLearnerGroup(learnerChoiceGrouping, groupName, new HashSet());
            if (newGroup != null) {
                learnerChoiceGrouping.getGroups().add(newGroup);
                ++numCreated;
            }
            ++groupIndex;
        }
    }
}

