/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ITransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.ProgressActivityDTO;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dao.ILessonClassDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dto.LearnerProgressDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MonitoringService
implements IMonitoringService,
ApplicationContextAware {
    private static Logger log = Logger.getLogger(MonitoringService.class);
    private ILessonDAO lessonDAO;
    private ILessonClassDAO lessonClassDAO;
    private IOrganisationDAO organisationDAO;
    private ITransitionDAO transitionDAO;
    private IActivityDAO activityDAO;
    private IUserDAO userDAO;
    private IWorkspaceFolderDAO workspaceFolderDAO;
    private ILearningDesignDAO learningDesignDAO;
    private IAuthoringService authoringService;
    private ILamsCoreToolService lamsCoreToolService;
    private IUserManagementService userManagementService;
    private Scheduler scheduler;
    private ApplicationContext applicationContext;
    private ILearnerService learnerService;

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setWorkspaceFolderDAO(IWorkspaceFolderDAO workspaceFolderDAO) {
        this.workspaceFolderDAO = workspaceFolderDAO;
    }

    public void setTransitionDAO(ITransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public void setUserDAO(IUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setAuthoringService(IAuthoringService authoringService) {
        this.authoringService = authoringService;
    }

    public void setLessonClassDAO(ILessonClassDAO lessonClassDAO) {
        this.lessonClassDAO = lessonClassDAO;
    }

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsToolService) {
        this.lamsCoreToolService = lamsToolService;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setOrganisationDAO(IOrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public Lesson initializeLesson(String lessonName, String lessonDescription, long learningDesignId, User user) {
        LearningDesign originalLearningDesign = this.authoringService.getLearningDesign(new Long(learningDesignId));
        if (originalLearningDesign == null) {
            throw new MonitoringServiceException("Learning design for id=" + learningDesignId + " is missing. Unable to initialize lesson.");
        }
        LearningDesign copiedLearningDesign = this.authoringService.copyLearningDesign(originalLearningDesign, new Integer(2), user, originalLearningDesign.getWorkspaceFolder());
        for (Activity currentActivity : copiedLearningDesign.getActivities()) {
            String error;
            if (!currentActivity.isToolActivity()) continue;
            try {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(currentActivity.getActivityId());
                Long newContentId = this.lamsCoreToolService.notifyToolToCopyContent(toolActivity);
                toolActivity.setToolContentId(newContentId);
            }
            catch (DataMissingException e) {
                error = "Unable to initialise the lesson. Data is missing for activity " + currentActivity.getActivityUIID() + " in learning design " + learningDesignId + " default content may be missing for the tool. Error was " + e.getMessage();
                log.error((Object)error, (Throwable)e);
                throw new MonitoringServiceException(error, e);
            }
            catch (ToolException e) {
                error = "Unable to initialise the lesson. Tool encountered an error copying the data is missing for activity " + currentActivity.getActivityUIID() + " in learning design " + learningDesignId + " default content may be missing for the tool. Error was " + e.getMessage();
                log.error((Object)error, (Throwable)e);
                throw new MonitoringServiceException(error, e);
            }
        }
        this.authoringService.updateLearningDesign(copiedLearningDesign);
        return this.createNewLesson(lessonName, lessonDescription, user, copiedLearningDesign);
    }

    public Lesson createLessonClassForLesson(long lessonId, Organisation organisation, List organizationUsers, List staffs) {
        Lesson newLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (newLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to create class for lesson.");
        }
        LessonClass newLessonClass = this.createLessonClass(organisation, organizationUsers, staffs, newLesson);
        newLessonClass.setLesson(newLesson);
        newLesson.setLessonClass(newLessonClass);
        newLesson.setOrganisation(organisation);
        this.lessonDAO.updateLesson(newLesson);
        return newLesson;
    }

    public void startLesson(long lessonId) {
        Lesson requestedLesson;
        if (log.isDebugEnabled()) {
            log.debug((Object)("=============Starting Lesson " + lessonId + "=============="));
        }
        if ((requestedLesson = this.lessonDAO.getLesson(new Long(lessonId))) == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to start lesson.");
        }
        Date lessonStartTime = new Date();
        Set activities = requestedLesson.getLearningDesign().getActivities();
        for (Activity activity : activities) {
            ToolActivity toolActivity;
            if (activity.getActivityTypeId() == 1 && this.shouldInitToolSessionFor(toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId()))) {
                this.initToolSessionFor((ToolActivity)activity, requestedLesson.getAllLearners(), requestedLesson);
            }
            if (activity.getActivityTypeId() != 4) continue;
            ScheduleGateActivity gateActivity = (ScheduleGateActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
            this.runGateScheduler(gateActivity, lessonStartTime);
        }
        requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
        requestedLesson.setStartDateTime(lessonStartTime);
        this.lessonDAO.updateLesson(requestedLesson);
        if (log.isDebugEnabled()) {
            log.debug((Object)("=============Lesson " + lessonId + " started==============="));
        }
    }

    public void archiveLesson(long lessonId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to start lesson.");
        }
        requestedLesson.setLessonStateId(Lesson.ARCHIVED_STATE);
        this.lessonDAO.updateLesson(requestedLesson);
    }

    public GateActivity openGate(Long gateId) {
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(gateId);
        if (gate != null) {
            gate.setGateOpen(new Boolean(true));
            this.activityDAO.update((Object)gate);
        }
        return gate;
    }

    public GateActivity closeGate(Long gateId) {
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(gateId);
        gate.setGateOpen(new Boolean(false));
        this.activityDAO.update((Object)gate);
        return gate;
    }

    public void forceCompleteLessonByUser(long learnerProgressId) {
    }

    public List getAllLessons() throws IOException {
        return this.lessonDAO.getAllLessons();
    }

    public String getAllLessonsWDDX() throws IOException {
        return this.requestLessonList(this.getAllLessons());
    }

    public List getAllLessons(Integer userID) throws IOException {
        return this.lessonDAO.getLessonsForUser(userID);
    }

    public String getAllLessonsWDDX(Integer userID) throws IOException {
        return this.requestLessonList(this.getAllLessons(userID));
    }

    public String getLessonDetails(Long lessonID) throws IOException {
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        FlashMessage flashMessage = lesson != null ? new FlashMessage("getLessonDetails", (Object)lesson.getLessonDetails()) : new FlashMessage("getLessonDetails", (Object)("No such Lesson with a lessonID of :" + lessonID + " exists."), 1);
        return flashMessage.serializeMessage();
    }

    public String getLessonLearners(Long lessonID) throws IOException {
        FlashMessage flashMessage;
        Vector<UserDTO> lessonLearners = new Vector<UserDTO>();
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            for (User user : lesson.getLessonClass().getLearners()) {
                lessonLearners.add(user.getUserDTO());
            }
            flashMessage = new FlashMessage("getLessonLearners", lessonLearners);
        } else {
            flashMessage = new FlashMessage("getLessonLearners", (Object)("No such lesson with a lesson_id of :" + lessonID + " exists"), 1);
        }
        return flashMessage.serializeMessage();
    }

    public String getLearningDesignDetails(Long lessonID) throws IOException {
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        return this.authoringService.getLearningDesignDetails(lesson.getLearningDesign().getLearningDesignId());
    }

    public String getAllLearnersProgress(Long lessonID) throws IOException {
        FlashMessage flashMessage;
        Vector<LearnerProgressDTO> progressData = new Vector<LearnerProgressDTO>();
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            for (LearnerProgress learnerProgress : lesson.getLearnerProgresses()) {
                progressData.add(learnerProgress.getLearnerProgressData());
            }
            flashMessage = new FlashMessage("getAllLearnersProgress", progressData);
        } else {
            flashMessage = new FlashMessage("getAllLearnersProgress", (Object)("No such lesson with a lesson_id of :" + lessonID + " exists"), 1);
        }
        return flashMessage.serializeMessage();
    }

    public Activity getActivityById(long activityId) {
        return this.activityDAO.getActivityByActivityId(new Long(activityId));
    }

    public String getAllContributeActivities(Long lessonID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            Vector sortedSet = this.getOrderedActivityTree(lesson.getLearningDesign());
            flashMessage = new FlashMessage("getAllContributeActivities", (Object)sortedSet);
        } else {
            flashMessage = new FlashMessage("getAllContributeActivities", (Object)("No such lesson with a lesson_id of " + lessonID + "exists"), 1);
        }
        return flashMessage.serializeMessage();
    }

    public String getLearnerActivityURL(Long activityID, Integer userID) throws IOException, LamsToolServiceException {
        FlashMessage flashMessage;
        Activity activity = this.activityDAO.getActivityByActivityId(activityID);
        User user = this.userDAO.getUserById(userID);
        if (activity == null || user == null) {
            flashMessage = new FlashMessage("getLearnerActivityURL", (Object)("Invalid activityID/User :" + activityID + " : " + userID), 1);
        } else if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String toolURL = this.lamsCoreToolService.getLearnerToolURLByMode(toolActivity, user, ToolAccessMode.TEACHER);
            flashMessage = new FlashMessage("getLearnerActivityURL", (Object)new ProgressActivityDTO(activityID, toolURL));
        } else {
            flashMessage = new FlashMessage("getLearnerActivityURL", (Object)("Invalid Activity type: " + activity.getActivityId() + "\n Only ToolActivity allowed."), 1);
        }
        return flashMessage.serializeMessage();
    }

    public String getActivityContributionURL(Long activityID) throws IOException {
        Activity activity = this.activityDAO.getActivityByActivityId(activityID);
        FlashMessage flashMessage = null;
        if (activity != null) {
            if (activity.isToolActivity()) {
                ToolActivity toolActivity = (ToolActivity)activity;
                String contributionURL = toolActivity.getTool().getContributeUrl();
                flashMessage = new FlashMessage("getActivityContributionURL", (Object)contributionURL);
            }
        } else {
            flashMessage = FlashMessage.getNoSuchActivityExists((String)"getActivityContributionURL", (Long)activityID);
        }
        return flashMessage.serializeMessage();
    }

    public String getActivityDefineLaterURL(Long activityID) throws IOException {
        Activity activity = this.activityDAO.getActivityByActivityId(activityID);
        FlashMessage flashMessage = null;
        if (activity != null) {
            if (activity.isToolActivity()) {
                ToolActivity toolActivity = (ToolActivity)activity;
                String url = toolActivity.getTool().getDefineLaterUrl();
                Long toolContentId = toolActivity.getToolContentId();
                if (url != null && toolContentId != null) {
                    url = WebUtil.appendParameterToURL((String)url, (String)"toolContentID", (String)toolActivity.getToolContentId().toString());
                    flashMessage = new FlashMessage("getActivityDefineLaterURL", (Object)new ProgressActivityDTO(activityID, url));
                } else {
                    flashMessage = this.generateDataMissingPacket(activityID, url, "Define Late URL", toolContentId, "Tool Content ID");
                }
            }
        } else {
            flashMessage = FlashMessage.getNoSuchActivityExists((String)"getActivityDefineLaterURL", (Long)activityID);
        }
        return flashMessage.serializeMessage();
    }

    public String getActivityMonitorURL(Long activityID) throws IOException {
        Activity activity = this.activityDAO.getActivityByActivityId(activityID);
        FlashMessage flashMessage = null;
        if (activity != null) {
            if (activity.isToolActivity()) {
                ToolActivity toolActivity = (ToolActivity)activity;
                String url = toolActivity.getTool().getMonitorUrl();
                Long toolContentId = toolActivity.getToolContentId();
                if (url != null && toolContentId != null) {
                    url = WebUtil.appendParameterToURL((String)url, (String)"toolContentID", (String)toolActivity.getToolContentId().toString());
                    flashMessage = new FlashMessage("getActivityMonitorURL", (Object)new ProgressActivityDTO(activityID, url));
                } else {
                    flashMessage = this.generateDataMissingPacket(activityID, url, "Monitor URL", toolContentId, "Tool Content ID");
                }
            }
        } else {
            flashMessage = FlashMessage.getNoSuchActivityExists((String)"getActivityMonitorURL", (Long)activityID);
        }
        return flashMessage.serializeMessage();
    }

    private FlashMessage generateDataMissingPacket(Long activityID, String url, String urlDescription, Long toolContentId, String toolContentIdDescription) {
        String[] missing = null;
        if (url != null && toolContentId != null) {
            missing = new String[]{urlDescription, toolContentIdDescription};
        } else if (url != null) {
            missing = new String[]{urlDescription};
        } else if (toolContentId != null) {
            missing = new String[]{toolContentIdDescription};
        }
        return FlashMessage.getDataMissing((String)"getActivityMonitorURL", missing);
    }

    public String moveLesson(Long lessonID, Integer targetWorkspaceFolderID, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            if (lesson.getUser().getUserId().equals(userID)) {
                WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(targetWorkspaceFolderID);
                if (workspaceFolder != null) {
                    LearningDesign learningDesign = lesson.getLearningDesign();
                    learningDesign.setWorkspaceFolder(workspaceFolder);
                    this.learningDesignDAO.update((Object)learningDesign);
                    flashMessage = new FlashMessage("moveLesson", (Object)targetWorkspaceFolderID);
                } else {
                    flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"moveLesson", (Integer)targetWorkspaceFolderID);
                }
            } else {
                flashMessage = FlashMessage.getUserNotAuthorized((String)"moveLesson", (Integer)userID);
            }
        } else {
            flashMessage = new FlashMessage("moveLesson", (Object)("No such lesson with a lesson_id of :" + lessonID + " exists."), 1);
        }
        return flashMessage.serializeMessage();
    }

    public String renameLesson(Long lessonID, String newName, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            if (lesson.getUser().getUserId().equals(userID)) {
                lesson.setLessonName(newName);
                this.lessonDAO.updateLesson(lesson);
                flashMessage = new FlashMessage("renameLesson", (Object)newName);
            } else {
                flashMessage = FlashMessage.getUserNotAuthorized((String)"renameLesson", (Integer)userID);
            }
        } else {
            flashMessage = new FlashMessage("renameLesson", (Object)("No such lesson with a lesson_id of :" + lessonID + " exists."), 1);
        }
        return flashMessage.serializeMessage();
    }

    public String checkGateStatus(Long activityID, Long lessonID) throws IOException {
        FlashMessage flashMessage;
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(activityID);
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (gate == null || lesson == null) {
            flashMessage = new FlashMessage("checkGateStatus", (Object)("Invalid activityID/lessonID :" + activityID + " : " + lessonID), 1);
        } else {
            Hashtable table = new Hashtable();
            table = this.createGateStatusInfo(activityID, gate);
            flashMessage = new FlashMessage("checkGateStatus", (Object)table);
        }
        return flashMessage.serializeMessage();
    }

    public String releaseGate(Long activityID) throws IOException {
        FlashMessage flashMessage;
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(activityID);
        if (gate == null) {
            flashMessage = new FlashMessage("releaseGate", (Object)("Invalid activityID :" + activityID), 1);
        } else {
            gate = this.openGate(activityID);
            flashMessage = new FlashMessage("releaseGate", (Object)gate.getGateOpen());
        }
        return flashMessage.serializeMessage();
    }

    private LessonClass createLessonClass(Organisation organisation, List organizationUsers, List staffs, Lesson newLesson) {
        LessonClass newLessonClass = this.createNewLessonClass(newLesson.getLearningDesign());
        this.lessonClassDAO.saveLessonClass(newLessonClass);
        newLessonClass.setStaffGroup(Group.createStaffGroup((Grouping)newLessonClass, new HashSet(staffs)));
        newLessonClass.getGroups().add(Group.createLearnerGroup((Grouping)newLessonClass, new HashSet(organizationUsers)));
        this.lessonClassDAO.updateLessonClass(newLessonClass);
        return newLessonClass;
    }

    private Lesson createNewLesson(String lessonName, String lessonDescription, User user, LearningDesign copiedLearningDesign) {
        Lesson newLesson = Lesson.createNewLessonWithoutClass((String)lessonName, (String)lessonDescription, (User)user, (LearningDesign)copiedLearningDesign);
        this.lessonDAO.saveLesson(newLesson);
        return newLesson;
    }

    private LessonClass createNewLessonClass(LearningDesign copiedLearningDesign) {
        HashSet activities = new HashSet(copiedLearningDesign.getActivities());
        LessonClass newLessonClass = new LessonClass(null, new HashSet(), activities, null, null);
        return newLessonClass;
    }

    private void initToolSessionFor(ToolActivity activity, Set learners, Lesson lesson) {
        activity.setToolSessions(new HashSet());
        try {
            for (User learner : learners) {
                ToolSession toolSession = this.lamsCoreToolService.createToolSession(learner, activity, lesson);
                this.lamsCoreToolService.notifyToolsToCreateSession(toolSession.getToolSessionId(), activity);
                activity.getToolSessions().add(toolSession);
            }
        }
        catch (LamsToolServiceException e) {
            String error = "Unable to initialise tool session. Fail to call tool services. Error was " + e.getMessage();
            log.error((Object)error, (Throwable)e);
            throw new MonitoringServiceException(error, e);
        }
        catch (ToolException e) {
            String error = "Unable to initialise tool session. Tool encountered an error. Error was " + e.getMessage();
            log.error((Object)error, (Throwable)e);
            throw new MonitoringServiceException(error, e);
        }
    }

    private boolean shouldInitToolSessionFor(ToolActivity activity) {
        return activity.getApplyGrouping() == false;
    }

    private String requestLessonList(List lessons) throws IOException {
        Vector<LessonDTO> lessonObjects = new Vector<LessonDTO>();
        for (Lesson lesson : lessons) {
            lessonObjects.add(lesson.getLessonData());
        }
        FlashMessage flashMessage = new FlashMessage("getAllLessons", lessonObjects);
        return flashMessage.serializeMessage();
    }

    private Vector getOrderedActivityTree(LearningDesign learningDesign) {
        int order = 0;
        HashMap activityTree = learningDesign.getActivityTree();
        Vector activityVector = new Vector();
        Activity nextActivity = learningDesign.getFirstActivity();
        while (nextActivity != null) {
            order = this.addActivityToVector(order, activityTree, activityVector, nextActivity);
            nextActivity = this.transitionDAO.getNextActivity(nextActivity.getActivityId());
        }
        return activityVector;
    }

    private int addActivityToVector(int order, HashMap activityTree, Vector activityVector, Activity nextActivity) {
        nextActivity.setOrderId(new Integer(order));
        Set childActivities = (Set)activityTree.get(nextActivity.getActivityId());
        if (childActivities.size() != 0) {
            for (Activity simpleActivity : childActivities) {
                activityVector.add(simpleActivity.getMonitoringActivityDTO());
            }
        } else {
            activityVector.add(nextActivity.getMonitoringActivityDTO());
        }
        return order + 1;
    }

    private void runGateScheduler(ScheduleGateActivity scheduleGate, Date lessonStartTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running scheduler for gate " + scheduleGate.getActivityId() + "..."));
        }
        JobDetail openScheduleGateJob = this.getOpenScheduleGateJob();
        JobDetail closeScheduleGateJob = this.getCloseScheduleGateJob();
        openScheduleGateJob.setName("openGate");
        openScheduleGateJob.getJobDataMap().put((Object)"gateId", (Object)scheduleGate.getActivityId());
        closeScheduleGateJob.setName("closeGate");
        closeScheduleGateJob.getJobDataMap().put((Object)"gateId", (Object)scheduleGate.getActivityId());
        SimpleTrigger openGateTrigger = new SimpleTrigger("openGateTrigger", "DEFAULT", scheduleGate.getLessonGateOpenTime(lessonStartTime));
        SimpleTrigger closeGateTrigger = new SimpleTrigger("closeGateTrigger", "DEFAULT", scheduleGate.getLessonGateCloseTime(lessonStartTime));
        try {
            this.scheduler.scheduleJob(openScheduleGateJob, (Trigger)openGateTrigger);
            this.scheduler.scheduleJob(closeScheduleGateJob, (Trigger)closeGateTrigger);
        }
        catch (SchedulerException e) {
            throw new MonitoringServiceException("Error occurred at [runGateScheduler]- fail to start scheduling", e);
        }
        this.activityDAO.update((Object)scheduleGate);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduler for Gate " + scheduleGate.getActivityId() + " started..."));
        }
    }

    private JobDetail getOpenScheduleGateJob() {
        return (JobDetail)this.applicationContext.getBean("openScheduleGateJob");
    }

    private JobDetail getCloseScheduleGateJob() {
        return (JobDetail)this.applicationContext.getBean("closeScheduleGateJob");
    }

    private Hashtable createGateStatusInfo(Long activityID, GateActivity gate) {
        Hashtable<String, Serializable> table = new Hashtable<String, Serializable>();
        table.put("activityID", activityID);
        table.put("activityTypeID", gate.getActivityTypeId());
        table.put("gateOpen", gate.getGateOpen());
        table.put("activityLevelID", gate.getGateActivityLevelId());
        table.put("learnersWaiting", new Integer(gate.getWaitingLearners().size()));
        if (gate.isScheduleGate()) {
            ScheduleGateActivity scheduleGate = (ScheduleGateActivity)gate;
            table.put("gateStartTime", scheduleGate.getGateStartDateTime());
            table.put("gateEndTime", scheduleGate.getGateEndDateTime());
        }
        return table;
    }

    public List getOrganisationsUsers(Integer userId) {
        User user = this.userManagementService.getUserById(userId);
        List orgs = this.userManagementService.getOrganisationsForUserByRole(user, "STAFF");
        for (Organisation element : orgs) {
            element.getUsers();
        }
        return orgs;
    }

    public List getLearningDesigns(Long userId) {
        return this.learningDesignDAO.getLearningDesignByUserId(userId);
    }
}

