/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.monitoring.web.DummyForm;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DummyMonitoringAction
extends LamsDispatchAction {
    private IMonitoringService monitoringService;
    private IUserManagementService usermanageService;
    private static final String CONTROL_FORWARD = "control";
    private static final String DETAIL_FORWARD = "detail";
    private static final String START_LESSON_FORWARD = "start";
    private static final String LESSON_STARTED_FORWARD = "started";
    private static final String LESSON_PARAMETER = "lesson";
    private static final String LESSONS_PARAMETER = "lessons";
    private static final String ACTIVITIES_PARAMETER = "activities";
    private static final String ORGS_PARAMETER = "organisations";
    private static final String DESIGNS_PARAMETER = "designs";

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.setupServices();
        User user = this.getUser();
        List lessons = this.monitoringService.getAllLessons(user.getUserId());
        request.getSession().setAttribute(LESSONS_PARAMETER, (Object)lessons);
        return mapping.findForward(CONTROL_FORWARD);
    }

    public ActionForward initStartScreen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.setupServices();
        User user = this.getUser();
        List designs = this.monitoringService.getLearningDesigns(new Long(user.getUserId().longValue()));
        request.getSession().setAttribute(DESIGNS_PARAMETER, (Object)designs);
        List organisations = this.monitoringService.getOrganisationsUsers(user.getUserId());
        request.getSession().setAttribute(ORGS_PARAMETER, (Object)organisations);
        return mapping.findForward(START_LESSON_FORWARD);
    }

    public ActionForward startLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String desc;
        this.setupServices();
        DummyForm dummyForm = (DummyForm)form;
        User user = this.getUser();
        Long ldId = dummyForm.getLearningDesignId();
        if (ldId == null) {
            throw new IOException("Learning design id must be set");
        }
        Integer organisationId = dummyForm.getOrganisationId();
        if (organisationId == null) {
            throw new IOException("Organisation must be set");
        }
        Organisation organisation = this.usermanageService.getOrganisationById(organisationId);
        if (organisation == null) {
            throw new IOException("Organisation cannot be found. Id was " + organisationId);
        }
        String title = dummyForm.getTitle();
        if (title == null) {
            title = LESSON_PARAMETER;
        }
        if ((desc = dummyForm.getDesc()) == null) {
            desc = "description";
        }
        Lesson testLesson = this.monitoringService.initializeLesson(title, desc, ldId, user);
        LinkedList<User> learners = new LinkedList<User>();
        Iterator iter = organisation.getUsers().iterator();
        learners.add(user);
        while (iter.hasNext()) {
            User element = (User)iter.next();
            learners.add(element);
        }
        LinkedList<User> staffs = new LinkedList<User>();
        staffs.add(user);
        testLesson = this.monitoringService.createLessonClassForLesson(testLesson.getLessonId(), organisation, learners, staffs);
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        this.monitoringService.startLesson(testLesson.getLessonId());
        return mapping.findForward(LESSON_STARTED_FORWARD);
    }

    public ActionForward archiveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        this.monitoringService.archiveLesson(lessonId);
        return this.unspecified(mapping, form, request, response);
    }

    public ActionForward getLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.setupServices();
        User user = this.getUser();
        Long lessonId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        List lessons = this.monitoringService.getAllLessons(user.getUserId());
        Iterator iter = lessons.iterator();
        boolean found = false;
        while (iter.hasNext() && !found) {
            Lesson element = (Lesson)iter.next();
            if (!element.getLessonId().equals(lessonId)) continue;
            Set activities = element.getLearningDesign().getActivities();
            HashSet<AuthoringActivityDTO> activityDTOSet = new HashSet<AuthoringActivityDTO>();
            HashSet<Long> processedActivityIds = new HashSet<Long>();
            for (Activity activity : activities) {
                Set dtos = activity.getAuthoringActivityDTOSet();
                for (AuthoringActivityDTO dto : dtos) {
                    if (processedActivityIds.contains(dto.getActivityID())) continue;
                    activityDTOSet.add(dto);
                    processedActivityIds.add(dto.getActivityID());
                }
            }
            request.getSession().setAttribute(LESSON_PARAMETER, (Object)element);
            request.getSession().setAttribute(ACTIVITIES_PARAMETER, activityDTOSet);
        }
        return mapping.findForward(DETAIL_FORWARD);
    }

    private void setupServices() {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        this.usermanageService = (IUserManagementService)wac.getBean("userManagementService");
    }

    private User getUser() throws IOException {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user != null) {
            return this.usermanageService.getUserById(user.getUserID());
        }
        throw new IOException("Unable to get user. User in session manager is " + user);
    }

    public ActionForward gotoLearnerActivityURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        String wddxPacket = this.monitoringService.getLearnerActivityURL(activityID, userID);
        String url = this.extractURL(wddxPacket);
        response.sendRedirect(response.encodeRedirectURL(url));
        return null;
    }

    public ActionForward gotoMonitoringActivityURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        String wddxPacket = this.monitoringService.getActivityMonitorURL(activityID);
        String url = this.extractURL(wddxPacket);
        response.sendRedirect(response.encodeRedirectURL(url));
        return null;
    }

    public ActionForward gotoDefineLaterActivityURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        String wddxPacket = this.monitoringService.getActivityDefineLaterURL(activityID);
        String url = this.extractURL(wddxPacket);
        response.sendRedirect(response.encodeRedirectURL(url));
        return null;
    }

    private String extractURL(String wddxPacket) {
        String url = null;
        String previousString = "<var name='activityURL'><string>";
        int index = wddxPacket.indexOf(previousString);
        if (index > -1 && index + previousString.length() < wddxPacket.length()) {
            url = wddxPacket.substring(index + previousString.length());
            index = url.indexOf("</string>");
            url = url.substring(0, index);
        }
        url = url.replace("&amp;", "&");
        url = WebUtil.convertToFullURL((String)url);
        return url;
    }
}

