/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class MonitoringAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(MonitoringAction.class);
    private IMonitoringService monitoringService;
    private static final String SCHEDULER = "scheduler";
    public static String USE_JSP_OUTPUT = "jspoutput";

    private ActionForward outputPacket(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, String wddxPacket, String parameterName) throws IOException {
        String useJSP = WebUtil.readStrParam((HttpServletRequest)request, (String)USE_JSP_OUTPUT, (boolean)true);
        if (useJSP != null && useJSP.length() >= 0) {
            request.getSession().setAttribute(parameterName, (Object)wddxPacket);
            return mapping.findForward("success");
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward startLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        this.monitoringService.startLesson(lessonId);
        return null;
    }

    public ActionForward archiveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        this.monitoringService.archiveLesson(lessonId);
        return null;
    }

    public ActionForward getAllLessons(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String wddxPacket = this.monitoringService.getAllLessonsWDDX();
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getLessonDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getLessonDetails(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getLessonLearners(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getLessonLearners(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getLearningDesignDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getLearningDesignDetails(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getAllLearnersProgress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getAllLearnersProgress(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getAllContributeActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.getAllContributeActivities(lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getLearnerActivityURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        String wddxPacket = this.monitoringService.getLearnerActivityURL(activityID, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getActivityContributionURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        String wddxPacket = this.monitoringService.getActivityContributionURL(activityID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward moveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Integer targetWorkspaceFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID"));
        String wddxPacket = this.monitoringService.moveLesson(lessonID, targetWorkspaceFolderID, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward renameLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
        String wddxPacket = this.monitoringService.renameLesson(lessonID, name, userID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward checkGateStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String wddxPacket = this.monitoringService.checkGateStatus(activityID, lessonID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward releaseGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        String wddxPacket = this.monitoringService.releaseGate(activityID);
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }
}

