/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.template;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.authoring.template.AssessMCAnswer;
import org.lamsfoundation.lams.authoring.template.TextUtil;
import org.lamsfoundation.lams.rest.RestTags;

public class Assessment {
    public static final short ASSESSMENT_QUESTION_TYPE_MULTIPLE_CHOICE = 1;
    public static final short ASSESSMENT_QUESTION_TYPE_ESSAY = 6;
    short type = (short)6;
    String title = null;
    String questionText = null;
    Boolean required = false;
    List<AssessMCAnswer> answers = null;

    public void setType(short type) {
        this.type = type;
        if (type == 1 && this.answers == null) {
            this.answers = new LinkedList<AssessMCAnswer>();
        }
    }

    public void setType(String type) {
        if (type != null && type.equalsIgnoreCase("mcq")) {
            this.setType((short)1);
        } else {
            this.setType((short)6);
        }
    }

    public short getType() {
        return this.type;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setQuestionText(String questionText) {
        this.questionText = questionText;
    }

    public String getQuestionText() {
        return this.questionText;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<AssessMCAnswer> getAnswers() {
        return this.answers;
    }

    public JSONObject getAsJSONObject(int displayOrder) throws JSONException {
        JSONObject json = new JSONObject();
        json.put(RestTags.QUESTION_TITLE, (Object)(this.title != null ? this.title : ""));
        json.put(RestTags.QUESTION_TEXT, (Object)(this.questionText != null ? this.questionText : ""));
        json.put(RestTags.DISPLAY_ORDER, displayOrder);
        json.put("answerRequired", (Object)this.required);
        if (this.type == 1) {
            json.put("type", 1);
            JSONArray answersJSON = new JSONArray();
            for (AssessMCAnswer answer : this.answers) {
                answersJSON.put((Object)answer.getAsJSONObject());
            }
            json.put(RestTags.ANSWERS, (Object)answersJSON);
        } else {
            json.put("type", 6);
        }
        return json;
    }

    private List<String> addError(List<String> errorMessages, String errorMessage) {
        if (errorMessages == null) {
            errorMessages = new ArrayList<String>();
        }
        errorMessages.add(errorMessage);
        return errorMessages;
    }

    public List<String> validate(ResourceBundle appBundle, MessageFormat formatter, Integer questionNumber) {
        List<String> errorMessages = null;
        if (this.questionText == null || this.questionText.length() == 0) {
            errorMessages = this.addError(errorMessages, TextUtil.getText(appBundle, formatter, "authoring.error.application.exercise.num", new Object[]{questionNumber}));
        }
        if (this.type == 1) {
            if (this.answers.size() == 0) {
                errorMessages = this.addError(errorMessages, TextUtil.getText(appBundle, formatter, "authoring.error.application.exercise.must.have.answer.num", new Object[]{questionNumber}));
            } else {
                boolean found100percent = false;
                for (AssessMCAnswer answer : this.answers) {
                    if (answer.getGrade().floatValue() != 1.0f) continue;
                    found100percent = true;
                    break;
                }
                if (!found100percent) {
                    errorMessages = this.addError(errorMessages, TextUtil.getText(appBundle, formatter, "authoring.error.application.exercise.must.have.100.percent", new Object[]{questionNumber}));
                }
            }
        }
        return errorMessages;
    }
}

