/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.template;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.authoring.template.TextUtil;
import org.lamsfoundation.lams.util.WebUtil;

public class TemplateData {
    protected Locale locale;
    protected ResourceBundle msgBundle;
    protected ResourceBundle appBundle;
    protected MessageFormat formatter;
    protected List<String> errorMessages;

    public TemplateData(HttpServletRequest request, String templateCode) {
        this.locale = request.getLocale();
        this.formatter = TextUtil.getFormatter(this.locale);
        this.msgBundle = TextUtil.getBoilerplateBundle(this.locale, templateCode);
        this.appBundle = TextUtil.getBoilerplateBundle(this.locale, null);
        this.errorMessages = new ArrayList<String>();
    }

    public MessageFormat getFormatter() {
        return this.formatter;
    }

    public ResourceBundle getBoilerplateBundle() {
        return this.msgBundle;
    }

    public ResourceBundle getUIBundle() {
        return this.appBundle;
    }

    public String getText(String key) {
        return TextUtil.getText(this.msgBundle, key);
    }

    public String getText(String key, Object[] parameters) {
        return TextUtil.getText(this.msgBundle, this.formatter, key, parameters);
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    protected String getTrimmedString(HttpServletRequest request, String parameterName, boolean fromCKEditor) {
        String string = request.getParameter(parameterName);
        if (string != null && (fromCKEditor ? WebUtil.removeHTMLtags((String)string).length() > 0 : (string = string.trim()).length() > 0)) {
            return string;
        }
        return null;
    }

    protected void addValidationErrorMessage(String key, Object[] params) {
        this.errorMessages.add(params != null ? TextUtil.getText(this.appBundle, this.formatter, key, params) : TextUtil.getText(this.appBundle, key));
    }

    protected void addValidationErrorMessages(List<String> newErrors) {
        if (newErrors != null) {
            if (this.errorMessages == null) {
                this.errorMessages = newErrors;
            } else {
                this.errorMessages.addAll(newErrors);
            }
        }
    }

    protected JSONArray getForumTopics(HttpServletRequest request, Integer numTopics) throws JSONException {
        JSONArray forumTopics = new JSONArray();
        for (int i = 1; i < numTopics + 1; ++i) {
            String subject = this.getTrimmedString(request, "forum" + i + "Subject", false);
            String body = this.getTrimmedString(request, "forum" + i + "Body", false);
            if (subject == null || subject.length() <= 0 || body == null || body.length() <= 0) continue;
            JSONObject topic = new JSONObject();
            topic.put("subject", (Object)subject);
            topic.put("body", (Object)body);
            forumTopics.put((Object)topic);
        }
        return forumTopics;
    }

    protected List<String[]> getUrls(HttpServletRequest request, String numUrlParameter, String urlParameterPrefix, String urlTitleParameterPrefix) {
        Integer numUrls = WebUtil.readIntParam((HttpServletRequest)request, (String)numUrlParameter);
        ArrayList<String[]> returnVal = new ArrayList<String[]>();
        for (int i = 1; i < numUrls + 1; ++i) {
            String url = this.getTrimmedString(request, urlParameterPrefix + i, false);
            if (url != null && url.equalsIgnoreCase("http://")) {
                url = null;
            }
            String urlTitle = this.getTrimmedString(request, urlTitleParameterPrefix + i, false);
            if (url == null) continue;
            String[] urlTuple = new String[]{urlTitle != null ? urlTitle : url, url};
            returnVal.add(urlTuple);
        }
        return returnVal;
    }

    protected List<String> getQuestions(HttpServletRequest request) {
        Integer numQuestions = WebUtil.readIntParam((HttpServletRequest)request, (String)"numQuestions");
        ArrayList<String> returnVal = new ArrayList<String>();
        for (int i = 1; i < numQuestions + 1; ++i) {
            String question = this.getTrimmedString(request, "question" + i, false);
            if (question == null || question.length() <= 0) continue;
            returnVal.add(question);
        }
        return returnVal;
    }
}

