/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.template;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class TextUtil {
    private static Logger log = Logger.getLogger(TextUtil.class);

    public static String getText(ResourceBundle msgBundle, MessageFormat formatter, String key, Object[] parameters) {
        String txt = null;
        try {
            txt = msgBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (txt == null || txt.isEmpty()) {
            log.error((Object)("No boilerplate text found for key " + key));
            return "";
        }
        if (parameters != null && formatter != null) {
            formatter.applyPattern(txt);
            return formatter.format(parameters);
        }
        return txt;
    }

    public static String getText(ResourceBundle msgBundle, String key) {
        return TextUtil.getText(msgBundle, null, key, null);
    }

    public static ResourceBundle getBoilerplateBundle(Locale locale, String templateName) {
        String name = templateName != null ? "org.lamsfoundation.lams.central." + templateName + "Resources" : "org.lamsfoundation.lams.central.ApplicationResources";
        return ResourceBundle.getBundle(name, locale, new ResourceBundle.Control(){

            @Override
            public long getTimeToLive(String arg0, Locale arg1) {
                return -1L;
            }
        });
    }

    public static MessageFormat getFormatter(Locale locale) {
        MessageFormat formatter = new MessageFormat("");
        formatter.setLocale(locale);
        return formatter;
    }
}

