/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.template.web;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.authoring.template.Option;
import org.lamsfoundation.lams.authoring.template.TextUtil;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.rest.RestTags;
import org.lamsfoundation.lams.rest.ToolRestManager;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.JsonUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class LdTemplateAction
extends DispatchAction {
    private static Logger log = Logger.getLogger(LdTemplateAction.class);
    public static final int MAX_OPTION_COUNT = 6;
    public static final int MAX_FLOATING_ACTIVITY_OPTIONS = 6;
    public static final String PARENT_ACTIVITY_TYPE = "parentActivityType";
    private final HttpClient httpClient = new DefaultHttpClient();
    private static ILamsCoreToolService lamsCoreToolService;
    private static IWorkspaceManagementService workspaceManagementService;
    private static IAuthoringService authoringService;
    private static IToolDAO toolDAO;
    protected static final String CONTENT_TYPE_JSON = "application/json;charset=utf-8";
    protected static final String ASSESSMENT_TOOL_SIGNATURE = "laasse10";
    protected static final String ASSESSMENT_ICON = "tool/laasse10/images/icon_assessment.swf";
    protected static final String CHAT_TOOL_SIGNATURE = "lachat11";
    protected static final String CHAT_ICON = "tool/lachat11/images/icon_chat.swf";
    protected static final String FORUM_TOOL_SIGNATURE = "lafrum11";
    protected static final String FORUM_ICON = "tool/lafrum11/images/icon_forum.swf";
    protected static final String LEADER_TOOL_SIGNATURE = "lalead11";
    protected static final String LEADER_ICON = "tool/lalead11/images/icon_leaderselection.swf";
    protected static final String MCQ_TOOL_SIGNATURE = "lamc11";
    protected static final String MCQ_ICON = "tool/lamc11/images/icon_mcq.swf";
    protected static final String NOTEBOOK_TOOL_SIGNATURE = "lantbk11";
    protected static final String NOTEBOOK_ICON = "tool/lantbk11/images/icon_notebook.swf";
    protected static final String NOTICEBOARD_TOOL_SIGNATURE = "lanb11";
    protected static final String NOTICEBOARD_ICON = "tool/lanb11/images/icon_htmlnb.swf";
    protected static final String QA_TOOL_SIGNATURE = "laqa11";
    protected static final String QA_ICON = "tool/laqa11/images/icon_questionanswer.swf";
    protected static final String SHARE_RESOURCES_TOOL_SIGNATURE = "larsrc11";
    protected static final String SHARE_RESOURCES_ICON = "tool/larsrc11/images/icon_rsrc.swf";
    protected static final String SCRATCHIE_TOOL_SIGNATURE = "lascrt11";
    protected static final String SCRATCHIE_ICON = "tool/lascrt11/images/icon_scratchie.swf";
    protected static final String SCRIBE_TOOL_SIGNATURE = "lascrb11";
    protected static final String SCRIBE_ICON = "tool/lascrb11/images/icon_scribe.swf";
    protected static final String SUBMIT_TOOL_SIGNATURE = "lasbmt11";
    protected static final String SUBMIT_ICON = "tool/lasbmt11/images/icon_reportsubmission.swf";
    protected static final String SURVEY_TOOL_SIGNATURE = "lasurv11";
    protected static final String SURVEY_ICON = "tool/lasurv11/images/icon_survey.swf";
    protected static final String WIKI_TOOL_SIGNATURE = "lawiki10";
    protected static final String WIKI_ICON = "tool/lawiki10/images/icon_wiki.swf";
    protected static final String MINDMAP_TOOL_SIGNATURE = "lamind10";
    protected static final String MINDMAP_ICON = "tool/lamind10/images/icon_mindmap.swf";
    protected static final String VOTE_TOOL_SIGNATURE = "lavote11";
    protected static final String VOTE_ICON = "tool/lavote11/images/icon_ranking.swf";
    protected static final String PEER_REVIEW_TOOL_SIGNATURE = "laprev11";
    protected static final String PEER_REVIEW_ICON = "tool/laprev11/images/icon_peerreview.svg";
    protected static final String CHAT_SCRIBE_DESC = "Combined Chat and Scribe";
    protected static final String FORUM_SCRIBE_DESC = "Combined Forum and Scribe";
    protected static final String RESOURCES_FORUM_DESC = "Combined Share Resources and Forum";
    protected static final String TOOL_CONTENT_SERVLET_URL_SUFFIX = "/lams/rest/ToolContent";
    protected static final String LEARNING_DESIGN_SERVLET_URL_SUFFIX = "/lams/rest/LearningDesign";
    protected static final int rowHeightSpace = 100;
    protected static final int activityWidthSpace = 185;
    protected static final int gateHeightOffset = 5;
    protected static final int gateWidthOffset = 50;
    public static final short RESOURCE_TYPE_URL = 1;
    public static final short RESOURCE_TYPE_FILE = 2;
    public static final short RESOURCE_TYPE_WEBSITE = 3;
    public static final short RESOURCE_TYPE_LEARNING_OBJECT = 4;

    public final ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject responseJSON = null;
        try {
            responseJSON = this.createLearningDesign(request);
            if (!responseJSON.has("learningDesignID") && !responseJSON.has("errors")) {
                log.error((Object)("The Learning Design was not created successfully. ResponseJSON missing both learningDesignID and errors" + responseJSON.toString()));
                responseJSON = new JSONObject().put("fatal", (Object)"The Learning Design was not created successfully. See the server log for more details.");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            responseJSON = new JSONObject().put("fatal", (Object)("The Learning Design was not created successfully. See the server log for more details.\n\n" + e.getMessage()));
        }
        response.setContentType(CONTENT_TYPE_JSON);
        response.getWriter().print(responseJSON);
        return null;
    }

    public ActionForward init(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String contentFolderID = FileUtil.generateUniqueContentFolderID();
        request.setAttribute(RestTags.CONTENT_FOLDER_ID, (Object)contentFolderID);
        return mapping.findForward("init");
    }

    protected abstract JSONObject createLearningDesign(HttpServletRequest var1) throws Exception;

    protected JSONArray createTransitions(AtomicInteger maxUIID, JSONArray activities) throws JSONException {
        JSONArray transitions = new JSONArray();
        return this.createTransitions(transitions, maxUIID, activities);
    }

    protected JSONArray createTransitions(AtomicInteger maxUIID, Set<JSONArray> setsOfActivities) throws JSONException {
        JSONArray transitions = new JSONArray();
        if (setsOfActivities != null) {
            for (JSONArray activities : setsOfActivities) {
                this.createTransitions(transitions, maxUIID, activities);
            }
        }
        return transitions;
    }

    private JSONArray createTransitions(JSONArray transitions, AtomicInteger maxUIID, JSONArray activities) throws JSONException {
        for (int activityIndex = 1; activityIndex < activities.length(); ++activityIndex) {
            JSONObject fromActivity = activities.getJSONObject(activityIndex - 1);
            JSONObject toActivity = activities.getJSONObject(activityIndex);
            Integer parentType = (Integer)JsonUtil.opt((JSONObject)toActivity, (String)PARENT_ACTIVITY_TYPE, (Object)null);
            while (activityIndex < activities.length() && parentType != null && !parentType.equals(8)) {
                toActivity = activities.getJSONObject(++activityIndex);
                parentType = (Integer)JsonUtil.opt((JSONObject)toActivity, (String)PARENT_ACTIVITY_TYPE, (Object)null);
            }
            int fromUIID = fromActivity.getInt("activityUIID");
            int toUIID = toActivity.getInt("activityUIID");
            JSONObject transitionJSON = new JSONObject();
            transitionJSON.put("transitionUIID", maxUIID.incrementAndGet());
            transitionJSON.put("fromUIID", fromUIID);
            transitionJSON.put("toUIID", toUIID);
            transitionJSON.put("transitionType", 0);
            transitions.put((Object)transitionJSON);
            fromActivity.remove(PARENT_ACTIVITY_TYPE);
        }
        return transitions;
    }

    protected Integer[] calcPosition(int order) {
        Integer[] pos = new Integer[2];
        int activity4space = 740;
        int rawPos = order * 185;
        int rowNum = rawPos / activity4space;
        pos[0] = 20 + rawPos - rowNum * activity4space;
        pos[1] = 100 + 100 * rowNum;
        return pos;
    }

    protected Integer[] calcPositionNextRight(Integer[] currPos) {
        Integer[] newPos = new Integer[2];
        newPos[1] = currPos[1];
        newPos[0] = currPos[0] + 185;
        return newPos;
    }

    protected Integer[] calcPositionBelow(Integer[] currPos) {
        Integer[] newPos = new Integer[]{currPos[0], currPos[1] + 100};
        return newPos;
    }

    protected Integer[] calcGateOffset(Integer[] currPos) {
        Integer[] newPos = new Integer[2];
        newPos[1] = currPos[1] + 5;
        newPos[0] = currPos[0] + 50;
        return newPos;
    }

    private String createTitle(String templateCode, String userEnteredString, Integer workspaceFolderID) {
        String title = WebUtil.removeHTMLtags((String)userEnteredString);
        title = title.replaceAll("[@%<>/^/*/$]", "");
        title = this.getAuthoringService().getUniqueNameForLearningDesign(title, workspaceFolderID);
        if (title.length() > 220) {
            title.substring(0, 220);
        }
        return title;
    }

    protected JSONObject saveLearningDesign(String templateCode, String userEnteredTitleString, String userEnteredDescription, Integer workspaceFolderID, String contentFolderId, Integer maxUIID, JSONArray activities, JSONArray transitions, JSONArray groupings, JSONArray branchMappings) throws HttpException, JSONException, IOException {
        JSONObject ldJSON = new JSONObject();
        ldJSON.put("workspaceFolderID", (Object)workspaceFolderID);
        ldJSON.put("copyTypeID", 1);
        ldJSON.put("title", (Object)this.createTitle(templateCode, userEnteredTitleString, workspaceFolderID));
        ldJSON.put("description", (Object)WebUtil.removeHTMLtags((String)userEnteredDescription));
        ldJSON.put("designType", (Object)templateCode.toLowerCase());
        ldJSON.put("maxID", (Object)maxUIID);
        ldJSON.put("readOnly", false);
        ldJSON.put("editOverrideLock", false);
        ldJSON.put("contentFolderID", (Object)contentFolderId);
        ldJSON.put("saveMode", 0);
        ldJSON.put("validDesign", true);
        ldJSON.put("activities", (Object)activities);
        ldJSON.put("transitions", (Object)transitions);
        ldJSON.putOpt("groupings", (Object)groupings);
        ldJSON.putOpt("branchMappings", (Object)branchMappings);
        LearningDesign learningDesign = null;
        try {
            learningDesign = this.getAuthoringService().saveLearningDesignDetails(ldJSON);
        }
        catch (Exception e) {
            log.error((Object)("Unable to learning design with details " + ldJSON), (Throwable)e);
            throw new HttpException("Unable to learning design with details " + ldJSON);
        }
        JSONObject responseJSON = new JSONObject();
        responseJSON.put("learningDesignID", (Object)learningDesign.getLearningDesignId());
        responseJSON.put("title", (Object)learningDesign.getTitle());
        return responseJSON;
    }

    protected JSONObject createGateActivity(AtomicInteger uiid, int order, Integer[] layoutCoords) throws JSONException {
        JSONObject activityJSON = new JSONObject();
        Integer[] pos = layoutCoords;
        if (pos == null) {
            pos = this.calcPosition(order);
            pos[0] = pos[0] + 40;
            pos[1] = pos[1] + 15;
        }
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("applyGrouping", false);
        activityJSON.put("xCoord", (Object)pos[0]);
        activityJSON.put("yCoord", (Object)pos[1]);
        activityJSON.put("activityTitle", (Object)"Gate");
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", 5);
        activityJSON.put("gateActivityLevelID", 1);
        return activityJSON;
    }

    protected JSONObject[] createGroupingActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Integer groupingTypeID, Integer numLearners, Integer numGroups, String title, String[] groupNames, ResourceBundle appBundle, MessageFormat formatter) throws JSONException {
        JSONObject activityJSON;
        JSONObject groupingJSON;
        JSONObject[] responseJSONs = new JSONObject[2];
        responseJSONs[1] = groupingJSON = new JSONObject();
        int groupingUIID = uiid.incrementAndGet();
        groupingJSON.put("groupingUIID", groupingUIID);
        groupingJSON.put("groupingTypeID", (Object)groupingTypeID);
        if (groupingTypeID.equals(Grouping.CHOSEN_GROUPING_TYPE)) {
            groupingJSON.put("maxNumberOfGroups", (Object)numGroups);
        } else {
            groupingJSON.put("numberOfGroups", (Object)numGroups);
        }
        groupingJSON.put("learnersPerGroup", (Object)numLearners);
        groupingJSON.put("equalNumberOfLearnersPerGroup", (Object)Boolean.FALSE);
        JSONArray groups = new JSONArray();
        if (groupNames != null) {
            int orderId = 0;
            for (String groupName : groupNames) {
                JSONObject group = new JSONObject();
                group.put("groupName", (Object)groupName);
                group.put("orderID", orderId++);
                group.put("groupUIID", uiid.incrementAndGet());
                groups.put((Object)group);
            }
        } else {
            Integer useNumGroups = numGroups != null && numGroups > 0 ? numGroups : 2;
            int orderId = 0;
            int groupNum = 1;
            while (orderId < useNumGroups) {
                JSONObject group = new JSONObject();
                group.put("groupName", (Object)(TextUtil.getText(appBundle, formatter, "label.course.groups.prefix", null) + groupNum));
                group.put("orderID", orderId);
                group.put("groupUIID", uiid.incrementAndGet());
                groups.put((Object)group);
                ++orderId;
                ++groupNum;
            }
        }
        groupingJSON.put("groups", (Object)groups);
        Integer[] pos = layoutCoords != null ? layoutCoords : this.calcPosition(order);
        responseJSONs[0] = activityJSON = new JSONObject();
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("xCoord", (Object)pos[0]);
        activityJSON.put("yCoord", (Object)pos[1]);
        activityJSON.put("activityTitle", (Object)(title != null ? title : "Grouping"));
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", 2);
        activityJSON.put("createGroupingUIID", groupingUIID);
        return responseJSONs;
    }

    protected JSONObject createParallelActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Integer groupingUIID, String activityTitle, String description) throws JSONException {
        JSONObject activityJSON = new JSONObject();
        Integer[] pos = layoutCoords;
        if (pos == null) {
            pos = this.calcPosition(order);
            pos[1] = pos[1] - 50;
        }
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("applyGrouping", false);
        activityJSON.put("xCoord", (Object)pos[0]);
        activityJSON.put("yCoord", (Object)pos[1]);
        activityJSON.put("activityTitle", (Object)(activityTitle != null ? activityTitle : "Parallel Activity"));
        activityJSON.put("activityCategoryID", 5);
        activityJSON.put("activityTypeID", 6);
        activityJSON.put("description", (Object)description);
        if (groupingUIID != null) {
            activityJSON.put("groupingUIID", (Object)groupingUIID);
            activityJSON.put("applyGrouping", true);
        } else {
            activityJSON.put("applyGrouping", false);
        }
        return activityJSON;
    }

    protected JSONObject createSupportActivity(AtomicInteger uiid, int order, Integer[] layoutCoords) throws JSONException {
        Integer[] pos = layoutCoords;
        if (pos == null) {
            pos = this.calcPosition(order);
            pos[0] = 20;
            pos[1] = pos[1] + 100;
        }
        JSONObject activityJSON = new JSONObject();
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put("groupingSupportType", 1);
        activityJSON.put("applyGrouping", false);
        activityJSON.put("xCoord", (Object)pos[0]);
        activityJSON.put("yCoord", (Object)pos[1]);
        activityJSON.put("activityTitle", (Object)"Support Activity");
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", 15);
        activityJSON.putOpt("maxActivities", (Object)6);
        return activityJSON;
    }

    protected JSONObject createSequenceActivity(Integer reservedUiid, Integer parentUIID, Integer parentActivityType, Integer firstActivityUiid, int orderId, String branchName) throws JSONException {
        JSONObject activityJSON = new JSONObject();
        activityJSON.put("activityUIID", (Object)reservedUiid);
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("applyGrouping", false);
        activityJSON.put("activityTitle", (Object)(branchName != null ? branchName : "Branch " + orderId));
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", 8);
        activityJSON.put("orderID", orderId);
        activityJSON.put("parentUIID", (Object)parentUIID);
        activityJSON.put(PARENT_ACTIVITY_TYPE, (Object)parentActivityType);
        activityJSON.put("defaultActivityUIID", (Object)firstActivityUiid);
        activityJSON.put("stopAfterActivity", false);
        return activityJSON;
    }

    protected JSONObject createBranchMapping(AtomicInteger uiid, Integer groupUiid, Integer branchingActivityUiid, Integer sequenceActivityUiid) throws JSONException {
        JSONObject bmJSON = new JSONObject();
        bmJSON.put("entryUIID", uiid.incrementAndGet());
        bmJSON.put("groupUIID", (Object)groupUiid);
        bmJSON.put("branchingActivityUIID", (Object)branchingActivityUiid);
        bmJSON.put("sequenceActivityUIID", (Object)sequenceActivityUiid);
        return bmJSON;
    }

    protected JSONObject createGroupBranchingActivity(Integer reservedUiid, Integer defaultBranchUiid, Integer groupingUiid, int order, Integer[] layoutCoords, Integer[] startCoords, Integer[] endCoords, String activityTitle) throws JSONException {
        JSONObject activityJSON = this.createBranchingActivity(reservedUiid, defaultBranchUiid, groupingUiid, order, layoutCoords, startCoords, endCoords, activityTitle, 11);
        return activityJSON;
    }

    private JSONObject createBranchingActivity(Integer reservedUiid, Integer defaultBranchUiid, Integer groupingUiid, int order, Integer[] layoutCoords, Integer[] startCoords, Integer[] endCoords, String activityTitle, int activityType) throws JSONException {
        JSONObject activityJSON = new JSONObject();
        activityJSON.put("activityUIID", (Object)reservedUiid);
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("activityTitle", (Object)(activityTitle != null ? activityTitle : "Branching"));
        activityJSON.put("activityCategoryID", 1);
        activityJSON.put("activityTypeID", activityType);
        activityJSON.putOpt("maxActivities", (Object)6);
        activityJSON.put("xCoord", (Object)layoutCoords[0]);
        activityJSON.put("yCoord", (Object)layoutCoords[1]);
        activityJSON.put("startXCoord", (Object)startCoords[0]);
        activityJSON.put("startYCoord", (Object)startCoords[1]);
        activityJSON.put("endXCoord", (Object)endCoords[0]);
        activityJSON.put("endYCoord", (Object)endCoords[1]);
        activityJSON.put("stopAfterActivity", false);
        activityJSON.put("defaultActivityUIID", (Object)defaultBranchUiid);
        if (groupingUiid != null) {
            activityJSON.put("groupingUIID", (Object)groupingUiid);
            activityJSON.put("applyGrouping", true);
        } else {
            activityJSON.put("applyGrouping", false);
        }
        return activityJSON;
    }

    protected Long createToolContent(UserDTO user, String toolSignature, JSONObject toolContentJSON) throws JSONException, HttpException, IOException {
        try {
            Tool tool = this.getTool(toolSignature);
            Long toolContentID = this.getAuthoringService().insertToolContentID(tool.getToolId());
            ToolRestManager toolRestService = (ToolRestManager)this.getLamsCoreToolService().findToolService(tool);
            toolRestService.createRestToolContent(user.getUserID(), toolContentID, toolContentJSON);
            return toolContentID;
        }
        catch (Exception e) {
            log.error((Object)("Unable to create tool content for " + toolSignature + " with details " + toolContentJSON + ". \nThe tool probably threw an exception - check the server logs for more details.\nIf the exception is \"Servlet.service() for servlet ToolContentRestServlet threw exception java.lang.ClassCastException: com.sun.proxy.$ProxyXXX cannot be cast to org.lamsfoundation.lams.rest.ToolRestManager)\" then the tool doesn't support the LDTemplate service calls (ie has not implemented the ToolRestManager interface / createRestToolContent() method."));
            throw new HttpException("Unable to create tool content for " + toolSignature + " with details " + toolContentJSON);
        }
    }

    protected JSONObject createToolActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, String toolSignature, String toolIcon, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle, int activityCategory) throws JSONException {
        JSONObject activityJSON = new JSONObject();
        Tool tool = this.getTool(toolSignature);
        Integer[] pos = layoutCoords != null ? layoutCoords : this.calcPosition(order);
        activityJSON.put("activityUIID", uiid.incrementAndGet());
        activityJSON.put(RestTags.CONTENT_FOLDER_ID, (Object)contentFolderID);
        activityJSON.put("toolID", (Object)tool.getToolId());
        activityJSON.put("learningLibraryID", (Object)tool.getLearningLibraryId());
        activityJSON.put("toolContentID", (Object)toolContentID);
        activityJSON.put("groupingSupportType", 2);
        activityJSON.put("libraryActivityUIImage", (Object)toolIcon);
        activityJSON.put("xCoord", (Object)pos[0]);
        activityJSON.put("yCoord", (Object)pos[1]);
        activityJSON.put("activityTitle", (Object)(activityTitle != null ? activityTitle : "Activity"));
        activityJSON.put("activityCategoryID", activityCategory);
        activityJSON.put("activityTypeID", 1);
        if (parentUIID != null) {
            activityJSON.put("parentUIID", (Object)parentUIID);
            activityJSON.put(PARENT_ACTIVITY_TYPE, (Object)parentActivityType);
        }
        if (groupingUIID != null) {
            activityJSON.put("groupingUIID", (Object)groupingUIID);
            activityJSON.put("applyGrouping", true);
        } else {
            activityJSON.put("applyGrouping", false);
        }
        return activityJSON;
    }

    protected JSONObject createStandardToolContent(String title, String instructions, String reflectionInstructions, Boolean lockWhenFinished, Boolean allowRichTextEditor, UserDTO user) throws JSONException {
        JSONObject toolContentJSON = new JSONObject();
        toolContentJSON.put(RestTags.TITLE, (Object)(title != null ? title : ""));
        toolContentJSON.put(RestTags.INSTRUCTIONS, (Object)(instructions != null ? instructions : ""));
        if (reflectionInstructions != null) {
            toolContentJSON.put(RestTags.REFLECT_ON_ACTIVITY, true);
            toolContentJSON.put(RestTags.REFLECT_INSTRUCTIONS, (Object)reflectionInstructions);
        }
        toolContentJSON.putOpt(RestTags.LOCK_WHEN_FINISHED, (Object)lockWhenFinished);
        toolContentJSON.putOpt(RestTags.ALLOW_RICH_TEXT_EDITOR, (Object)allowRichTextEditor);
        if (user != null) {
            toolContentJSON.put("firstName", (Object)user.getFirstName());
            toolContentJSON.put("lastName", (Object)user.getLastName());
            toolContentJSON.put("loginName", (Object)user.getLogin());
        }
        return toolContentJSON;
    }

    protected Long createAssessmentToolContent(UserDTO user, String title, String instructions, String reflectionInstructions, boolean selectLeaderToolOutput, JSONArray questions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, null, null, user);
        toolContentJSON.put(RestTags.USE_SELECT_LEADER_TOOL_OUTPUT, selectLeaderToolOutput);
        toolContentJSON.put(RestTags.QUESTIONS, (Object)questions);
        JSONArray references = new JSONArray();
        for (int i = 0; i < questions.length(); ++i) {
            Integer questionDisplayOrder = ((JSONObject)questions.get(i)).getInt(RestTags.DISPLAY_ORDER);
            references.put((Object)new JSONObject().put(RestTags.DISPLAY_ORDER, (Object)questionDisplayOrder).put("questionDisplayOrder", (Object)questionDisplayOrder));
        }
        toolContentJSON.put("references", (Object)references);
        return this.createToolContent(user, ASSESSMENT_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createAssessmentActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, ASSESSMENT_TOOL_SIGNATURE, ASSESSMENT_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Assessment", 3);
    }

    protected Long createChatToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, String filterKeywords, String reflectionInstructions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, lockWhenFinished, null, null);
        toolContentJSON.put("filterKeywords", (Object)filterKeywords);
        return this.createToolContent(user, CHAT_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createChatActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, CHAT_TOOL_SIGNATURE, CHAT_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Chat", 2);
    }

    protected Long createForumToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean allowRichTextEditor, boolean allowNewTopic, boolean allowRateMessages, boolean allowUpload, boolean limitedMaxCharacters, Integer maxCharacters, JSONArray topics) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, allowRichTextEditor, user);
        toolContentJSON.put("topics", (Object)topics);
        toolContentJSON.put("allowNewTopic", allowNewTopic);
        toolContentJSON.put("allowRateMessages", allowRateMessages);
        toolContentJSON.put("allowUpload", allowUpload);
        toolContentJSON.put("limitedMaxCharacters", limitedMaxCharacters);
        if (limitedMaxCharacters && maxCharacters != null) {
            toolContentJSON.put("maxCharacters", (Object)maxCharacters);
        }
        return this.createToolContent(user, FORUM_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createForumActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, FORUM_TOOL_SIGNATURE, FORUM_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Forum", 2);
    }

    protected Long createLeaderSelectionToolContent(UserDTO user, String title, String instructions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, null, null, null);
        return this.createToolContent(user, LEADER_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createLeaderSelectionActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, LEADER_TOOL_SIGNATURE, LEADER_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Leader Selection", 6);
    }

    protected Long createNotebookToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean allowRichTextEditor) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, allowRichTextEditor, null);
        return this.createToolContent(user, NOTEBOOK_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createNotebookActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, NOTEBOOK_TOOL_SIGNATURE, NOTEBOOK_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Notebook", 6);
    }

    protected Long createNoticeboardToolContent(UserDTO user, String title, String content, String reflectionInstructions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, null, reflectionInstructions, null, null, null);
        toolContentJSON.put("content", (Object)(content != null ? content : ""));
        return this.createToolContent(user, NOTICEBOARD_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createNoticeboardActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, NOTICEBOARD_TOOL_SIGNATURE, NOTICEBOARD_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Noticeboard", 4);
    }

    protected Long createQAToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean allowRichTextEditor, boolean oneQuestionPerPage, boolean showOtherLearnersAnswers, boolean showOtherLearnersNames, JSONArray questions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, allowRichTextEditor, null);
        toolContentJSON.put(RestTags.QUESTIONS, (Object)questions);
        toolContentJSON.put("questionsSequenced", oneQuestionPerPage);
        toolContentJSON.put("showOtherAnswers", showOtherLearnersAnswers);
        toolContentJSON.put("usernameVisible", showOtherLearnersNames);
        return this.createToolContent(user, QA_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createQAActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, QA_TOOL_SIGNATURE, QA_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Q&A", 6);
    }

    protected Long createMCQToolContent(UserDTO user, String title, String instructions, boolean useSelectLeaderToolOuput, boolean enableConfidenceLevel, JSONArray questions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, null, null, null);
        toolContentJSON.put(RestTags.USE_SELECT_LEADER_TOOL_OUTPUT, useSelectLeaderToolOuput);
        toolContentJSON.put(RestTags.QUESTIONS, (Object)questions);
        toolContentJSON.put(RestTags.ENABLE_CONFIDENCE_LEVELS, enableConfidenceLevel);
        return this.createToolContent(user, MCQ_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createMCQActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, MCQ_TOOL_SIGNATURE, MCQ_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Multiple Choice", 3);
    }

    protected Long createMindmapToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean multiUserMode, String reflectionInstruction) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, null, null);
        toolContentJSON.put("multiUserMode", multiUserMode);
        return this.createToolContent(user, MINDMAP_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createMindmapActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, MINDMAP_TOOL_SIGNATURE, MINDMAP_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "MindMap", 6);
    }

    protected Long createResourcesToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean runContentAutomatically, boolean allowLearnerAddURL, boolean allowLearnerAddFile, boolean notifyInstructors, Integer minResourcesToView, String reflectionInstructions, JSONArray resources) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, lockWhenFinished, null, user);
        toolContentJSON.put("allowAddFiles", allowLearnerAddFile);
        toolContentJSON.put("allowAddUrls", allowLearnerAddURL);
        toolContentJSON.put("notifyTeachersOnAssigmentSumbit", notifyInstructors);
        toolContentJSON.put("runAuto", runContentAutomatically);
        if (minResourcesToView != null) {
            toolContentJSON.put("minViewResourceNumber", (Object)minResourcesToView);
        }
        toolContentJSON.put("resources", (Object)resources);
        return this.createToolContent(user, SHARE_RESOURCES_TOOL_SIGNATURE, toolContentJSON);
    }

    private JSONObject createResourceItem(String title, short type, String[] instructions, File file, int displayOrder) throws JSONException {
        JSONObject item = new JSONObject();
        item.put(RestTags.TITLE, (Object)(title != null ? title : ""));
        item.put("type", (int)type);
        item.put(RestTags.DISPLAY_ORDER, displayOrder);
        if (instructions != null) {
            item.put("instructions", (Object)instructions);
        } else {
            item.put("instructions", (Object)new JSONArray());
        }
        if (type != 1) {
            log.warn((Object)("LD Templates not handling files yet - file, website & LO resources won't work. Filename " + file.getAbsoluteFile()));
        }
        return item;
    }

    protected JSONObject createResourceURL(String title, String[] instructions, String URL2, boolean openInNewWindow, int displayOrder) throws JSONException {
        JSONObject obj = this.createResourceItem(title, (short)1, instructions, null, displayOrder);
        obj.put("url", (Object)URL2);
        obj.put("openUrlNewWindow", openInNewWindow);
        return obj;
    }

    protected JSONObject createResourceFile(String title, String description, String[] instructions, File file, int displayOrder) throws JSONException {
        JSONObject obj = this.createResourceItem(title, (short)2, instructions, file, displayOrder);
        obj.put("description", (Object)description);
        return obj;
    }

    protected JSONObject createResourceWebsite(String title, String description, String[] instructions, File file, int displayOrder) throws JSONException {
        JSONObject obj = this.createResourceItem(title, (short)3, instructions, file, displayOrder);
        obj.put("description", (Object)description);
        return obj;
    }

    protected JSONObject createResourceLearningObject(String title, String description, String[] instructions, File file, int displayOrder) throws JSONException {
        JSONObject obj = this.createResourceItem(title, (short)4, instructions, file, displayOrder);
        obj.put("description", (Object)description);
        return obj;
    }

    protected JSONObject createResourcesActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, SHARE_RESOURCES_TOOL_SIGNATURE, SHARE_RESOURCES_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Share Resources", 4);
    }

    protected Long createScratchieToolContent(UserDTO user, String title, String instructions, boolean useSelectLeaderToolOuput, Integer confidenceLevelsActivityUiid, JSONArray questions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, null, null, null);
        toolContentJSON.put(RestTags.QUESTIONS, (Object)questions);
        if (confidenceLevelsActivityUiid != null) {
            toolContentJSON.put(RestTags.CONFIDENCE_LEVELS_ACTIVITY_UIID, (Object)confidenceLevelsActivityUiid);
        }
        return this.createToolContent(user, SCRATCHIE_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createScratchieActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, SCRATCHIE_TOOL_SIGNATURE, SCRATCHIE_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Scratchie", 4);
    }

    protected Long createScribeToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, boolean autoSelectScribe, boolean showAggregatedReports, String reflectionInstructions, JSONArray questions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, lockWhenFinished, null, null);
        toolContentJSON.put(RestTags.QUESTIONS, (Object)questions);
        toolContentJSON.put("autoSelectScribe", autoSelectScribe);
        toolContentJSON.put("showAggregatedReports", showAggregatedReports);
        return this.createToolContent(user, SCRIBE_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createScribeActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, SCRIBE_TOOL_SIGNATURE, SCRIBE_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Scribe", 2);
    }

    protected Long createSubmitToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, Boolean limitUpload, Integer limitUploadNumber, String reflectionInstructions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, lockWhenFinished, null, user);
        if (limitUploadNumber != null) {
            toolContentJSON.put("limitUpload", limitUpload != null ? limitUpload : true);
            toolContentJSON.put("limitUploadNumber", (Object)limitUploadNumber);
        }
        return this.createToolContent(user, SUBMIT_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createSubmitActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, SUBMIT_TOOL_SIGNATURE, SUBMIT_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Submit File", 3);
    }

    protected Long createSurveyToolContent(UserDTO user, String title, String instructions, Boolean lockWhenFinished, JSONArray questions) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, null, user);
        toolContentJSON.put("questions", (Object)questions);
        return this.createToolContent(user, SURVEY_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createSurveyActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, SURVEY_TOOL_SIGNATURE, SURVEY_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Survey", 6);
    }

    protected Long createVoteToolContent(UserDTO user, String title, String instructions, JSONArray answers, Boolean showResults) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, null, null, null);
        toolContentJSON.put(RestTags.ANSWERS, (Object)answers);
        toolContentJSON.putOpt("showResults", (Object)showResults);
        return this.createToolContent(user, VOTE_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createVoteActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, VOTE_TOOL_SIGNATURE, VOTE_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Voting", 6);
    }

    protected Long createWikiToolContent(UserDTO user, String title, String instructions, boolean lockWhenFinished, String reflectionInstruction, JSONArray pages) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, null, lockWhenFinished, null, null);
        toolContentJSON.put("pages", (Object)pages);
        return this.createToolContent(user, WIKI_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createWikiActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, WIKI_TOOL_SIGNATURE, WIKI_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Wiki", 2);
    }

    protected Long createPeerReviewToolContent(UserDTO user, String title, String instructions, String reflectionInstructions, JSONArray criterias) throws JSONException, HttpException, IOException {
        JSONObject toolContentJSON = this.createStandardToolContent(title, instructions, reflectionInstructions, null, null, user);
        toolContentJSON.put("criterias", (Object)criterias);
        return this.createToolContent(user, PEER_REVIEW_TOOL_SIGNATURE, toolContentJSON);
    }

    protected JSONObject createPeerReviewActivity(AtomicInteger uiid, int order, Integer[] layoutCoords, Long toolContentID, String contentFolderID, Integer groupingUIID, Integer parentUIID, Integer parentActivityType, String activityTitle) throws JSONException {
        return this.createToolActivity(uiid, order, layoutCoords, PEER_REVIEW_TOOL_SIGNATURE, PEER_REVIEW_ICON, toolContentID, contentFolderID, groupingUIID, parentUIID, parentActivityType, activityTitle != null ? activityTitle : "Peer Review", 4);
    }

    protected final IAuthoringService getAuthoringService() {
        if (authoringService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            authoringService = (IAuthoringService)ctx.getBean("authoringService");
        }
        return authoringService;
    }

    protected final Tool getTool(String toolSignature) {
        if (toolDAO == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            toolDAO = (IToolDAO)ctx.getBean("toolDAO");
        }
        return toolDAO.getToolBySignature(toolSignature);
    }

    protected final IWorkspaceManagementService getWorkspaceManagementService() {
        if (workspaceManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            workspaceManagementService = (IWorkspaceManagementService)ctx.getBean("workspaceManagementService");
        }
        return workspaceManagementService;
    }

    private ILamsCoreToolService getLamsCoreToolService() {
        if (lamsCoreToolService == null) {
            lamsCoreToolService = (ILamsCoreToolService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext()).getBean("lamsCoreToolService");
        }
        return lamsCoreToolService;
    }

    public ActionForward createAssessment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("questionNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber"));
        String questionType = WebUtil.readStrParam((HttpServletRequest)request, (String)"questionType");
        if (questionType == null || !questionType.equalsIgnoreCase("mcq")) {
            return mapping.findForward("assess");
        }
        return mapping.findForward("assessmcq");
    }

    public ActionForward createQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward;
        request.setAttribute("questionNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber"));
        String topicNumber = request.getParameter("topicNumber");
        if (topicNumber != null) {
            request.setAttribute("topicNumber", (Object)topicNumber);
        }
        return mapping.findForward((forward = request.getParameter("forward")) != null && forward.length() > 0 ? forward : "question");
    }

    public ActionForward createForum(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("topicNumber", (Object)request.getParameter("topicNumber"));
        return mapping.findForward("forum");
    }

    public ActionForward createOption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("questionNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber"));
        request.setAttribute("optionNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"optionNumber"));
        boolean useAssessmentVersion = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"assess", (boolean)false);
        return mapping.findForward(useAssessmentVersion ? "assessoption" : "questionoption");
    }

    public ActionForward deleteOption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer questionNumber = WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber", (boolean)true);
        Integer delete = WebUtil.readIntParam((HttpServletRequest)request, (String)"optionNumber");
        boolean useAssessmentVersion = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"assess", (boolean)false);
        TreeMap<Integer, Option> optionsMap = this.getOptions(request, questionNumber, useAssessmentVersion);
        optionsMap.remove(delete);
        LinkedList<Option> options = new LinkedList<Option>();
        int displayOrder = 1;
        for (Option option : optionsMap.values()) {
            option.setDisplayOrder(displayOrder++);
            options.add(option);
        }
        request.setAttribute("questionNumber", (Object)questionNumber);
        request.setAttribute("options", options);
        request.setAttribute("optionCount", (Object)options.size());
        return mapping.findForward(useAssessmentVersion ? "assessredooption" : "redooption");
    }

    public ActionForward swapOption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer questionNumber = WebUtil.readIntParam((HttpServletRequest)request, (String)"questionNumber", (boolean)true);
        int swap1 = WebUtil.readIntParam((HttpServletRequest)request, (String)"optionNumber1");
        int swap2 = WebUtil.readIntParam((HttpServletRequest)request, (String)"optionNumber2");
        if (swap2 < swap1) {
            swap1 = swap2;
        }
        boolean useAssessmentVersion = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"assess", (boolean)false);
        TreeMap<Integer, Option> optionsMap = this.getOptions(request, questionNumber, useAssessmentVersion);
        LinkedList<Option> options = new LinkedList<Option>();
        Option swap = null;
        for (Option option : optionsMap.values()) {
            if (swap != null) {
                swap.setDisplayOrder(option.getDisplayOrder());
                option.setDisplayOrder(swap1);
                options.add(option);
                options.add(swap);
                swap = null;
                continue;
            }
            if (option.getDisplayOrder() == swap1) {
                swap = option;
                continue;
            }
            options.add(option);
        }
        if (swap != null) {
            options.add(swap);
        }
        request.setAttribute("questionNumber", (Object)questionNumber);
        request.setAttribute("options", options);
        request.setAttribute("optionCount", (Object)options.size());
        return mapping.findForward(useAssessmentVersion ? "assessredooption" : "redooption");
    }

    private TreeMap<Integer, Option> getOptions(HttpServletRequest request, Integer questionNumber, boolean useAssessmentVersion) {
        String paramPrefix = useAssessmentVersion ? "assmcq" : "question";
        Integer correctDisplayIdInteger = WebUtil.readIntParam((HttpServletRequest)request, (String)(paramPrefix + questionNumber + "correct"), (boolean)true);
        int correctDisplayId = correctDisplayIdInteger != null ? correctDisplayIdInteger : 0;
        TreeMap<Integer, Option> optionDtos = new TreeMap<Integer, Option>();
        for (int i = 1; i <= 6; ++i) {
            String optionText = request.getParameter(paramPrefix + questionNumber + "option" + i);
            if (optionText == null) continue;
            String grade = request.getParameter(paramPrefix + questionNumber + "option" + i + "grade");
            Option option = new Option(i, i == correctDisplayId, optionText, grade);
            optionDtos.put(new Integer(i), option);
        }
        return optionDtos;
    }

    public ActionForward createResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("urlNumber", (Object)request.getParameter("urlNumber"));
        if (request.getParameter("branchNumberUnderscore") != null) {
            request.setAttribute("branchNumberUnderscore", (Object)request.getParameter("branchNumberUnderscore"));
        }
        return mapping.findForward("resource");
    }

    public ActionForward createBranch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("branchNumber", (Object)request.getParameter("branchNumber"));
        return mapping.findForward("branch");
    }

    public ActionForward createRatingCriteria(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("criteriaNumber", (Object)WebUtil.readIntParam((HttpServletRequest)request, (String)"criteriaNumber"));
        return mapping.findForward("peerreviewstar");
    }

    class ToolDetails {
        String signature;
        String icon;
        int activityType;

        ToolDetails(String signature, String icon, int activityType) {
            this.signature = signature;
            this.icon = icon;
            this.activityType = activityType;
        }
    }
}

