/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class LamsAuthoringFinishAction
extends Action {
    private static Logger log = Logger.getLogger(LamsAuthoringFinishAction.class);
    private static final String ACTION_NAME = "action";
    private static final String ACTION_MODE = "mode";
    private static final String CUSTOMISE_SESSION_ID = "customiseSessionID";
    private static final String TOOL_SIGNATURE = "signature";
    private static final String CONFIRM_ACTION = "confirm";
    private static final String CANCEL_ACTION = "cancel";
    private static final String DEFINE_LATER_ACTION = "defineLater";
    private static final String RE_EDIT_URL = "reEditUrl";
    private static ILogEventService logEventService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String action = request.getParameter(ACTION_NAME);
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)ACTION_MODE, (boolean)false);
        String cSessionID = request.getParameter(CUSTOMISE_SESSION_ID);
        String notifyCloseURL = (String)request.getSession().getAttribute("notifyCloseURL");
        Long toolContentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        this.clearSession(cSessionID, request.getSession(), mode);
        if (StringUtils.equals((String)action, (String)CONFIRM_ACTION)) {
            String nextUrl = this.getLamsUrl() + "authoringConfirm.jsp";
            String signature = request.getParameter(TOOL_SIGNATURE);
            String contentFolderID = "TODO_remove-change_optional_to_false";
            contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID", (boolean)true);
            IToolVO tool = this.getToolService().getToolBySignature(signature);
            String reeditUrl = WebUtil.appendParameterToURL((String)(this.getLamsUrl() + tool.getAuthorUrl()), (String)"toolContentID", (String)toolContentId.toString());
            reeditUrl = WebUtil.appendParameterToURL((String)reeditUrl, (String)"contentFolderID", (String)contentFolderID);
            if (notifyCloseURL != null && notifyCloseURL.length() > 0) {
                reeditUrl = WebUtil.appendParameterToURL((String)reeditUrl, (String)"notifyCloseURL", (String)notifyCloseURL);
            }
            nextUrl = WebUtil.appendParameterToURL((String)nextUrl, (String)RE_EDIT_URL, (String)URLEncoder.encode(reeditUrl, "UTF-8"));
            if (!StringUtils.isBlank((String)notifyCloseURL)) {
                nextUrl = WebUtil.appendParameterToURL((String)nextUrl, (String)"notifyCloseURL", (String)notifyCloseURL);
            }
            response.sendRedirect(nextUrl);
        }
        if (StringUtils.equals((String)action, (String)DEFINE_LATER_ACTION)) {
            this.getLogEventService().logFinishEditingActivityInMonitor(toolContentId);
        }
        if (StringUtils.equals((String)action, (String)CANCEL_ACTION) && mode.isTeacher()) {
            String signature = request.getParameter(TOOL_SIGNATURE);
            ToolContentManager contentManager = (ToolContentManager)this.findToolService(signature);
            contentManager.resetDefineLater(toolContentId);
            this.getLogEventService().logCancelEditingActivityInMonitor(toolContentId);
        }
        return null;
    }

    public abstract void clearSession(String var1, HttpSession var2, ToolAccessMode var3);

    private String getLamsUrl() {
        String serverURL = Configuration.get((String)ConfigurationKeys.SERVER_URL);
        if (StringUtils.isBlank((String)serverURL)) {
            log.warn((Object)"ServerURLTag unable to write out server URL as it is missing from the configuration file.");
        }
        return serverURL;
    }

    public ILamsToolService getToolService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ILamsToolService)webContext.getBean("lamsToolService");
    }

    private ILogEventService getLogEventService() {
        if (logEventService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            logEventService = (ILogEventService)ctx.getBean("logEventService");
        }
        return logEventService;
    }

    public Object findToolService(String signature) throws NoSuchBeanDefinitionException {
        IToolVO tool = this.getToolService().getToolBySignature(signature);
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return webContext.getBean(tool.getServiceName());
    }
}

