/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.index.IndexLessonBean;
import org.lamsfoundation.lams.index.IndexLinkBean;
import org.lamsfoundation.lams.index.IndexOrgBean;
import org.lamsfoundation.lams.learning.kumalive.model.Kumalive;
import org.lamsfoundation.lams.learning.kumalive.service.IKumaliveService;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.LessonService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.IndexUtils;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DisplayGroupAction
extends Action {
    private static IUserManagementService service;
    private static LessonService lessonService;
    private static ILearningDesignService learningDesignService;
    private static ISecurityService securityService;
    private static IKumaliveService kumaliveService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)false);
        Organisation org = null;
        if (orgId != null) {
            org = (Organisation)this.getUserManagementService().findById(Organisation.class, (Serializable)orgId);
        }
        if (org != null) {
            User user = this.getUser(request.getRemoteUser());
            if (!this.getSecurityService().hasOrgRole(orgId, user.getUserId(), new String[]{"GROUP MANAGER", "LEARNER", "MONITOR", "AUTHOR"}, "display group", false)) {
                response.sendError(403, "The user is not a part of the organisation");
                return null;
            }
            ArrayList<Integer> roles = new ArrayList<Integer>();
            List userOrganisationRoles = this.getUserManagementService().getUserOrganisationRoles(orgId, request.getRemoteUser());
            for (UserOrganisationRole userOrganisationRole : userOrganisationRoles) {
                Integer roleId = userOrganisationRole.getRole().getRoleId();
                roles.add(roleId);
            }
            IndexOrgBean iob = this.createOrgBean(org, roles, request.getRemoteUser(), request.isUserInRole("SYSADMIN"));
            request.setAttribute("orgBean", (Object)iob);
            if (org.getEnableSingleActivityLessons().booleanValue() && (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR))) {
                request.setAttribute("tools", (Object)this.getLearningDesignService().getToolDTOs(false, false, request.getRemoteUser()));
            }
            boolean isFavorite = service.isOrganisationFavorite(orgId, user.getUserId());
            iob.setFavorite(isFavorite);
        }
        return mapping.findForward("group");
    }

    private IndexOrgBean createOrgBean(Organisation org, List<Integer> roles, String username, boolean isSysAdmin) throws SQLException, NamingException {
        String link;
        Integer organisationId = org.getOrganisationId();
        IndexOrgBean orgBean = new IndexOrgBean(organisationId, org.getName(), org.getOrganisationType().getOrganisationTypeId());
        orgBean = this.populateContentsOrgBean(orgBean, org, roles, username, isSysAdmin);
        ArrayList<IndexLinkBean> links = new ArrayList<IndexLinkBean>();
        ArrayList<IndexLinkBean> moreLinks = new ArrayList<IndexLinkBean>();
        if (isSysAdmin && orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
            moreLinks.add(new IndexLinkBean("index.classman", "javascript:openOrgManagement(" + organisationId + ")", "fa fa-fw fa-users", null));
        }
        if (org.getEnableGradebookForLearners().booleanValue() && roles.contains(Role.ROLE_LEARNER)) {
            link = "javascript:showGradebookLearnerDialog(" + organisationId + ")";
            links.add(new IndexLinkBean("index.coursegradebook.learner", link, "fa fa-fw fa-list-ol", null));
        }
        if (roles.contains(Role.ROLE_GROUP_ADMIN) || roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR)) {
            String name;
            if (orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
                if (!isSysAdmin && (roles.contains(Role.ROLE_GROUP_ADMIN) || roles.contains(Role.ROLE_GROUP_MANAGER))) {
                    moreLinks.add(new IndexLinkBean("index.classman", "javascript:openOrgManagement(" + organisationId + ")", "fa fa-fw fa-ellipsis-v", null));
                }
                if (roles.contains(Role.ROLE_GROUP_ADMIN) || roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_AUTHOR) || roles.contains(Role.ROLE_MONITOR)) {
                    moreLinks.add(new IndexLinkBean("index.orggroup", "javascript:showOrgGroupingDialog(" + organisationId + ")", "fa fa-fw fa-users", null));
                }
                if (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR)) {
                    name = org.getEnableSingleActivityLessons() != false ? "index.addlesson.single" : "index.addlesson";
                    links.add(new IndexLinkBean(name, "javascript:showAddLessonDialog(" + organisationId + ")", "fa fa-fw fa-plus", null));
                }
                moreLinks.add(new IndexLinkBean("index.searchlesson", "javascript:showSearchLessonDialog(" + organisationId + ")", "fa fa-fw fa-search", "index.searchlesson.tooltip"));
                if (org.getEnableCourseNotifications().booleanValue() && (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR))) {
                    moreLinks.add(new IndexLinkBean("index.emailnotifications", "javascript:showNotificationsDialog(" + organisationId + ",null)", "fa fa-fw fa-bullhorn", "index.emailnotifications.tooltip"));
                }
                if (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR)) {
                    boolean hasLesson = !orgBean.getLessons().isEmpty();
                    for (IndexOrgBean childOrgBean : orgBean.getChildIndexOrgBeans()) {
                        hasLesson |= childOrgBean.getLessons() != null && !childOrgBean.getLessons().isEmpty();
                    }
                    if (hasLesson) {
                        moreLinks.add(new IndexLinkBean("label.enable.lesson.sorting", "javascript:makeOrgSortable()", "fa fa-fw fa-sort sorting tour-sorting", "label.enable.lesson.sorting"));
                    }
                }
                if (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_GROUP_ADMIN)) {
                    String link2 = "javascript:showGradebookCourseDialog(" + organisationId + ")";
                    moreLinks.add(new IndexLinkBean("index.coursegradebook", link2, "fa fa-fw fa-list-ol", "index.coursegradebook.tooltip"));
                }
            } else {
                if (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR)) {
                    name = org.getParentOrganisation().getEnableSingleActivityLessons() != false ? "index.addlesson.single" : "index.addlesson";
                    links.add(new IndexLinkBean(name, "javascript:showAddLessonDialog(" + organisationId + ")", "fa fa-fw fa-plus", null));
                }
                if (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_GROUP_ADMIN)) {
                    link = "javascript:showGradebookCourseDialog(" + organisationId + ")";
                    moreLinks.add(new IndexLinkBean("index.coursegradebook.subgroup", link, "fa fa-fw fa-list-ol", null));
                }
            }
        }
        if (Configuration.getAsBoolean((String)ConfigurationKeys.ALLOW_KUMALIVE) && org.getEnableKumalive().booleanValue() && (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR) || roles.contains(Role.ROLE_LEARNER))) {
            Kumalive kumalive = this.getKumaliveService().getKumaliveByOrganisation(organisationId);
            boolean isMonitor = roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR);
            boolean disabled = !isMonitor && (kumalive == null || kumalive.getFinished() != false);
            links.add(new IndexLinkBean(isMonitor ? "index.kumalive.teacher" : "index.kumalive", "javascript:openKumalive(" + organisationId + ")", "fa fa-fw fa-bolt" + (disabled ? " disabled" : ""), "index.kumalive.tooltip"));
        }
        orgBean.setLinks(links);
        orgBean.setMoreLinks(moreLinks);
        return orgBean;
    }

    private IndexOrgBean populateContentsOrgBean(IndexOrgBean orgBean, Organisation org, List<Integer> roles, String username, boolean isSysAdmin) throws SQLException, NamingException {
        Map<Long, IndexLessonBean> map = this.populateLessonBeans(this.getUser(username).getUserId(), org.getOrganisationId(), roles);
        List<IndexLessonBean> lessonBeans = IndexUtils.sortLessonBeans(org.getOrderedLessonIds(), map);
        orgBean.setLessons(lessonBeans);
        if (orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
            Set children = org.getChildOrganisations();
            ArrayList<IndexOrgBean> childOrgBeans = new ArrayList<IndexOrgBean>();
            for (Organisation organisation : children) {
                if (!OrganisationState.ACTIVE.equals(organisation.getOrganisationState().getOrganisationStateId())) continue;
                ArrayList<Integer> classRoles = new ArrayList<Integer>();
                List userOrganisationRoles = this.getUserManagementService().getUserOrganisationRoles(organisation.getOrganisationId(), username);
                if ((userOrganisationRoles == null || userOrganisationRoles.isEmpty()) && !isSysAdmin && !roles.contains(Role.ROLE_GROUP_ADMIN) && !roles.contains(Role.ROLE_GROUP_MANAGER)) continue;
                for (UserOrganisationRole userOrganisationRole : userOrganisationRoles) {
                    classRoles.add(userOrganisationRole.getRole().getRoleId());
                }
                if (roles.contains(Role.ROLE_GROUP_MANAGER)) {
                    classRoles.add(Role.ROLE_GROUP_MANAGER);
                }
                IndexOrgBean childOrgBean = this.createOrgBean(organisation, classRoles, username, isSysAdmin);
                childOrgBeans.add(childOrgBean);
            }
            Collections.sort(childOrgBeans);
            orgBean.setChildIndexOrgBeans(childOrgBeans);
        }
        return orgBean;
    }

    private Map<Long, IndexLessonBean> populateLessonBeans(Integer userId, Integer orgId, List<Integer> roles) throws SQLException, NamingException {
        Map map = this.getLessonService().getLessonsByOrgAndUserWithCompletedFlag(userId, orgId, Role.ROLE_LEARNER);
        Iterator lessonIter = map.entrySet().iterator();
        while (lessonIter.hasNext()) {
            Map.Entry entry = lessonIter.next();
            if (!((IndexLessonBean)entry.getValue()).isDependent() || lessonService.checkLessonReleaseConditions((Long)entry.getKey(), userId)) continue;
            lessonIter.remove();
        }
        for (IndexLessonBean bean : map.values()) {
            LinkedList lessonLinks = new LinkedList();
            String url = null;
            Integer lessonStateId = bean.getState();
            if (roles.contains(Role.ROLE_LEARNER) && (lessonStateId.equals(Lesson.STARTED_STATE) || lessonStateId.equals(Lesson.FINISHED_STATE))) {
                url = "javascript:openLearner(" + bean.getId() + ")";
            }
            if (lessonLinks.size() <= 0 && url == null) continue;
            bean.setUrl(url);
            bean.setLinks(lessonLinks);
        }
        Integer userRole = roles.contains(Role.ROLE_GROUP_MANAGER) ? Role.ROLE_GROUP_MANAGER : Role.ROLE_MONITOR;
        Map staffMap = this.getLessonService().getLessonsByOrgAndUserWithCompletedFlag(userId, orgId, userRole);
        boolean isGroupManagerOrMonitor = roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR);
        for (IndexLessonBean bean : staffMap.values()) {
            LinkedList<IndexLinkBean> lessonLinks;
            if (map.containsKey(bean.getId())) {
                bean = (IndexLessonBean)map.get(bean.getId());
            }
            if ((lessonLinks = (LinkedList<IndexLinkBean>)bean.getLinks()) == null) {
                lessonLinks = new LinkedList<IndexLinkBean>();
            }
            if (isGroupManagerOrMonitor) {
                lessonLinks.addFirst(new IndexLinkBean("index.monitor", "javascript:showMonitorLessonDialog(" + bean.getId() + ")", "fa fa-fw fa-heartbeat", null));
            }
            if (isGroupManagerOrMonitor && bean.isEnableLessonNotifications()) {
                lessonLinks.addFirst(new IndexLinkBean("index.emailnotifications", "javascript:showNotificationsDialog(null," + bean.getId() + ")", "fa fa-fw fa-bullhorn", "index.emailnotifications.tooltip"));
            }
            if (isGroupManagerOrMonitor) {
                String conditionsLink = "javascript:showConditionsDialog(" + bean.getId() + ")";
                lessonLinks.addFirst(new IndexLinkBean("index.conditions", conditionsLink, "fa fa-fw fa-code-fork", "index.conditions.tooltip"));
            }
            if (isGroupManagerOrMonitor) {
                String removeLessonLink = "javascript:removeLesson(" + bean.getId() + ")";
                lessonLinks.addFirst(new IndexLinkBean("index.remove.lesson", removeLessonLink, "fa fa-fw fa-trash-o", "index.remove.lesson.tooltip"));
            }
            if (lessonLinks.size() > 0) {
                bean.setLinks(lessonLinks);
            }
            map.put(bean.getId(), bean);
        }
        return map;
    }

    private User getUser(String login) {
        return (User)this.getUserManagementService().findByProperty(User.class, "login", (Object)login).get(0);
    }

    private IUserManagementService getUserManagementService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }

    private LessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (LessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private ILearningDesignService getLearningDesignService() {
        if (learningDesignService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            learningDesignService = (ILearningDesignService)ctx.getBean("learningDesignService");
        }
        return learningDesignService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)ctx.getBean("securityService");
        }
        return securityService;
    }

    private IKumaliveService getKumaliveService() {
        if (kumaliveService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            kumaliveService = (IKumaliveService)ctx.getBean("kumaliveService");
        }
        return kumaliveService;
    }
}

