/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GradebookServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(GradebookServlet.class);
    private static IntegrationService integrationService = null;
    private static IUserManagementService userManagementService;
    private static final String GRADEBOOK_MONITOR_LESSON_URL = "gradebook/gradebookMonitoring.do?lessonID=";
    private static final String GRADEBOOK_MONITOR_ORGANISATION_URL = "gradebook/gradebookMonitoring.do?dispatch=courseMonitor&organisationID=";
    private static final String GRADEBOOK_LEARNER_ORGANISATION_URL = "gradebook/gradebookLearning.do?dispatch=courseLearner&organisationID=";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getIntegrationService();
        this.getUserManagementService();
        HttpSession hses = request.getSession(true);
        String username = request.getParameter("uid");
        String serverId = request.getParameter("sid");
        String timestamp = request.getParameter("ts");
        String hash = request.getParameter("hash");
        String countryIsoCode = request.getParameter("country");
        String langIsoCode = request.getParameter("lang");
        String extCourseId = request.getParameter("courseid");
        String lessonId = request.getParameter("lsid");
        String courseName = request.getParameter("courseName");
        String method = request.getParameter("method");
        if (username == null || serverId == null || timestamp == null || hash == null || lessonId == null && extCourseId == null) {
            response.sendError(400, "Gradebook request failed - invalid parameters");
        } else {
            ExtServer extServer = integrationService.getExtServer(serverId);
            try {
                boolean isTeacher;
                Authenticator.authenticate((ExtServer)extServer, (String)timestamp, (String)username, (String)method, (String)hash);
                boolean bl = isTeacher = StringUtils.equals((String)method, (String)"author") || StringUtils.equals((String)method, (String)"monitor");
                if (lessonId == null) {
                    String gradebookServletURL = isTeacher ? GRADEBOOK_MONITOR_ORGANISATION_URL : GRADEBOOK_LEARNER_ORGANISATION_URL;
                    ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
                    ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer, userMap, extCourseId, courseName, this.getUserManagementService().getRootOrganisation().getOrganisationId().toString(), Boolean.valueOf(isTeacher), Boolean.valueOf(false));
                    Integer organisationId = orgMap.getOrganisation().getOrganisationId();
                    if (isTeacher) {
                        ArrayList<String> roles = new ArrayList<String>(Arrays.asList(Role.ROLE_GROUP_MANAGER.toString()));
                        userManagementService.setRolesForUserOrganisation(userMap.getUser(), organisationId, roles);
                    }
                    response.sendRedirect(Configuration.get((String)ConfigurationKeys.SERVER_URL) + gradebookServletURL + organisationId);
                } else if (isTeacher) {
                    response.sendRedirect(Configuration.get((String)ConfigurationKeys.SERVER_URL) + GRADEBOOK_MONITOR_LESSON_URL + lessonId);
                } else {
                    response.sendError(400, "There is no lesson level gradebook for learner");
                }
            }
            catch (AuthenticationException e) {
                log.error((Object)e);
                response.sendError(401, "Login failed - authentication error");
            }
            catch (UserInfoFetchException e) {
                log.error((Object)e);
                response.sendError(500, "Gradebook request failed - user info fetch exception");
            }
            catch (UserInfoValidationException e) {
                log.error((Object)e);
                response.sendError(400, "Gradebook request failed. " + e.getMessage());
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private IntegrationService getIntegrationService() {
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        }
        return integrationService;
    }

    protected IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            userManagementService = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("userManagementService");
        }
        return userManagementService;
    }
}

