/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.index.IndexLinkBean;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.policies.service.IPolicyService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.HtmlUtils;

public class IndexAction
extends LamsDispatchAction {
    private static final String PATH_PEDAGOGICAL_PLANNER = "pedagogical_planner";
    private static final String PATH_LAMS_CENTRAL = "lams-central.war";
    private static Logger log = Logger.getLogger(IndexAction.class);
    private static IUserManagementService userManagementService;
    private static IIntegrationService integrationService;
    private static IPolicyService policyService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean ssWarningShown;
        boolean isIntegrationUser;
        User loggedInUser;
        IndexAction.setHeaderLinks(request);
        this.setAdminLinks(request);
        HttpSession ss = SessionManager.getSession();
        UserDTO userDTO = (UserDTO)ss.getAttribute("user");
        if (userDTO.isFirstLogin().booleanValue()) {
            request.setAttribute("firstLogin", (Object)true);
            User user = this.getUserManagementService().getUserByLogin(userDTO.getLogin());
            user.setFirstLogin(Boolean.valueOf(false));
            this.getUserManagementService().saveUser(user);
            userDTO.setFirstLogin(Boolean.valueOf(false));
        }
        if ((loggedInUser = this.getUserManagementService().getUserByLogin(request.getRemoteUser())).getChangePassword() != null && loggedInUser.getChangePassword().booleanValue()) {
            return mapping.findForward("password");
        }
        if (loggedInUser.isTwoFactorAuthenticationEnabled().booleanValue() && loggedInUser.getTwoFactorAuthenticationSecret() == null) {
            return mapping.findForward("twoFactorAuthentication");
        }
        if (this.getPolicyService().isPolicyConsentRequiredForUser(loggedInUser.getUserId())) {
            return mapping.findForward("policyConsents");
        }
        User user = this.getUserManagementService().getUserByLogin(userDTO.getLogin());
        request.setAttribute("portraitUuid", (Object)user.getPortraitUuid());
        String method = WebUtil.readStrParam((HttpServletRequest)request, (String)"method", (boolean)true);
        if (StringUtils.equals((String)method, (String)"profile")) {
            return mapping.findForward("profile");
        }
        if (StringUtils.equals((String)method, (String)"editprofile")) {
            return mapping.findForward("editprofile");
        }
        if (StringUtils.equals((String)method, (String)"password")) {
            return mapping.findForward("password");
        }
        if (StringUtils.equals((String)method, (String)"portrait")) {
            return mapping.findForward("portrait");
        }
        if (StringUtils.equals((String)method, (String)"lessons")) {
            return mapping.findForward("lessons");
        }
        Boolean allowDirectAccessIntegrationLearner = Configuration.getAsBoolean((String)ConfigurationKeys.ALLOW_DIRECT_ACCESS_FOR_INTEGRATION_LEARNERS);
        if (!(allowDirectAccessIntegrationLearner.booleanValue() || !(isIntegrationUser = this.getIntegrationService().isIntegrationUser(userDTO.getUserID())) || request.isUserInRole("AUTHOR") || request.isUserInRole("MONITOR") || request.isUserInRole("GROUP MANAGER") || request.isUserInRole("GROUP ADMIN") || request.isUserInRole("SYSADMIN"))) {
            response.sendError(403, "Integration users with learner right are not allowed to access this page");
            return null;
        }
        Boolean tzWarning = Configuration.getAsBoolean((String)ConfigurationKeys.SHOW_TIMEZONE_WARNING);
        request.setAttribute("showTimezoneWarning", (Object)tzWarning);
        request.setAttribute("showTimezoneWarningPopup", (Object)false);
        if (tzWarning.booleanValue() && !Boolean.TRUE.equals(ssWarningShown = (Boolean)ss.getAttribute("timezoneWarningShown"))) {
            ss.setAttribute("timezoneWarningShown", (Object)Boolean.TRUE);
            request.setAttribute("showTimezoneWarningPopup", (Object)true);
        }
        List favoriteOrganisations = userManagementService.getFavoriteOrganisationsByUser(userDTO.getUserID());
        request.setAttribute("favoriteOrganisations", (Object)favoriteOrganisations);
        request.setAttribute("activeOrgId", (Object)user.getLastVisitedOrganisationId());
        boolean isSysadmin = request.isUserInRole("SYSADMIN");
        int userCoursesCount = userManagementService.getCountActiveCoursesByUser(userDTO.getUserID(), isSysadmin, null);
        request.setAttribute("isCourseSearchOn", (Object)(userCoursesCount > 10 ? 1 : 0));
        return mapping.findForward("main");
    }

    private static void setHeaderLinks(HttpServletRequest request) {
        ArrayList<IndexLinkBean> headerLinks = new ArrayList<IndexLinkBean>();
        if (request.isUserInRole("AUTHOR")) {
            if (IndexAction.isPedagogicalPlannerAvailable()) {
                headerLinks.add(new IndexLinkBean("index.planner", "javascript:openPedagogicalPlanner()"));
            }
            headerLinks.add(new IndexLinkBean("index.author", "javascript:showAuthoringDialog()"));
        }
        String customTabText = Configuration.get((String)ConfigurationKeys.CUSTOM_TAB_TITLE);
        String customTabLink = Configuration.get((String)ConfigurationKeys.CUSTOM_TAB_LINK);
        if (customTabLink != null && customTabLink.trim().length() > 0) {
            headerLinks.add(new IndexLinkBean(customTabText, "javascript:openCustom(\"" + customTabLink + "\")"));
        }
        request.setAttribute("headerLinks", headerLinks);
    }

    private void setAdminLinks(HttpServletRequest request) {
        ArrayList<IndexLinkBean> adminLinks = new ArrayList<IndexLinkBean>();
        if (request.isUserInRole("SYSADMIN") || request.isUserInRole("GROUP ADMIN") || request.isUserInRole("GROUP MANAGER")) {
            adminLinks.add(new IndexLinkBean("index.courseman", "javascript:openOrgManagement(" + this.getUserManagementService().getRootOrganisation().getOrganisationId() + ')'));
        }
        if (request.isUserInRole("SYSADMIN") || this.getUserManagementService().isUserGlobalGroupAdmin()) {
            adminLinks.add(new IndexLinkBean("index.sysadmin", "javascript:openSysadmin()"));
        }
        request.setAttribute("adminLinks", adminLinks);
    }

    public ActionForward getOrgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse res) throws IOException, ServletException, JSONException {
        this.getUserManagementService();
        User loggedInUser = this.getUserManagementService().getUserByLogin(request.getRemoteUser());
        Integer userId = loggedInUser.getUserId();
        boolean isSysadmin = request.isUserInRole("SYSADMIN");
        String searchString = WebUtil.readStrParam((HttpServletRequest)request, (String)"fcol[1]", (boolean)true);
        int size = WebUtil.readIntParam((HttpServletRequest)request, (String)"size");
        int page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
        List orgDtos = userManagementService.getActiveCoursesByUser(userId, isSysadmin, page, size, searchString);
        JSONObject responcedata = new JSONObject();
        responcedata.put("total_rows", userManagementService.getCountActiveCoursesByUser(userId, isSysadmin, searchString));
        JSONArray rows = new JSONArray();
        for (OrganisationDTO orgDto : orgDtos) {
            JSONObject responseRow = new JSONObject();
            responseRow.put("id", (Object)orgDto.getOrganisationID());
            String orgName = orgDto.getName() == null ? "" : orgDto.getName();
            responseRow.put("name", (Object)HtmlUtils.htmlEscape((String)orgName));
            rows.put((Object)responseRow);
        }
        responcedata.put("rows", (Object)rows);
        res.setContentType("application/json;charset=utf-8");
        res.getWriter().print(new String(responcedata.toString()));
        return null;
    }

    public ActionForward toggleFavoriteOrganisation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse res) throws IOException, ServletException {
        this.getUserManagementService();
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)false);
        Integer userId = this.getUserId();
        if (orgId != null) {
            userManagementService.toggleOrganisationFavorite(orgId, userId);
        }
        List favoriteOrganisations = userManagementService.getFavoriteOrganisationsByUser(userId);
        request.setAttribute("favoriteOrganisations", (Object)favoriteOrganisations);
        String activeOrgId = request.getParameter("activeOrgId");
        request.setAttribute("activeOrgId", (Object)activeOrgId);
        return mapping.findForward("favoriteOrganisations");
    }

    public ActionForward storeLastVisitedOrganisation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse res) throws IOException, ServletException {
        this.getUserManagementService();
        Integer lastVisitedOrganisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)false);
        if (lastVisitedOrganisationId != null) {
            User user = userManagementService.getUserByLogin(request.getRemoteUser());
            user.setLastVisitedOrganisationId(lastVisitedOrganisationId);
            userManagementService.saveUser(user);
        }
        return null;
    }

    private Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO learner = (UserDTO)ss.getAttribute("user");
        return learner != null ? learner.getUserID() : null;
    }

    private IIntegrationService getIntegrationService() {
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext()).getBean("integrationService");
        }
        return integrationService;
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private IPolicyService getPolicyService() {
        if (policyService == null) {
            policyService = (IPolicyService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext()).getBean("policyService");
        }
        return policyService;
    }

    private static boolean isPedagogicalPlannerAvailable() {
        String lamsEarPath = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR);
        String plannerPath = lamsEarPath + File.separator + PATH_LAMS_CENTRAL + File.separator + PATH_PEDAGOGICAL_PLANNER;
        File plannerDir = new File(plannerPath);
        return plannerDir.isDirectory();
    }
}

