/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationGroup;
import org.lamsfoundation.lams.usermanagement.OrganisationGrouping;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class OrganisationGroupServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(OrganisationGroupServlet.class);
    private static IntegrationService integrationService;
    private static IUserManagementService userManagementService;
    private static final String METHOD_ADD_GROUPING = "addGrouping";
    private static final String METHOD_REMOVE_GROUPING = "removeGrouping";
    private static final String METHOD_ADD_GROUP = "addGroup";
    private static final String METHOD_REMOVE_GROUP = "removeGroup";
    private static final String METHOD_ADD_LEARNERS = "addLearners";
    private static final String METHOD_REMOVE_LEARNERS = "removeLearners";
    private static final String PARAM_GROUPING_NAME = "groupingName";
    private static final String PARAM_GROUP_NAME = "groupName";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String serverId = request.getParameter("serverId");
        String datetime = request.getParameter("datetime");
        String hashValue = request.getParameter("hashValue");
        String username = request.getParameter("username");
        String courseId = request.getParameter("courseId");
        if (username == null || serverId == null || datetime == null || hashValue == null || courseId == null) {
            response.sendError(400, "Course group action failed - authentication parameters missing");
            return;
        }
        User user = null;
        Organisation organisation = null;
        ExtServer extServer = this.getService().getExtServer(serverId);
        try {
            boolean isGroupSuperuser;
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer, userMap, courseId, null, "monitor");
            user = userMap.getUser();
            organisation = orgMap.getOrganisation();
            boolean bl = isGroupSuperuser = this.getUserManagementService().isUserInRole(user.getUserId(), organisation.getOrganisationId(), "MONITOR") || this.getUserManagementService().isUserInRole(user.getUserId(), organisation.getOrganisationId(), "AUTHOR");
            if (!isGroupSuperuser) {
                log.error((Object)("User " + user.getUserId() + " may not perform group actions for course " + organisation.getOrganisationId()));
                response.sendError(401, "Course group action failed - user may not perform group actions");
                return;
            }
        }
        catch (AuthenticationException e) {
            log.error((Object)e);
            response.sendError(401, "Course group action failed - authentication error");
            return;
        }
        catch (UserInfoFetchException e) {
            log.error((Object)e);
            response.sendError(401, "Course group action failed - user does not exist");
            return;
        }
        catch (UserInfoValidationException e) {
            log.error((Object)e);
            response.sendError(400, "Course group action failed." + e.getMessage());
            return;
        }
        try {
            String method = request.getParameter("method");
            if (METHOD_ADD_GROUPING.equals(method)) {
                this.addGrouping(request, organisation);
            } else if (METHOD_REMOVE_GROUPING.equals(method)) {
                this.removeGrouping(request, organisation.getOrganisationId());
            } else if (METHOD_ADD_GROUP.equals(method)) {
                this.addGroup(request, organisation.getOrganisationId());
            } else if (METHOD_REMOVE_GROUP.equals(method)) {
                this.removeGroup(request, organisation.getOrganisationId());
            } else if (METHOD_ADD_LEARNERS.equals(method)) {
                this.addLearners(request, extServer, organisation.getOrganisationId());
            } else if (METHOD_REMOVE_LEARNERS.equals(method)) {
                this.removeLearners(request, extServer, organisation.getOrganisationId());
            }
        }
        catch (ServletException e) {
            log.error((Object)e);
            response.sendError(400, "Course group action failed: " + e.getMessage());
            return;
        }
        catch (Exception e) {
            log.error((Object)e);
            response.sendError(500, "Course group action failed: internal error");
            return;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void addGrouping(HttpServletRequest request, Organisation organisation) throws ServletException {
        String groupingName = request.getParameter(PARAM_GROUPING_NAME);
        if (StringUtils.isBlank((String)groupingName)) {
            throw new ServletException("Missing \"name\" parameter");
        }
        OrganisationGrouping grouping = this.findGrouping(organisation.getOrganisationId(), groupingName);
        if (grouping != null) {
            throw new ServletException("Grouping with name \"" + groupingName + "\" exists in organisation with ID " + organisation.getOrganisationId());
        }
        grouping = new OrganisationGrouping(organisation.getOrganisationId(), groupingName);
        this.getUserManagementService().saveOrganisationGrouping(grouping, null);
        Long groupingId = grouping.getGroupingId();
        if (groupingId == null) {
            throw new ServletException("Grouping could not be created");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created course grouping \"" + groupingName + "\" with ID " + groupingId + " in organisation with ID " + organisation.getOrganisationId()));
        }
    }

    private void removeGrouping(HttpServletRequest request, Integer organisationId) throws ServletException {
        String groupingName = request.getParameter(PARAM_GROUPING_NAME);
        if (StringUtils.isBlank((String)groupingName)) {
            throw new ServletException("Missing \"groupingName\" parameter");
        }
        OrganisationGrouping grouping = this.findGrouping(organisationId, groupingName);
        if (grouping == null) {
            return;
        }
        this.getUserManagementService().delete((Object)grouping);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted course grouping with ID " + groupingName + " from organisation with ID " + organisationId));
        }
    }

    private void addGroup(HttpServletRequest request, Integer organisationId) throws ServletException {
        String groupingName = request.getParameter(PARAM_GROUPING_NAME);
        if (StringUtils.isBlank((String)groupingName)) {
            throw new ServletException("Missing \"groupingName\" parameter");
        }
        String groupName = request.getParameter(PARAM_GROUP_NAME);
        if (StringUtils.isBlank((String)groupName)) {
            throw new ServletException("Missing \"groupName\" parameter");
        }
        OrganisationGrouping grouping = this.findGrouping(organisationId, groupingName);
        if (grouping == null) {
            throw new ServletException("Grouping with name \"" + groupingName + "\" does not exist in organisation with ID " + organisationId);
        }
        HashSet<OrganisationGroup> groups = new HashSet<OrganisationGroup>(grouping.getGroups());
        for (OrganisationGroup group : groups) {
            if (!group.getName().equals(groupName)) continue;
            throw new ServletException("Group with name \"" + groupingName + "\" exists in grouping with ID " + grouping.getGroupingId());
        }
        OrganisationGroup newGroup = new OrganisationGroup();
        newGroup.setName(groupName);
        groups.add(newGroup);
        this.getUserManagementService().saveOrganisationGrouping(grouping, groups);
        Long groupId = newGroup.getGroupId();
        if (groupId == null) {
            throw new ServletException("Group could not be created");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created course group \"" + groupName + "\" with ID " + groupId + " in organisation with ID " + organisationId));
        }
    }

    private void removeGroup(HttpServletRequest request, Integer organisationId) throws ServletException {
        String groupingName = request.getParameter(PARAM_GROUPING_NAME);
        if (StringUtils.isBlank((String)groupingName)) {
            throw new ServletException("Missing \"groupingName\" parameter");
        }
        String groupName = request.getParameter(PARAM_GROUP_NAME);
        if (StringUtils.isBlank((String)groupName)) {
            throw new ServletException("Missing \"groupName\" parameter");
        }
        OrganisationGrouping grouping = this.findGrouping(organisationId, groupingName);
        if (grouping == null) {
            return;
        }
        OrganisationGroup group = this.findGroup(grouping.getGroupingId(), groupName);
        if (group == null) {
            return;
        }
        HashSet groups = new HashSet(grouping.getGroups());
        groups.remove(group);
        this.getUserManagementService().saveOrganisationGrouping(grouping, groups);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted course group with ID " + group.getGroupId() + " from organisation with ID " + organisationId));
        }
    }

    private void addLearners(HttpServletRequest request, ExtServer extServer, Integer organisationId) throws ServletException {
        String groupingName = request.getParameter(PARAM_GROUPING_NAME);
        if (StringUtils.isBlank((String)groupingName)) {
            throw new ServletException("Missing \"groupingName\" parameter");
        }
        String groupName = request.getParameter(PARAM_GROUP_NAME);
        if (StringUtils.isBlank((String)groupName)) {
            throw new ServletException("Missing \"groupName\" parameter");
        }
        String learnerIds = request.getParameter("learnerIds");
        if (StringUtils.isBlank((String)learnerIds)) {
            throw new ServletException("Missing \"learnerIds\" parameter");
        }
        OrganisationGrouping grouping = this.findGrouping(organisationId, groupingName);
        if (grouping == null) {
            throw new ServletException("Grouping with name \"" + groupingName + "\" does not exist");
        }
        OrganisationGroup group = this.findGroup(grouping.getGroupingId(), groupName);
        if (group == null) {
            throw new ServletException("Group with name \"" + groupName + "\" does not exist in grouping with ID " + grouping.getGroupingId());
        }
        String[] learnerLoginArray = learnerIds.split(",");
        boolean learnersAdded = false;
        StringBuilder addedLearnerLogins = new StringBuilder();
        for (String learnerLogin : learnerLoginArray) {
            User learner = null;
            try {
                ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, learnerLogin);
                learner = userMap.getUser();
            }
            catch (UserInfoFetchException e) {
                throw new ServletException("Learner with ID \"" + learnerLogin + "\" does not exist");
            }
            catch (UserInfoValidationException e) {
                throw new ServletException(e.getMessage());
            }
            boolean learnerAdded = group.getUsers().add(learner);
            if (!learnerAdded) continue;
            learnersAdded = true;
            addedLearnerLogins.append(learnerLogin).append(',');
        }
        if (learnersAdded) {
            this.getUserManagementService().saveOrganisationGrouping(grouping, (Collection)grouping.getGroups());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added learners " + addedLearnerLogins + " to course group with ID " + group.getGroupId() + " in organisation with ID " + organisationId));
            }
        }
    }

    private void removeLearners(HttpServletRequest request, ExtServer extServer, Integer organisationId) throws ServletException {
        String groupingName = request.getParameter(PARAM_GROUPING_NAME);
        if (StringUtils.isBlank((String)groupingName)) {
            throw new ServletException("Missing \"groupingName\" parameter");
        }
        String groupName = request.getParameter(PARAM_GROUP_NAME);
        if (StringUtils.isBlank((String)groupName)) {
            throw new ServletException("Missing \"groupName\" parameter");
        }
        String learnerIds = request.getParameter("learnerIds");
        if (StringUtils.isBlank((String)learnerIds)) {
            throw new ServletException("Missing \"learnerIds\" parameter");
        }
        OrganisationGrouping grouping = this.findGrouping(organisationId, groupingName);
        if (grouping == null) {
            throw new ServletException("Grouping with name \"" + groupingName + "\" does not exist");
        }
        OrganisationGroup group = this.findGroup(grouping.getGroupingId(), groupName);
        if (group == null) {
            throw new ServletException("Group with name \"" + groupName + "\" does not exist in grouping with ID " + grouping.getGroupingId());
        }
        String[] learnerLoginArray = learnerIds.split(",");
        boolean learnersRemoved = false;
        StringBuilder removedLearnerLogins = new StringBuilder();
        for (String learnerLogin : learnerLoginArray) {
            User learner = null;
            try {
                ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, learnerLogin);
                learner = userMap.getUser();
            }
            catch (UserInfoFetchException e) {
                continue;
            }
            catch (UserInfoValidationException e) {
                continue;
            }
            boolean learnerRemoved = group.getUsers().remove(learner);
            if (!learnerRemoved) continue;
            learnersRemoved = true;
            removedLearnerLogins.append(learnerLogin).append(',');
        }
        if (learnersRemoved) {
            this.getUserManagementService().saveOrganisationGrouping(grouping, (Collection)grouping.getGroups());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed learners " + removedLearnerLogins + " from group with ID " + group.getGroupId() + " in organisation with ID " + organisationId));
            }
        }
    }

    private OrganisationGrouping findGrouping(Integer organisationId, String groupingName) {
        TreeMap<String, Object> queryProperties = new TreeMap<String, Object>();
        queryProperties.put("organisationId", organisationId);
        queryProperties.put("name", groupingName);
        List result = this.getUserManagementService().findByProperties(OrganisationGrouping.class, queryProperties);
        return result == null || result.isEmpty() ? null : (OrganisationGrouping)result.get(0);
    }

    private OrganisationGroup findGroup(Long groupingId, String groupName) {
        TreeMap<String, Object> queryProperties = new TreeMap<String, Object>();
        queryProperties.put("groupingId", groupingId);
        queryProperties.put("name", groupName);
        List result = this.getUserManagementService().findByProperties(OrganisationGroup.class, queryProperties);
        return result == null || result.isEmpty() ? null : (OrganisationGroup)result.get(0);
    }

    private IntegrationService getService() {
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        }
        return integrationService;
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }
}

