/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.ValidationUtil;
import org.lamsfoundation.lams.web.PasswordChangeActionForm;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PasswordChangeAction
extends Action {
    private static Logger log = Logger.getLogger(PasswordChangeAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            request.getSession().removeAttribute("PasswordChangeActionForm");
            return mapping.findForward("cancelled");
        }
        ActionMessages errors = new ActionMessages();
        PasswordChangeActionForm passwordChangeForm = (PasswordChangeActionForm)form;
        if (errors.isEmpty()) {
            try {
                String loggedInUser = request.getRemoteUser();
                String login = passwordChangeForm.getLogin();
                String oldPassword = passwordChangeForm.getOldPassword();
                String password = passwordChangeForm.getPassword();
                String passwordConfirm = passwordChangeForm.getPasswordConfirm();
                if (loggedInUser == null || !loggedInUser.equals(login)) {
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.authorisation"));
                } else {
                    String passwordHash;
                    WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServlet().getServletContext());
                    UserManagementService service = (UserManagementService)ctx.getBean("userManagementService");
                    User user = service.getUserByLogin(login);
                    String string = passwordHash = user.getPassword().length() == 40 ? HashUtil.sha1((String)oldPassword) : HashUtil.sha256((String)oldPassword, (String)user.getSalt());
                    if (!user.getPassword().equals(passwordHash)) {
                        errors.add("oldPassword", new ActionMessage("error.oldpassword.mismatch"));
                        log.debug((Object)"old pass wrong");
                    }
                    if (!password.equals(passwordConfirm)) {
                        errors.add("password", new ActionMessage("error.newpassword.mismatch"));
                        log.debug((Object)"new pass wrong");
                    }
                    if (password == null || password.length() == 0) {
                        errors.add("password", new ActionMessage("error.password.empty"));
                        log.debug((Object)"new password cannot be empty");
                    }
                    if (!ValidationUtil.isPasswordValueValid((String)password, (String)passwordConfirm)) {
                        errors.add("password", new ActionMessage("label.password.restrictions"));
                        log.debug((Object)"Password must follow the restrictions");
                    }
                    if (errors.isEmpty()) {
                        String salt = HashUtil.salt();
                        user.setSalt(salt);
                        user.setPassword(HashUtil.sha256((String)password, (String)salt));
                        user.setChangePassword(Boolean.valueOf(false));
                        service.saveUser(user);
                        ILogEventService logEventService = (ILogEventService)ctx.getBean("logEventService");
                        MessageService messageService = (MessageService)ctx.getBean("centralMessageService");
                        Object[] args = new String[]{user.getLogin() + " (" + user.getUserId() + ")"};
                        String message = messageService.getMessage("audit.user.password.change", args);
                        logEventService.logEvent(Integer.valueOf(12), user.getUserId(), user.getUserId(), null, null, message);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            this.saveMessages(request, errors);
            if (mapping.getInput() != null) {
                passwordChangeForm.reset(mapping, request);
                return mapping.findForward("errors");
            }
            return mapping.findForward("error.system");
        }
        request.setAttribute("redirectURL", (Object)passwordChangeForm.getRedirectURL());
        return mapping.findForward("okay");
    }
}

