/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.CentralToolContentHandler;
import org.lamsfoundation.lams.util.CommonConstants;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.imgscalr.ResizePictureUtil;
import org.lamsfoundation.lams.web.PortraitActionForm;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortraitSaveAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(PortraitSaveAction.class);
    private static IUserManagementService service;
    private static ILogEventService logEventService;
    private static MessageService messageService;
    private static CentralToolContentHandler centralToolContentHandler;
    private static final String PORTRAIT_DELETE_AUDIT_KEY = "audit.delete.portrait";

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            return mapping.findForward("profile");
        }
        ActionMessages errors = new ActionMessages();
        PortraitActionForm portraitForm = (PortraitActionForm)form;
        FormFile file = portraitForm.getFile();
        String fileName = file.getFileName();
        log.debug((Object)("got file: " + fileName + " of type: " + file.getContentType() + " with size: " + file.getFileSize()));
        User user = this.getService().getUserByLogin(request.getRemoteUser());
        String mediaType = file.getContentType().split("/", 2)[0];
        if (!mediaType.equals("image")) {
            errors.add("file", new ActionMessage("error.portrait.not.image"));
            this.saveErrors(request, errors);
            return mapping.findForward("errors");
        }
        InputStream is = file.getInputStream();
        if (is == null) {
            errors.add("file", new ActionMessage("error.general.1"));
            this.saveErrors(request, errors);
            return mapping.findForward("errors");
        }
        NodeKey originalFileNode = null;
        if (file != null && !StringUtils.isEmpty((String)fileName)) {
            String fileNameWithoutExt;
            if (fileName.equals("blob")) {
                HttpSession ss = SessionManager.getSession();
                UserDTO userDTO = (UserDTO)ss.getAttribute("user");
                fileNameWithoutExt = userDTO.getLogin() + "_portrait";
            } else {
                fileNameWithoutExt = fileName.substring(0, fileName.indexOf(46));
            }
            originalFileNode = this.getCentralToolContentHandler().uploadFile(is, fileNameWithoutExt + "_original.jpg", "image/jpeg");
            is.close();
            log.debug((Object)("saved file with uuid: " + originalFileNode.getUuid() + " and version: " + originalFileNode.getVersion()));
            is = ResizePictureUtil.resize((InputStream)file.getInputStream(), (int)CommonConstants.PORTRAIT_LARGEST_DIMENSION_LARGE);
            NodeKey node = this.getCentralToolContentHandler().updateFile(originalFileNode.getUuid(), is, fileNameWithoutExt + "_large.jpg", "image/jpeg");
            is.close();
            log.debug((Object)("saved file with uuid: " + node.getUuid() + " and version: " + node.getVersion()));
            is = ResizePictureUtil.resize((InputStream)file.getInputStream(), (int)CommonConstants.PORTRAIT_LARGEST_DIMENSION_MEDIUM);
            node = this.getCentralToolContentHandler().updateFile(node.getUuid(), is, fileNameWithoutExt + "_medium.jpg", "image/jpeg");
            is.close();
            log.debug((Object)("saved file with uuid: " + node.getUuid() + " and version: " + node.getVersion()));
            is = ResizePictureUtil.resize((InputStream)file.getInputStream(), (int)CommonConstants.PORTRAIT_LARGEST_DIMENSION_SMALL);
            node = this.getCentralToolContentHandler().updateFile(node.getUuid(), is, fileNameWithoutExt + "_small.jpg", "image/jpeg");
            is.close();
            log.debug((Object)("saved file with uuid: " + node.getUuid() + " and version: " + node.getVersion()));
        }
        if (user.getPortraitUuid() != null) {
            this.getCentralToolContentHandler().deleteFile(user.getPortraitUuid());
        }
        user.setPortraitUuid(originalFileNode.getUuid());
        this.getService().saveUser(user);
        return mapping.findForward("profile");
    }

    public ActionForward deletePortrait(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId", (boolean)true);
        if (!request.isUserInRole("SYSADMIN")) {
            log.error((Object)("Attempt to delete a portrait by user that is not sysadmin. User is " + request.getRemoteUser() + " portrait to be deleted is for user " + userId + "."));
            return this.deleteResponse(response, "error");
        }
        String responseValue = "deleted";
        User userToModify = (User)this.getService().findById(User.class, (Serializable)userId);
        if (userToModify != null && userToModify.getPortraitUuid() != null) {
            UserDTO sysadmin = (UserDTO)SessionManager.getSession().getAttribute("user");
            Object[] args = new Object[]{userToModify.getFullName(), userToModify.getLogin(), userToModify.getUserId(), userToModify.getPortraitUuid()};
            String auditMessage = this.getMessageService().getMessage(PORTRAIT_DELETE_AUDIT_KEY, args);
            this.getLogEventService().logEvent(Integer.valueOf(11), sysadmin.getUserID(), userId, null, null, auditMessage);
            try {
                this.getCentralToolContentHandler().deleteFile(userToModify.getPortraitUuid());
                userToModify.setPortraitUuid(null);
                this.getService().saveUser(userToModify);
            }
            catch (Exception e) {
                log.error((Object)("Unable to delete a portrait for user " + userId + "."), (Throwable)e);
                return this.deleteResponse(response, "error");
            }
        }
        return this.deleteResponse(response, responseValue);
    }

    private ActionForward deleteResponse(HttpServletResponse response, String data) throws IOException {
        response.setContentType("text/plain;charset=utf-8");
        response.getWriter().write(data);
        return null;
    }

    private CentralToolContentHandler getCentralToolContentHandler() {
        if (centralToolContentHandler == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            centralToolContentHandler = (CentralToolContentHandler)((Object)wac.getBean("centralToolContentHandler"));
        }
        return centralToolContentHandler;
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }

    private ILogEventService getLogEventService() {
        if (logEventService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            logEventService = (ILogEventService)ctx.getBean("logEventService");
        }
        return logEventService;
    }

    private MessageService getMessageService() {
        if (messageService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            messageService = (MessageService)ctx.getBean("centralMessageService");
        }
        return messageService;
    }
}

