/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.questions.Question;
import org.lamsfoundation.lams.questions.QuestionParser;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class QuestionsAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DiskFileUpload formParser = new DiskFileUpload();
        formParser.setRepositoryPath(Configuration.get((String)ConfigurationKeys.LAMS_TEMP_DIR));
        List formFields = formParser.parseRequest(request);
        String returnURL = null;
        String limitTypeParam = null;
        InputStream uploadedFileStream = null;
        String packageName = null;
        for (FileItem formField : formFields) {
            String fieldName = formField.getFieldName();
            if ("returnURL".equals(fieldName)) {
                returnURL = formField.getString();
                continue;
            }
            if ("limitType".equals(fieldName)) {
                limitTypeParam = formField.getString();
                continue;
            }
            if (!"file".equals(fieldName) || StringUtils.isBlank((String)formField.getName())) continue;
            packageName = formField.getName().toLowerCase();
            uploadedFileStream = formField.getInputStream();
        }
        request.setAttribute("returnURL", returnURL);
        request.setAttribute("limitType", limitTypeParam);
        if (uploadedFileStream == null || !packageName.endsWith(".zip") && !packageName.endsWith(".xml")) {
            ActionMessages errors = new ActionMessages();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("label.questions.file.missing"));
            request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
            return mapping.findForward("questionFile");
        }
        TreeSet limitType = null;
        if (!StringUtils.isBlank((String)limitTypeParam)) {
            limitType = new TreeSet();
            Collections.addAll(limitType, limitTypeParam.split(","));
        }
        Question[] questions = packageName.endsWith(".xml") ? QuestionParser.parseQTIFile(uploadedFileStream, null, limitType) : QuestionParser.parseQTIPackage(uploadedFileStream, limitType);
        request.setAttribute("questions", (Object)questions);
        return mapping.findForward("questionChoice");
    }
}

