/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RedirectAction
extends LamsAction {
    private static Logger log = Logger.getLogger(RedirectAction.class);
    public static final String PARAM_HASH = "h";
    public static final String ACCESS_MODE_TEACHER = "t";
    public static final String ACCESS_MODE_LEARNER = "l";
    private static ILamsToolService lamsToolService;
    private static IUserManagementService userService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws Exception {
        try {
            String hash = WebUtil.readStrParam((HttpServletRequest)req, (String)PARAM_HASH);
            String fullParams = new String(Base64.decodeBase64((byte[])hash.getBytes()));
            String[] split = fullParams.split(",");
            if (split.length != 3) {
                throw new Exception("Hash did not contain correct format (relative path, toolSessionID, toolaccess )");
            }
            String relativePath = split[0];
            Long toolSessionID = Long.parseLong(split[1]);
            String accessMode = split[2];
            UserDTO user = this.getUser();
            if (user == null) {
                log.error((Object)"admin: User missing from session. ");
                return mapping.findForward("error");
            }
            ToolSession toolSession = this.getToolSession(toolSessionID);
            if (toolSession == null) {
                log.error((Object)("No ToolSession with ID " + toolSessionID + " found."));
                return mapping.findForward("error");
            }
            Lesson lesson = toolSession.getLesson();
            if (accessMode.equals(ACCESS_MODE_LEARNER)) {
                if (lesson == null || !lesson.isLessonStarted()) {
                    return this.displayMessage(mapping, req, "message.lesson.not.started.cannot.participate");
                }
                if (!toolSession.getLearners().contains(this.getRealUser(user))) {
                    log.error((Object)("learner: User " + user.getLogin() + " is not a learner in the requested group. Cannot access the lesson."));
                    return this.displayMessage(mapping, req, "error.authorisation");
                }
            } else if (accessMode.equals(ACCESS_MODE_TEACHER)) {
                if (lesson.getLessonClass() == null || !lesson.getLessonClass().isStaffMember(this.getRealUser(user))) {
                    log.error((Object)("learner: User " + user.getLogin() + " is not a learner in the requested lesson. Cannot access the lesson."));
                    return this.displayMessage(mapping, req, "error.authorisation");
                }
            } else {
                throw new Exception("Mode " + accessMode + " is not allowed.");
            }
            res.sendRedirect(Configuration.get((String)ConfigurationKeys.SERVER_URL) + relativePath);
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Failed redirect to url", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    private ActionForward displayMessage(ActionMapping mapping, HttpServletRequest req, String messageKey) {
        req.setAttribute("messageKey", (Object)messageKey);
        return mapping.findForward("message");
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private User getRealUser(UserDTO dto) {
        return this.getUserService().getUserByLogin(dto.getLogin());
    }

    private ToolSession getToolSession(Long toolSessionID) {
        return this.getLamsToolService().getToolSession(toolSessionID);
    }

    private IUserManagementService getUserService() {
        if (userService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userService;
    }

    public static void setUserService(IUserManagementService userService) {
        RedirectAction.userService = userService;
    }

    private ILamsToolService getLamsToolService() {
        if (lamsToolService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lamsToolService = (ILamsToolService)ctx.getBean("lamsToolService");
        }
        return lamsToolService;
    }

    public static void setLamsToolService(ILamsToolService lamsToolService) {
        RedirectAction.lamsToolService = lamsToolService;
    }
}

