/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class RuntimeStatsServlet
extends HttpServlet {
    private static final long serialVersionUID = 6834774025623257743L;
    private static Logger log = Logger.getLogger(RuntimeStatsServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isLongStats = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"long", (boolean)false);
        String stats = null;
        if (isLongStats) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Getting long runtime stats");
            }
            stats = RuntimeStatsServlet.getLongStats();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Getting short runtime stats");
            }
            stats = RuntimeStatsServlet.getShortStats();
        }
        if (stats != null) {
            response.setContentType("text/plain;charset=utf-8");
            response.getWriter().write(stats);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private static String getShortStats() {
        StringBuilder resp = new StringBuilder();
        Date date = new Date();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName dataSourceName = new ObjectName("jboss.as.expr:subsystem=datasources,data-source=lams-ds,statistics=pool");
            Integer activeCount = Integer.valueOf((String)server.getAttribute(dataSourceName, "ActiveCount"));
            resp.append("Overall Status : ok");
            if (activeCount > 0) {
                resp.append(" - DB connection established");
            }
            resp.append("\nServer : ").append(SessionManager.getJvmRoute()).append("\n");
            resp.append("Current Sessions : ").append(SessionManager.getSessionCount()).append("\n");
            resp.append("Time of Request : ").append(date);
        }
        catch (Exception e) {
            log.error((Object)"Error while getting short runtime stats", (Throwable)e);
        }
        return resp.toString();
    }

    private static String getLongStats() {
        StringBuilder resp = new StringBuilder();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            resp.append("jvmRoute: ").append(SessionManager.getJvmRoute()).append("\n");
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage memoryUsage = memoryBean.getHeapMemoryUsage();
            resp.append("Heap memory MB [init/used/committed/max]: ").append(RuntimeStatsServlet.toMB(memoryUsage.getInit())).append("/").append(RuntimeStatsServlet.toMB(memoryUsage.getUsed())).append("/").append(RuntimeStatsServlet.toMB(memoryUsage.getCommitted())).append("/").append(RuntimeStatsServlet.toMB(memoryUsage.getMax())).append("\n");
            memoryUsage = memoryBean.getNonHeapMemoryUsage();
            resp.append("Non-heap memory MB [init/used/committed/max]: ").append(RuntimeStatsServlet.toMB(memoryUsage.getInit())).append("/").append(RuntimeStatsServlet.toMB(memoryUsage.getUsed())).append("/").append(RuntimeStatsServlet.toMB(memoryUsage.getCommitted())).append("/").append(RuntimeStatsServlet.toMB(memoryUsage.getMax())).append("\n");
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            resp.append("JVM threads [daemon/total/peak]: ").append(threadBean.getDaemonThreadCount()).append("/").append(threadBean.getThreadCount()).append("/").append(threadBean.getPeakThreadCount()).append("\n");
            resp.append("Active sessions : ").append(SessionManager.getSessionCount()).append("\n");
            ObjectName dataSourceName = new ObjectName("jboss.as.expr:subsystem=datasources,data-source=lams-ds,statistics=pool");
            String inUseConnections = (String)server.getAttribute(dataSourceName, "InUseCount");
            String activeConnections = (String)server.getAttribute(dataSourceName, "ActiveCount");
            String availConnections = (String)server.getAttribute(dataSourceName, "AvailableCount");
            resp.append("Connections [in use/active/total]: ").append(inUseConnections).append("/").append(activeConnections).append("/").append(availConnections).append("\n");
        }
        catch (Exception e) {
            log.error((Object)"Error while getting long runtime stats", (Throwable)e);
        }
        return resp.toString();
    }

    private static long toMB(long bytes) {
        return bytes / 1024L / 1024L;
    }
}

