/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.action;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.signup.model.SignupOrganisation;
import org.lamsfoundation.lams.signup.service.ISignupService;
import org.lamsfoundation.lams.timezone.service.ITimezoneService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.Emailer;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.ValidationUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SignupAction
extends Action {
    private static Logger log = Logger.getLogger(SignupAction.class);
    private static ISignupService signupService = null;
    private static ITimezoneService timezoneService = null;
    private static MessageService messageService = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String method = WebUtil.readStrParam((HttpServletRequest)request, (String)"method", (boolean)true);
        if (StringUtils.equals((String)method, (String)"emailVerify")) {
            return this.emailVerify(mapping, form, request, response);
        }
        if (signupService == null || timezoneService == null || messageService == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            signupService = (ISignupService)wac.getBean("signupService");
            timezoneService = (ITimezoneService)wac.getBean("timezoneService");
            messageService = (MessageService)wac.getBean("centralMessageService");
        }
        request.setAttribute("countryCodes", (Object)LanguageUtil.getCountryCodes((boolean)true));
        DynaActionForm signupForm = (DynaActionForm)form;
        String context = WebUtil.readStrParam((HttpServletRequest)request, (String)"context", (boolean)true);
        SignupOrganisation signupOrganisation = null;
        if (StringUtils.isNotBlank((String)context)) {
            signupOrganisation = signupService.getSignupOrganisation(context);
            request.setAttribute("signupOrganisation", (Object)signupOrganisation);
        }
        if (signupForm.get("submitted") == null || !((Boolean)signupForm.get("submitted")).booleanValue()) {
            if (signupOrganisation == null) {
                request.setAttribute("messageKey", (Object)"no.such.signup.page.exist");
                return mapping.findForward("message");
            }
            return mapping.findForward("signup");
        }
        if (StringUtils.equals((String)method, (String)"register")) {
            return this.signUp(mapping, form, request, response);
        }
        return this.signIn(mapping, form, request, response);
    }

    private ActionForward signUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            DynaActionForm signupForm = (DynaActionForm)form;
            ActionMessages errors = this.validateSignup(signupForm);
            if (!errors.isEmpty()) {
                this.saveErrors(request, errors);
                return mapping.findForward("signup");
            }
            boolean emailVerify = false;
            String context = WebUtil.readStrParam((HttpServletRequest)request, (String)"context", (boolean)true);
            if (StringUtils.isNotBlank((String)context)) {
                SignupOrganisation signupOrganisation = signupService.getSignupOrganisation(context);
                emailVerify = signupOrganisation.getEmailVerify();
            }
            User user = new User();
            user.setLogin(signupForm.getString("username"));
            user.setFirstName(signupForm.getString("firstName"));
            user.setLastName(signupForm.getString("lastName"));
            user.setEmail(signupForm.getString("email"));
            user.setCountry(signupForm.getString("country"));
            user.setTimeZone(timezoneService.getServerTimezone().getTimezoneId());
            String salt = HashUtil.salt();
            user.setSalt(salt);
            user.setPassword(HashUtil.sha256((String)signupForm.getString("password"), (String)salt));
            if (emailVerify) {
                user.setEmailVerified(Boolean.valueOf(false));
                user.setDisabledFlag(Boolean.valueOf(true));
                signupService.signupUser(user, signupForm.getString("context"));
                try {
                    this.sendVerificationEmail(user);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    request.setAttribute("error", (Object)e.getMessage());
                }
                request.setAttribute("email", (Object)user.getEmail());
                return mapping.findForward("emailVerify");
            }
            user.setDisabledFlag(Boolean.valueOf(false));
            signupService.signupUser(user, signupForm.getString("context"));
            try {
                this.sendWelcomeEmail(user);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                request.setAttribute("error", (Object)e.getMessage());
            }
            return mapping.findForward("success");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            request.setAttribute("error", (Object)e.getMessage());
            return mapping.findForward("index");
        }
    }

    private void sendWelcomeEmail(User user) throws AddressException, MessagingException, UnsupportedEncodingException {
        String subject = messageService.getMessage("signup.email.welcome.subject");
        String body = messageService.getMessage("signup.email.welcome.body.1") + "<br /><br />" + messageService.getMessage("signup.email.welcome.body.2", new Object[]{user.getLogin(), Configuration.get((String)ConfigurationKeys.SERVER_URL)}) + "<br />" + messageService.getMessage("signup.email.welcome.body.3") + "<br /><a href=\"" + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "forgotPassword.jsp\">" + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "forgotPassword.jsp</a><br /><br />" + messageService.getMessage("signup.email.welcome.body.4") + "<br />" + messageService.getMessage("signup.email.welcome.body.5");
        boolean isHtmlFormat = true;
        Emailer.sendFromSupportEmail((String)subject, (String)user.getEmail(), (String)body, (boolean)isHtmlFormat);
    }

    private void sendVerificationEmail(User user) throws AddressException, MessagingException, UnsupportedEncodingException {
        String hash = HashUtil.sha256((String)user.getEmail(), (String)user.getSalt());
        StringBuilder stringBuilder = new StringBuilder().append(Configuration.get((String)ConfigurationKeys.SERVER_URL)).append("signup/signup.do?method=emailVerify&login=").append(URLEncoder.encode(user.getLogin(), "UTF-8")).append("&hash=").append(hash);
        String link = stringBuilder.toString();
        String subject = messageService.getMessage("signup.email.verify.subject");
        stringBuilder = new StringBuilder(messageService.getMessage("signup.email.verify.body.1")).append("<br /><br />").append(messageService.getMessage("signup.email.verify.body.2")).append("<br /><a href=\"").append(link).append("\">").append(link).append("</a><br /><br />").append(messageService.getMessage("signup.email.verify.body.3")).append("<br />").append(messageService.getMessage("signup.email.verify.body.4"));
        String body = stringBuilder.toString();
        boolean isHtmlFormat = true;
        Emailer.sendFromSupportEmail((String)subject, (String)user.getEmail(), (String)body, (boolean)isHtmlFormat);
    }

    private ActionForward signIn(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            DynaActionForm signupForm = (DynaActionForm)form;
            ActionMessages errors = this.validateSignin(signupForm);
            if (!errors.isEmpty()) {
                this.saveErrors(request, errors);
                return mapping.findForward("signup");
            }
            String login = signupForm.getString("usernameTab2");
            String password = signupForm.getString("passwordTab2");
            String context = signupForm.getString("context");
            signupService.signinUser(login, context);
            HttpSession hses = request.getSession();
            hses.setAttribute("login", (Object)login);
            hses.setAttribute("password", (Object)password);
            response.sendRedirect("/lams/login.jsp?redirectURL=/lams");
            return null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            request.setAttribute("error", (Object)e.getMessage());
            return mapping.findForward("index");
        }
    }

    private ActionMessages validateSignup(DynaActionForm signupForm) {
        String country;
        String userEmail;
        String lastName;
        String firstName;
        String userName;
        ActionMessages errors = new ActionMessages();
        String string = userName = signupForm.get("username") == null ? null : (String)signupForm.get("username");
        if (StringUtils.isBlank((String)userName)) {
            errors.add("username", new ActionMessage("error.username.blank"));
        } else if (!ValidationUtil.isUserNameValid((String)userName)) {
            errors.add("username", new ActionMessage("error.username.invalid.characters"));
            log.info((Object)("username has invalid characters: " + userName));
        } else if (signupService.usernameExists(userName)) {
            errors.add("username", new ActionMessage("error.username.exists"));
        }
        String string2 = firstName = signupForm.get("firstName") == null ? null : (String)signupForm.get("firstName");
        if (StringUtils.isBlank((String)firstName)) {
            errors.add("firstName", new ActionMessage("error.first.name.blank"));
        } else if (!ValidationUtil.isFirstLastNameValid((String)firstName)) {
            errors.add("firstName", new ActionMessage("error.firstname.invalid.characters"));
            log.info((Object)("firstname has invalid characters: " + firstName));
        }
        String string3 = lastName = signupForm.get("lastName") == null ? null : (String)signupForm.get("lastName");
        if (StringUtils.isBlank((String)lastName)) {
            errors.add("lastName", new ActionMessage("error.last.name.blank"));
        } else if (!ValidationUtil.isFirstLastNameValid((String)lastName)) {
            errors.add("lastName", new ActionMessage("error.lastname.invalid.characters"));
            log.info((Object)("lastName has invalid characters: " + lastName));
        }
        if (StringUtils.isBlank((String)signupForm.getString("password"))) {
            errors.add("password", new ActionMessage("error.password.blank"));
        } else if (!StringUtils.equals((String)signupForm.getString("password"), (String)signupForm.getString("confirmPassword"))) {
            errors.add("password", new ActionMessage("error.passwords.unequal"));
        } else if (!ValidationUtil.isPasswordValueValid((String)signupForm.getString("password"), (String)signupForm.getString("confirmPassword"))) {
            errors.add("password", new ActionMessage("label.password.restrictions"));
        }
        String string4 = userEmail = signupForm.get("email") == null ? null : (String)signupForm.get("email");
        if (StringUtils.isBlank((String)userEmail)) {
            errors.add("email", new ActionMessage("error.email.blank"));
        } else if (!ValidationUtil.isEmailValid((String)userEmail)) {
            errors.add("email", new ActionMessage("error.email.invalid.format"));
        } else if (!StringUtils.equals((String)userEmail, (String)signupForm.getString("confirmEmail"))) {
            errors.add("email", new ActionMessage("error.emails.unequal"));
        }
        String string5 = country = signupForm.get("country") == null ? null : (String)signupForm.get("country");
        if (StringUtils.isBlank((String)country) || "0".equals(country)) {
            errors.add("email", new ActionMessage("error.country.required"));
        }
        if (!signupService.courseKeyIsValid(signupForm.getString("context"), signupForm.getString("courseKey"))) {
            errors.add("courseKey", new ActionMessage("error.course.key.invalid"));
        }
        return errors;
    }

    private ActionMessages validateSignin(DynaActionForm signupForm) {
        ActionMessages errors = new ActionMessages();
        if (StringUtils.isBlank((String)signupForm.getString("usernameTab2"))) {
            errors.add("usernameTab2", new ActionMessage("error.username.blank"));
        }
        if (StringUtils.isBlank((String)signupForm.getString("passwordTab2"))) {
            errors.add("passwordTab2", new ActionMessage("error.password.blank"));
        }
        if (!signupService.courseKeyIsValid(signupForm.getString("context"), signupForm.getString("courseKeyTab2"))) {
            errors.add("courseKeyTab2", new ActionMessage("error.course.key.invalid"));
        }
        if (errors.isEmpty()) {
            String login = signupForm.getString("usernameTab2");
            String password = signupForm.getString("passwordTab2");
            User user = signupService.getUserByLogin(login);
            if (user == null) {
                errors.add("usernameTab2", new ActionMessage("error.login.or.password.incorrect", (Object)"<a onclick='selectSignupTab();' id='selectLoginTabA'>", (Object)"</a>"));
            } else {
                String passwordHash;
                String string = passwordHash = user.getPassword().length() == 40 ? HashUtil.sha1((String)password) : HashUtil.sha256((String)password, (String)user.getSalt());
                if (!user.getPassword().equals(passwordHash)) {
                    errors.add("usernameTab2", new ActionMessage("error.login.or.password.incorrect", (Object)"<a onclick='selectSignupTab();' id='selectLoginTabA'>", (Object)"</a>"));
                }
            }
        }
        return errors;
    }

    public ActionForward emailVerify(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String hash;
        String login = WebUtil.readStrParam((HttpServletRequest)request, (String)"login", (boolean)false);
        boolean verified = signupService.emailVerify(login, hash = WebUtil.readStrParam((HttpServletRequest)request, (String)"hash", (boolean)false));
        if (verified) {
            request.setAttribute("emailVerified", (Object)verified);
            User user = signupService.getUserByLogin(login);
            try {
                this.sendWelcomeEmail(user);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                request.setAttribute("error", (Object)e.getMessage());
            }
        }
        return mapping.findForward("emailVerifyResult");
    }
}

