/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.planner;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SunUnsafeReflectionProvider;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.contentrepository.exception.RepositoryCheckedException;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.planner.PedagogicalPlannerActivityMetadata;
import org.lamsfoundation.lams.planner.PedagogicalPlannerSequenceNode;
import org.lamsfoundation.lams.planner.dao.PedagogicalPlannerDAO;
import org.lamsfoundation.lams.planner.dto.PedagogicalPlannerActivityDTO;
import org.lamsfoundation.lams.planner.dto.PedagogicalPlannerSequenceNodeDTO;
import org.lamsfoundation.lams.planner.dto.PedagogicalPlannerTemplateDTO;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.planner.PedagogicalPlannerGroupingForm;
import org.lamsfoundation.lams.web.planner.PedagogicalPlannerSequenceNodeForm;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PedagogicalPlannerAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(PedagogicalPlannerAction.class);
    private static IUserManagementService userManagementService;
    private static IExportToolContentService exportService;
    private static IAuthoringService authoringService;
    private static IMonitoringService monitoringService;
    private static MessageService messageService;
    private static PedagogicalPlannerDAO pedagogicalPlannerDAO;
    private static IActivityDAO activityDAO;
    private static final RAMDirectory luceneDir;
    private static final Analyzer luceneAnalyzer;
    private static final String FILE_EXTENSION_ZIP = ".zip";
    private static final String FILE_EXTENSION_LAS = ".las";
    private static final String FORWARD_TEMPLATE = "template";
    private static final String FORWARD_PREVIEW = "preview";
    private static final String FORWARD_SEQUENCE_CHOOSER = "sequenceChooser";
    public static final String FORWARD_GROUPING = "grouping";
    private static final String ACTIVITY_METADATA_PREFIX = "activity";
    private static final String ACTIVITY_METADATA_HIDDEN = "Hidden";
    private static final String ACTIVITY_METADATA_EXPANDED = "Expanded";
    private static final String ACTIVITY_METADATA_COLLAPSED = "Collapsed";
    private static final String ACTIVITY_METADATA_EDITING_ADVICE = "EditingAdvice";
    private static final String ERROR_KEY_TOOL_ERRORS = "error.planner.tools.";
    private static final String ERROR_KEY_NODE_TITLE_BLANK = "error.planner.node.title.blank";
    private static final String ERROR_KEY_FILE_BAD_EXTENSION = "error.planner.file.bad.extension";
    private static final String ERROR_KEY_FILE_EMPTY = "error.planner.file.empty";
    private static final String ERROR_KEY_FILE_OPEN = "error.planner.file.open";
    private static final String ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED = "error.planner.learning.design.retrieve";
    private static final String ERROR_KEY_EXPORT = "error.planner.export";
    private static final String ERROR_KEY_IMPORT = "error.planner.import";
    private static final String ERROR_KEY_FILTER_PARSE = "error.planner.filter.parse";
    private static final String ERROR_KEY_EXPORT_TEMPLATE = "error.planner.export.template";
    private static final String ERROR_KEY_REMOVE_NODE_TREE = "error.planner.remove.node.tree";
    private static final String ERROR_USER_NOT_FOUND = "User not found.";
    private static final String ERROR_NOT_PROPER_FILE = "The sequence template does not exist or is not a proper file.";
    private static final String ERROR_TOO_MANY_OPTIONS = "Number of options in options activity is limited to 4 in Pedagogical Planner.";
    private static final String ERROR_NESTED_OPTIONS = "Nested optional activities are not allowed in Pedagogical Planner.";
    private static final String ERROR_NESTED_BRANCHING = "Nested branching activities are not allowed in Pedagogical Planner.";
    private static final String ERROR_NESTED_PARALLEL = "Nested parallel activities are not allowed in Pedagogical Planner.";
    private static final String ERROR_TOO_MANY_BRANCHES = "Number of branches in branching activity is limited to 4 in Pedagogical Planner.";
    private static final String ERROR_TOO_MANY_PARALLEL_ACTIVITIES = "Number of parallel activities is limited to 4 in Pedagogical Planner.";
    private static final String IMAGE_PATH_GATE = "images/stop.gif";
    private static final String PATH_ACTIVITY_NO_PLANNER_SUPPORT = "/pedagogical_planner/defaultActivityForm.jsp";
    private static final String IMAGE_PATH_GROUPING = "images/grouping.gif";
    private static final String NODE_FILE_NAME = "node.xml";
    private static final String DIR_CONTENT = "content";
    private static final String DIR_TEMPLATES = "template";
    private static final String EXPORT_NODE_FOLDER_SUFFIX = "export_node";
    private static final String EXPORT_NODE_CONTENT_ZIP_PREFIX = "content_";
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final String DIR_UPLOADED_NODE_SUFFIX = "_uploaded_node";
    private static final String EXPORT_NODE_ZIP_PREFIX = "lams_planner_node_";
    private static final String PLANNER_FOLDER_NAME = "Preview Planner";
    private static final String FIELD_NAME_TITLE = "title";
    private static final String FIELD_NAME_BRIEF_DESCRIPTION = "briefDescription";
    private static final String FIELD_NAME_FULL_DESCRIPTION = "fullDescription";
    private static final String FIELD_NAME_ANCESTOR_UID = "ancestorUid";
    public static final String PARAM_REQUEST_SRC = "requestSrc";
    public static final String PARAM_FORBID_BUTTONS = "forbidButtons";
    public static final String PARAM_RETURN_TO_PARENT = "returnToParent";
    public static final String COPY_MODE_EDIT_CURRENT = "editCurrent";
    public static final String COPY_MODE_MOVE_CURRRENT = "moveCurrent";
    public static final String COPY_MODE_MAKE_COPY = "makeCopy";

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String notifyCloseURL;
        String requestSrc = request.getParameter(PARAM_REQUEST_SRC);
        if (StringUtils.isNotBlank((String)requestSrc)) {
            request.getSession().setAttribute(PARAM_REQUEST_SRC, (Object)requestSrc);
        }
        if (StringUtils.isNotBlank((String)(notifyCloseURL = request.getParameter("notifyCloseURL")))) {
            request.getSession().setAttribute("notifyCloseURL", (Object)notifyCloseURL);
        }
        return this.openSequenceNode(mapping, form, request, response);
    }

    public ActionForward openExistingTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String notifyCloseURL;
        ActionMessages errors = new ActionMessages();
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        LearningDesign learningDesign = null;
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId", (boolean)true);
        boolean isEditor = true;
        PedagogicalPlannerSequenceNode node = null;
        if (learningDesignId == null && nodeUid != null) {
            isEditor = this.canEditNode(request, nodeUid);
            node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
            learningDesignId = node.getLearningDesignId();
        }
        if (learningDesignId != null) {
            String copyMode = WebUtil.readStrParam((HttpServletRequest)request, (String)"copyMode", (boolean)true);
            if (StringUtils.isBlank((String)copyMode) || COPY_MODE_EDIT_CURRENT.equalsIgnoreCase(copyMode)) {
                if (!isEditor || node != null && node.getPermissions() != null && (node.getPermissions() & 2) == 0) {
                    log.debug((Object)"Unauthorised attempt to openExistingTemplate (original)");
                    throw new UserAccessDeniedException();
                }
                learningDesign = this.getAuthoringService().getLearningDesign(learningDesignId);
                copyMode = COPY_MODE_EDIT_CURRENT;
            } else if (COPY_MODE_MAKE_COPY.equalsIgnoreCase(copyMode)) {
                if (isEditor ? node != null && node.getPermissions() != null && (node.getPermissions() & 1) == 0 : node != null && node.getPermissions() != null && (node.getPermissions() & 0x20) == 0) {
                    log.debug((Object)"Unauthorised attempt to openExistingTemplate (copy)");
                    throw new UserAccessDeniedException();
                }
                learningDesign = this.copyLearningDesign(learningDesignId, errors);
                copyMode = COPY_MODE_MOVE_CURRRENT;
            }
            request.setAttribute("copyMode", (Object)copyMode);
        }
        if (learningDesign == null) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("no.such.learningdesign.exist", new Object[]{learningDesignId}));
        } else {
            errors = this.openTemplate(request, learningDesign);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return this.openSequenceNode(mapping, form, request, nodeUid);
        }
        String requestSrc = request.getParameter(PARAM_REQUEST_SRC);
        if (StringUtils.isNotBlank((String)requestSrc)) {
            request.getSession().setAttribute(PARAM_REQUEST_SRC, (Object)requestSrc);
        }
        if (StringUtils.isNotBlank((String)(notifyCloseURL = request.getParameter("notifyCloseURL")))) {
            request.getSession().setAttribute("notifyCloseURL", (Object)notifyCloseURL);
        }
        return mapping.findForward("template");
    }

    private ActionMessages openTemplate(HttpServletRequest request, LearningDesign learningDesign) throws ServletException {
        PedagogicalPlannerSequenceNode node;
        ActionMessages errors = new ActionMessages();
        ArrayList<PedagogicalPlannerActivityDTO> activities = new ArrayList<PedagogicalPlannerActivityDTO>();
        Activity activity = learningDesign.getFirstActivity();
        log.debug((Object)"Parsing learning design activities");
        try {
            while (activity != null) {
                this.addActivityToPlanner(learningDesign, activities, activity);
                Transition transitionFrom = activity.getTransitionFrom();
                if (transitionFrom == null) {
                    activity = null;
                    continue;
                }
                activity = transitionFrom.getToActivity();
            }
        }
        catch (ServletException e) {
            log.error((Object)e, (Throwable)e);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
            return errors;
        }
        int activitySupportingPlannerCount = 0;
        for (PedagogicalPlannerActivityDTO activityDTO : activities) {
            if (!activityDTO.getSupportsPlanner().booleanValue()) continue;
            ++activitySupportingPlannerCount;
        }
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        PedagogicalPlannerTemplateDTO planner = new PedagogicalPlannerTemplateDTO();
        planner.setActivitySupportingPlannerCount(Integer.valueOf(activitySupportingPlannerCount));
        planner.setSequenceTitle(learningDesign.getTitle());
        planner.setActivities(activities);
        planner.setLearningDesignID(learningDesign.getLearningDesignId());
        if (nodeUid != null && (node = this.getPedagogicalPlannerDAO().getByUid(nodeUid)) != null) {
            boolean isEditor = this.canEditNode(request, nodeUid);
            Integer nodePermissions = node.getPermissions();
            planner.setPermissions(nodePermissions, isEditor);
            boolean returnToParent = WebUtil.readBooleanParam((HttpServletRequest)request, (String)PARAM_RETURN_TO_PARENT, (boolean)false);
            if (returnToParent) {
                if (node.getParent() != null) {
                    planner.setNodeUid(node.getParent().getUid());
                }
            } else {
                planner.setNodeUid(node.getUid());
            }
        }
        String forbidButtonsString = request.getParameter(PARAM_FORBID_BUTTONS);
        planner.overridePermissions(forbidButtonsString);
        planner.setSendInPortions(Boolean.valueOf(false));
        planner.setSubmitDelay(Integer.valueOf(5000));
        planner.setActivitiesPerPortion(Integer.valueOf(2));
        request.setAttribute("planner", (Object)planner);
        return errors;
    }

    private LearningDesign copyLearningDesign(Long originalDesignId, ActionMessages errors) throws ServletException {
        log.debug((Object)"Copying LearningDesign to common folder");
        LearningDesign originalDesign = null;
        if (originalDesignId != null) {
            originalDesign = this.getAuthoringService().getLearningDesign(originalDesignId);
        }
        if (originalDesign == null) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("no.such.learningdesign.exist", new Object[]{originalDesignId}));
            return null;
        }
        User user = this.getUser();
        WorkspaceFolder targetFolder = this.getCommonWorkspaceFolderId(user.getUserId());
        Integer copyType = 1;
        boolean setOriginalDesign = false;
        String newDesignName = originalDesign.getTitle();
        String customCSV = null;
        return this.getAuthoringService().copyLearningDesign(originalDesign, copyType, user, targetFolder, setOriginalDesign, newDesignName, customCSV);
    }

    private PedagogicalPlannerActivityDTO addActivityToPlanner(LearningDesign learningDesign, List<PedagogicalPlannerActivityDTO> activities, Activity activity) throws ServletException {
        log.debug((Object)("Parsing activity: " + activity.getTitle()));
        boolean isNested = activity.getParentActivity() != null && (activity.getParentActivity().isBranchingActivity() || activity.isOptionsActivity());
        PedagogicalPlannerActivityDTO addedDTO = null;
        activity = this.getActivityDAO().getActivityByActivityId(activity.getActivityId());
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            Long toolContentID = toolActivity.getToolContentId();
            String pedagogicalPlannerUrl = toolActivity.getTool().getPedagogicalPlannerUrl();
            String authorUrl = WebUtil.appendParameterToURL((String)toolActivity.getTool().getAuthorUrl(), (String)"toolContentID", (String)toolContentID.toString());
            authorUrl = WebUtil.appendParameterToURL((String)authorUrl, (String)"contentFolderID", (String)learningDesign.getContentFolderID());
            if (pedagogicalPlannerUrl == null) {
                addedDTO = new PedagogicalPlannerActivityDTO(Boolean.valueOf(false), PATH_ACTIVITY_NO_PLANNER_SUPPORT);
                addedDTO.setType(toolActivity.getTool().getToolDisplayName());
                addedDTO.setTitle(activity.getTitle());
                addedDTO.setAuthorUrl(authorUrl);
                addedDTO.setToolIconUrl(activity.getLibraryActivityUiImage());
                PedagogicalPlannerActivityMetadata plannerMetadata = toolActivity.getPlannerMetadata();
                if (plannerMetadata != null) {
                    addedDTO.setCollapsed(plannerMetadata.getCollapsed());
                    addedDTO.setExpanded(plannerMetadata.getExpanded());
                    addedDTO.setHidden(plannerMetadata.getHidden());
                }
            } else {
                pedagogicalPlannerUrl = WebUtil.appendParameterToURL((String)pedagogicalPlannerUrl, (String)"toolContentID", (String)toolContentID.toString());
                pedagogicalPlannerUrl = WebUtil.appendParameterToURL((String)pedagogicalPlannerUrl, (String)"contentFolderID", (String)learningDesign.getContentFolderID());
                addedDTO = new PedagogicalPlannerActivityDTO(Boolean.valueOf(true), pedagogicalPlannerUrl);
                addedDTO.setType(toolActivity.getTool().getToolDisplayName());
                addedDTO.setTitle(activity.getTitle());
                addedDTO.setAuthorUrl(authorUrl);
                addedDTO.setToolIconUrl(activity.getLibraryActivityUiImage());
                PedagogicalPlannerActivityMetadata plannerMetadata = toolActivity.getPlannerMetadata();
                if (plannerMetadata != null) {
                    addedDTO.setCollapsed(plannerMetadata.getCollapsed());
                    addedDTO.setExpanded(plannerMetadata.getExpanded());
                    addedDTO.setHidden(plannerMetadata.getHidden());
                    addedDTO.setEditingAdvice(plannerMetadata.getEditingAdvice());
                }
            }
            activities.add(addedDTO);
        } else if (activity.isGroupingActivity()) {
            GroupingActivity groupingActivity = (GroupingActivity)activity;
            String pedagogicalPlannerUrl = WebUtil.appendParameterToURL((String)groupingActivity.getSystemTool().getPedagogicalPlannerUrl(), (String)"toolContentID", (String)groupingActivity.getCreateGrouping().getGroupingId().toString());
            addedDTO = new PedagogicalPlannerActivityDTO(Boolean.valueOf(true), pedagogicalPlannerUrl);
            addedDTO.setTitle(activity.getTitle());
            addedDTO.setToolIconUrl(IMAGE_PATH_GROUPING);
            activities.add(addedDTO);
        } else if (activity.isGateActivity()) {
            addedDTO = new PedagogicalPlannerActivityDTO(Boolean.valueOf(false), PATH_ACTIVITY_NO_PLANNER_SUPPORT);
            addedDTO.setTitle(activity.getTitle());
            addedDTO.setToolIconUrl(IMAGE_PATH_GATE);
            activities.add(addedDTO);
        } else if (activity.isBranchingActivity()) {
            if (isNested) {
                throw new ServletException(ERROR_NESTED_BRANCHING);
            }
            BranchingActivity branchingActivity = (BranchingActivity)activity;
            SequenceActivity defaultSequence = (SequenceActivity)branchingActivity.getDefaultActivity();
            Set sequenceActivities = branchingActivity.getActivities();
            short branch = 1;
            for (SequenceActivity sequenceActivity : sequenceActivities) {
                if (branch > 4) {
                    throw new ServletException(ERROR_TOO_MANY_BRANCHES);
                }
                Object nestedActivity = sequenceActivity.getDefaultActivity();
                boolean defaultBranch = sequenceActivity.equals((Object)defaultSequence);
                if (nestedActivity == null) {
                    String path = WebUtil.appendParameterToURL((String)PATH_ACTIVITY_NO_PLANNER_SUPPORT, (String)"formMessage", (String)this.getMessageService().getMessage("label.planner.branch.empty"));
                    addedDTO = new PedagogicalPlannerActivityDTO(Boolean.valueOf(false), path);
                    addedDTO.setParentActivityTitle(activity.getTitle());
                    addedDTO.setGroup(Short.valueOf(branch));
                    addedDTO.setDefaultBranch(Boolean.valueOf(defaultBranch));
                    addedDTO.setComplexActivityType(Short.valueOf((short)1));
                    activities.add(addedDTO);
                } else {
                    do {
                        addedDTO = this.addActivityToPlanner(learningDesign, activities, (Activity)nestedActivity);
                        Transition transitionFrom = nestedActivity.getTransitionFrom();
                        nestedActivity = transitionFrom == null ? null : transitionFrom.getToActivity();
                        addedDTO.setParentActivityTitle(activity.getTitle());
                        addedDTO.setGroup(Short.valueOf(branch));
                        addedDTO.setDefaultBranch(Boolean.valueOf(defaultBranch));
                        addedDTO.setComplexActivityType(Short.valueOf((short)1));
                    } while (nestedActivity != null);
                }
                branch = (short)(branch + 1);
            }
            addedDTO.setLastNestedActivity(Boolean.valueOf(true));
        } else if (activity.isOptionsActivity()) {
            if (isNested) {
                throw new ServletException(ERROR_NESTED_OPTIONS);
            }
            OptionsActivity optionsActivity = (OptionsActivity)activity;
            Set nestedActivities = optionsActivity.getActivities();
            short option = 1;
            for (Object nestedActivity : nestedActivities) {
                if (option > 4) {
                    throw new ServletException(ERROR_TOO_MANY_OPTIONS);
                }
                if (nestedActivity.isSequenceActivity()) {
                    nestedActivity = ((SequenceActivity)nestedActivity).getDefaultActivity();
                    do {
                        addedDTO = this.addActivityToPlanner(learningDesign, activities, (Activity)nestedActivity);
                        Transition transitionTo = nestedActivity.getTransitionTo();
                        nestedActivity = transitionTo == null ? null : transitionTo.getToActivity();
                        addedDTO.setParentActivityTitle(activity.getTitle());
                        addedDTO.setGroup(Short.valueOf(option));
                        addedDTO.setComplexActivityType(Short.valueOf((short)2));
                    } while (nestedActivity != null);
                } else {
                    addedDTO = this.addActivityToPlanner(learningDesign, activities, (Activity)nestedActivity);
                    addedDTO.setParentActivityTitle(activity.getTitle());
                    addedDTO.setGroup(Short.valueOf(option));
                    addedDTO.setComplexActivityType(Short.valueOf((short)2));
                }
                option = (short)(option + 1);
            }
            addedDTO.setLastNestedActivity(Boolean.valueOf(true));
        } else if (activity.isParallelActivity()) {
            if (isNested) {
                throw new ServletException(ERROR_NESTED_PARALLEL);
            }
            ParallelActivity parallelActivity = (ParallelActivity)activity;
            Set nestedActivities = parallelActivity.getActivities();
            short option = 1;
            for (Activity nestedActivity : nestedActivities) {
                if (option > 4) {
                    throw new ServletException(ERROR_TOO_MANY_PARALLEL_ACTIVITIES);
                }
                addedDTO = this.addActivityToPlanner(learningDesign, activities, nestedActivity);
                addedDTO.setParentActivityTitle(activity.getTitle());
                addedDTO.setGroup(Short.valueOf(option));
                addedDTO.setComplexActivityType(Short.valueOf((short)3));
                option = (short)(option + 1);
            }
            addedDTO.setLastNestedActivity(Boolean.valueOf(true));
        } else {
            addedDTO = new PedagogicalPlannerActivityDTO(Boolean.valueOf(false), PATH_ACTIVITY_NO_PLANNER_SUPPORT);
            addedDTO.setTitle(activity.getTitle());
            addedDTO.setToolIconUrl(activity.getLibraryActivityUiImage());
            activities.add(addedDTO);
        }
        return addedDTO;
    }

    public ActionForward startPreview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId", (boolean)true);
        if (learningDesignId == null && nodeUid != null) {
            PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
            learningDesignId = node.getLearningDesignId();
        }
        HttpSession session = SessionManager.getSession();
        UserDTO userDto = (UserDTO)session.getAttribute("user");
        log.debug((Object)("Opening preview for learnind design id: " + learningDesignId));
        Lesson lesson = this.getMonitoringService().initializeLessonForPreview("Preview", null, learningDesignId.longValue(), userDto.getUserID(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        this.getMonitoringService().createPreviewClassForLesson(userDto.getUserID().intValue(), lesson.getLessonId().longValue());
        this.getMonitoringService().startLesson(lesson.getLessonId().longValue(), userDto.getUserID());
        String newPath = WebUtil.appendParameterToURL((String)mapping.findForward(FORWARD_PREVIEW).getPath(), (String)"lessonID", (String)lesson.getLessonId().toString());
        newPath = WebUtil.appendParameterToURL((String)newPath, (String)"mode", (String)FORWARD_PREVIEW);
        return new ActionForward(newPath, true);
    }

    public ActionForward openSequenceNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        return this.openSequenceNode(mapping, form, request, nodeUid);
    }

    public ActionForward openSequenceNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, Long nodeUid) throws ServletException {
        String filterText = WebUtil.readStrParam((HttpServletRequest)request, (String)"filterText", (boolean)true);
        PedagogicalPlannerSequenceNode node = null;
        node = nodeUid == null ? this.getPedagogicalPlannerDAO().getRootNode() : this.getPedagogicalPlannerDAO().getByUid(nodeUid);
        log.debug((Object)("Opening sequence node with UID: " + nodeUid));
        boolean isSysAdmin = request.isUserInRole("SYSADMIN");
        boolean canEdit = this.canEditNode(request, nodeUid);
        Boolean edit = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"edit", (boolean)false);
        edit = edit & canEdit;
        PedagogicalPlannerSequenceNodeDTO dto = null;
        if (filterText != null) {
            try {
                Set<Long> filteredNodeUids = this.filterSubnodes(node, filterText);
                if (filteredNodeUids != null) {
                    request.setAttribute("filterText", (Object)filterText);
                    LinkedHashSet<PedagogicalPlannerSequenceNode> filteredNodes = new LinkedHashSet<PedagogicalPlannerSequenceNode>(filteredNodeUids.size());
                    for (Long filteredUid : filteredNodeUids) {
                        PedagogicalPlannerSequenceNode subnode = this.getPedagogicalPlannerDAO().getByUid(filteredUid);
                        filteredNodes.add(subnode);
                    }
                    dto = new PedagogicalPlannerSequenceNodeDTO(node, filteredNodes, isSysAdmin, this.getPedagogicalPlannerDAO());
                    for (PedagogicalPlannerSequenceNodeDTO subnodeDTO : dto.getSubnodes()) {
                        List titlePath = this.getPedagogicalPlannerDAO().getTitlePath(subnodeDTO.getUid());
                        subnodeDTO.setTitlePath(titlePath);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                ActionMessages errors = new ActionMessages();
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILTER_PARSE));
                this.saveErrors(request, errors);
            }
        }
        if (dto == null) {
            dto = new PedagogicalPlannerSequenceNodeDTO(node, node.getSubnodes(), isSysAdmin, this.getPedagogicalPlannerDAO());
            if (nodeUid == null) {
                dto.setRecentlyModifiedNodes(this.getRecentlyModifiedLearnindDesignsAsNodes());
            }
        }
        List titlePath = this.getPedagogicalPlannerDAO().getTitlePath(nodeUid);
        Boolean createSubnode = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"createSubnode", (boolean)false);
        Boolean importNode = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"importNode", (boolean)false);
        dto.setCreateSubnode(createSubnode);
        dto.setEdit(edit);
        dto.setIsEditor(Boolean.valueOf(canEdit));
        dto.setImportNode(importNode);
        dto.setTitlePath(titlePath);
        request.setAttribute("node", (Object)dto);
        if (edit.booleanValue()) {
            PedagogicalPlannerSequenceNodeForm nodeForm = (PedagogicalPlannerSequenceNodeForm)form;
            if (createSubnode.booleanValue()) {
                if (node.getContentFolderId() == null) {
                    String contentFolderId = FileUtil.generateUniqueContentFolderID();
                    nodeForm.setContentFolderId(contentFolderId);
                } else {
                    nodeForm.setContentFolderId(node.getContentFolderId());
                }
                nodeForm.setPermissions(null);
            } else if (!importNode.booleanValue()) {
                nodeForm.setNodeType(node.getLearningDesignId() == null ? "subnodes" : "template");
                nodeForm.setRemoveTemplate(false);
                nodeForm.setTitle(dto.getTitle());
                nodeForm.setBriefDescription(dto.getBriefDescription());
                nodeForm.setFullDescription(dto.getFullDescription());
                nodeForm.setPermissions(node.getPermissions());
            }
        }
        return mapping.findForward(FORWARD_SEQUENCE_CHOOSER);
    }

    public ActionForward saveSequenceNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        PedagogicalPlannerSequenceNode node = null;
        PedagogicalPlannerSequenceNodeForm nodeForm = (PedagogicalPlannerSequenceNodeForm)form;
        boolean newRootNode = false;
        Long parentUid = null;
        if (nodeUid == null) {
            node = new PedagogicalPlannerSequenceNode();
            Long l = parentUid = nodeForm.getParentUid() == 0L ? null : nodeForm.getParentUid();
            if (parentUid != null) {
                PedagogicalPlannerSequenceNode parent = this.getPedagogicalPlannerDAO().getByUid(parentUid);
                node.setParent(parent);
            } else {
                newRootNode = true;
            }
            node.setOrder(this.getPedagogicalPlannerDAO().getNextOrderId(parentUid));
            node.setUser(this.getUser());
        } else {
            node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
            nodeUid = node.getUid();
        }
        if (nodeUid == null ? (parentUid == null ? !this.canEditNode(request, nodeUid) : !this.canEditNode(request, parentUid)) : !this.canEditNode(request, nodeUid)) {
            log.debug((Object)"Unauthorised attempt to saveSequenceNode");
            throw new UserAccessDeniedException();
        }
        log.debug((Object)("Saving sequence node with UID: " + nodeUid));
        String title = nodeForm.getTitle();
        String briefDescription = nodeForm.getBriefDescription();
        String fullDescription = nodeForm.getFullDescription();
        String nodeType = nodeForm.getNodeType();
        int nodePermissions = nodeForm.getPermissions();
        ActionMessages errors = this.validateNodeForm(node, nodeForm);
        if (errors.isEmpty()) {
            node.setTitle(title);
            node.setBriefDescription(briefDescription);
            node.setFullDescription(fullDescription);
            node.setContentFolderId(nodeForm.getContentFolderId());
            node.setPermissions(Integer.valueOf(nodePermissions));
            if ("subnodes".equals(nodeForm.getNodeType()) || Boolean.TRUE.equals(nodeForm.getRemoveTemplate())) {
                node.setLearningDesignId(null);
                node.setLearningDesignTitle(null);
                node.setPermissions(Integer.valueOf(1011));
            } else if (nodeForm.getFile() != null && nodeForm.getFile().getFileSize() > 0) {
                FormFile file = nodeForm.getFile();
                InputStream inputStream = file.getInputStream();
                File sourceFile = new File(FileUtil.getTempDir(), file.getFileName());
                try {
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)sourceFile);
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILE_OPEN));
                }
                if (!sourceFile.exists() || sourceFile.isDirectory()) {
                    log.error((Object)ERROR_NOT_PROPER_FILE);
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILE_OPEN));
                }
                if (errors.isEmpty()) {
                    LearningDesign learningDesign = this.importLearningDesign(sourceFile, errors);
                    if (errors.isEmpty()) {
                        this.updateRecentLearningDesignList(learningDesign.getLearningDesignId());
                        node.setLearningDesignId(learningDesign.getLearningDesignId());
                        node.setLearningDesignTitle(learningDesign.getTitle());
                        Iterator subnodeIter = node.getSubnodes().iterator();
                        while (subnodeIter.hasNext()) {
                            PedagogicalPlannerSequenceNode subnode = (PedagogicalPlannerSequenceNode)subnodeIter.next();
                            subnodeIter.remove();
                            this.getPedagogicalPlannerDAO().removeNode(subnode);
                        }
                    }
                }
            }
            this.getPedagogicalPlannerDAO().saveOrUpdateNode(node);
            nodeUid = node.getUid();
            if (newRootNode) {
                try {
                    HttpSession s = SessionManager.getSession();
                    UserDTO u = (UserDTO)s.getAttribute("user");
                    this.getPedagogicalPlannerDAO().saveNodeRole(u.getUserID(), nodeUid, Role.ROLE_SYSADMIN);
                }
                catch (Exception e) {
                    log.error((Object)("Error saving role for newly created root node: " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        boolean createSubnode = false;
        if (nodeUid == null) {
            nodeUid = node.getParent() == null ? null : node.getParent().getUid();
            createSubnode = true;
        }
        this.openSequenceNode(mapping, form, request, nodeUid);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            nodeForm.setTitle(title);
            nodeForm.setBriefDescription(briefDescription);
            nodeForm.setFullDescription(fullDescription);
            nodeForm.setNodeType(nodeType);
            nodeForm.setPermissions(nodePermissions);
            if (createSubnode) {
                PedagogicalPlannerSequenceNodeDTO dto = (PedagogicalPlannerSequenceNodeDTO)request.getAttribute("node");
                dto.setCreateSubnode(Boolean.valueOf(true));
            }
        }
        return mapping.findForward(FORWARD_SEQUENCE_CHOOSER);
    }

    private ActionMessages validateNodeForm(PedagogicalPlannerSequenceNode node, PedagogicalPlannerSequenceNodeForm form) {
        ActionMessages errors = new ActionMessages();
        if (StringUtils.isEmpty((String)form.getTitle())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_NODE_TITLE_BLANK));
        }
        if ("template".equals(form.getNodeType()) && node.getLearningDesignTitle() == null) {
            errors.add(this.validateFormFile(form));
        }
        return errors;
    }

    private ActionMessages validateFormFile(PedagogicalPlannerSequenceNodeForm form) {
        ActionMessages errors = new ActionMessages();
        if (form.getFile() == null || form.getFile().getFileSize() == 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILE_EMPTY));
        } else {
            String fileName = form.getFile().getFileName();
            boolean badExtension = false;
            if (fileName.length() >= 4) {
                String extension = fileName.substring(fileName.length() - 4);
                if (!extension.equalsIgnoreCase(FILE_EXTENSION_LAS) && !extension.equalsIgnoreCase(FILE_EXTENSION_ZIP)) {
                    badExtension = true;
                }
            } else {
                badExtension = true;
            }
            if (badExtension) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILE_BAD_EXTENSION));
            }
        }
        return errors;
    }

    public ActionForward removeSequenceNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, UserAccessDeniedException {
        Long parentUid;
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid");
        PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
        Long l = parentUid = node.getParent() == null ? null : node.getParent().getUid();
        if (this.canRemoveSubtree(request, nodeUid)) {
            log.debug((Object)("Removing sequence node with UID" + nodeUid));
            this.getPedagogicalPlannerDAO().removeNode(node);
        } else {
            ActionMessages errors = new ActionMessages();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_REMOVE_NODE_TREE));
            this.saveErrors(request, errors);
            log.debug((Object)"Unauthorised attempt to removeSequenceNode");
        }
        return this.openSequenceNode(mapping, form, request, parentUid);
    }

    public ActionForward moveNodeUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return this.moveNode(mapping, form, request, -1);
    }

    public ActionForward moveNodeDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return this.moveNode(mapping, form, request, 1);
    }

    private ActionForward moveNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, Integer orderDelta) throws IOException, ServletException {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid");
        PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
        Long parentUid = node.getParent() == null ? null : node.getParent().getUid();
        PedagogicalPlannerSequenceNode neighbourNode = this.getPedagogicalPlannerDAO().getNeighbourNode(node, orderDelta);
        neighbourNode.setOrder(Integer.valueOf(0));
        this.getPedagogicalPlannerDAO().saveOrUpdateNode(neighbourNode);
        node.setOrder(Integer.valueOf(node.getOrder() + orderDelta));
        this.getPedagogicalPlannerDAO().saveOrUpdateNode(node);
        neighbourNode.setOrder(Integer.valueOf(node.getOrder() - orderDelta));
        this.getPedagogicalPlannerDAO().saveOrUpdateNode(neighbourNode);
        return this.openSequenceNode(mapping, form, request, parentUid);
    }

    public ActionForward exportNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid");
        ActionMessages errors = new ActionMessages();
        log.debug((Object)("Exporting sequence node with UID" + nodeUid));
        String zipFilePath = null;
        String filename = null;
        try {
            zipFilePath = this.exportNode(nodeUid);
            String zipfile = FileUtil.getFileName((String)zipFilePath);
            zipfile = zipfile.replaceAll(" ", "_");
            filename = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)zipfile);
            log.debug((Object)("Final filename to export: " + filename));
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_EXPORT));
            this.saveErrors(request, errors);
            return this.openSequenceNode(mapping, form, request, nodeUid);
        }
        FileUtils.copyFile((File)new File(zipFilePath), (OutputStream)response.getOutputStream());
        return null;
    }

    private String exportNode(Long nodeUid) throws ZipFileUtilException, FileUtilException, IOException, RepositoryCheckedException, ExportToolContentException {
        if (nodeUid != null) {
            String rootDir = FileUtil.createTempDirectory((String)EXPORT_NODE_FOLDER_SUFFIX);
            String contentDir = FileUtil.getFullPath((String)rootDir, (String)DIR_CONTENT);
            FileUtil.createDirectory((String)contentDir);
            String nodeFileName = FileUtil.getFullPath((String)contentDir, (String)NODE_FILE_NAME);
            OutputStreamWriter nodeFile = new OutputStreamWriter((OutputStream)new FileOutputStream(nodeFileName), ENCODING_UTF_8);
            PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
            XStream designXml = new XStream((ReflectionProvider)new SunUnsafeReflectionProvider());
            designXml.addPermission(AnyTypePermission.ANY);
            designXml.omitField(PedagogicalPlannerSequenceNode.class, "user");
            designXml.toXML((Object)node, (Writer)nodeFile);
            ((Writer)nodeFile).close();
            log.debug((Object)"Node xml export success");
            File templateDir = new File(contentDir, "template");
            this.exportSubnodeTemplates(node, templateDir);
            String targetZipFileName = EXPORT_NODE_CONTENT_ZIP_PREFIX + node.getContentFolderId() + FILE_EXTENSION_ZIP;
            String secureDir = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure";
            String nodeContentDir = FileUtil.getFullPath((String)secureDir, (String)node.getContentFolderId());
            if (!FileUtil.isEmptyDirectory((String)nodeContentDir, (boolean)true)) {
                log.debug((Object)("Create export node content target zip file. File name is " + targetZipFileName));
                ZipFileUtil.createZipFile((String)targetZipFileName, (String)nodeContentDir, (String)contentDir);
            } else {
                log.debug((Object)("No such directory (or empty directory): " + nodeContentDir));
            }
            targetZipFileName = EXPORT_NODE_ZIP_PREFIX + node.getTitle() + FILE_EXTENSION_ZIP;
            log.debug((Object)("Create export node content zip file. File name is " + targetZipFileName));
            return ZipFileUtil.createZipFile((String)targetZipFileName, (String)contentDir, (String)rootDir);
        }
        return null;
    }

    public ActionForward importNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (!this.canEditNode(request, null)) {
            log.debug((Object)"Unauthorised access to importNode");
            throw new UserAccessDeniedException();
        }
        PedagogicalPlannerSequenceNodeForm nodeForm = (PedagogicalPlannerSequenceNodeForm)form;
        ActionMessages errors = this.validateFormFile(nodeForm);
        if (errors.isEmpty()) {
            try {
                String uploadPath = FileUtil.createTempDirectory((String)DIR_UPLOADED_NODE_SUFFIX);
                String fileName = nodeForm.getFile().getFileName();
                File importFile = new File(uploadPath + fileName);
                log.debug((Object)("Importing a node from file: " + fileName));
                InputStream inputStream = nodeForm.getFile().getInputStream();
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)importFile);
                nodeForm.setFile(null);
                String rootPath = ZipFileUtil.expandZip((InputStream)new FileInputStream(importFile), (String)fileName);
                String nodeFilePath = FileUtil.getFullPath((String)rootPath, (String)NODE_FILE_NAME);
                PedagogicalPlannerSequenceNode node = (PedagogicalPlannerSequenceNode)FileUtil.getObjectFromXML(null, (String)nodeFilePath);
                String contentZipFileName = EXPORT_NODE_CONTENT_ZIP_PREFIX + node.getContentFolderId() + FILE_EXTENSION_ZIP;
                String secureDir = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure" + File.separator + node.getContentFolderId();
                File contentZipFile = new File(FileUtil.getFullPath((String)rootPath, (String)contentZipFileName));
                if (contentZipFile.exists()) {
                    FileInputStream is = new FileInputStream(contentZipFile);
                    ZipFileUtil.expandZipToFolder((InputStream)is, (String)secureDir);
                }
                File templateDir = new File(rootPath, "template");
                this.importSubnodeTemplates(node, templateDir, errors);
                Integer order = this.getPedagogicalPlannerDAO().getNextOrderId(null);
                node.setOrder(order);
                this.getPedagogicalPlannerDAO().saveOrUpdateNode(node);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_IMPORT));
            }
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
        }
        return this.openSequenceNode(mapping, form, request, (Long)null);
    }

    private LearningDesign importLearningDesign(File sourceFile, ActionMessages errors) throws ServletException {
        User user = this.getUser();
        List toolsErrorMsgs = new ArrayList();
        Long learningDesignID = null;
        LearningDesign learningDesign = null;
        List learningDesignErrorMsgs = new ArrayList();
        Integer workspaceFolderId = null;
        try {
            Object[] ldResults = this.getExportService().importLearningDesign(sourceFile, user, workspaceFolderId, toolsErrorMsgs, "");
            sourceFile.delete();
            learningDesignID = (Long)ldResults[0];
            learningDesignErrorMsgs = (List)ldResults[1];
            toolsErrorMsgs = (List)ldResults[2];
            learningDesign = this.getAuthoringService().getLearningDesign(learningDesignID);
        }
        catch (ImportToolContentException e) {
            log.error((Object)e, (Throwable)e);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
        }
        if ((learningDesignID == null || learningDesignID == -1L) && learningDesignErrorMsgs.size() == 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
            return null;
        }
        if (learningDesignErrorMsgs.size() > 0) {
            for (String error : learningDesignErrorMsgs) {
                log.error((Object)error);
            }
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
            return null;
        }
        if (toolsErrorMsgs.size() > 0) {
            for (String error : toolsErrorMsgs) {
                log.error((Object)error);
            }
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_TOOL_ERRORS));
            return null;
        }
        return learningDesign;
    }

    private WorkspaceFolder getCommonWorkspaceFolderId(Integer userID) {
        String name = PLANNER_FOLDER_NAME;
        WorkspaceFolder parentFolder = this.getUserManagementService().getRootOrganisation().getNormalFolder();
        Integer workspaceFolderType = WorkspaceFolder.PUBLIC_SEQUENCES;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", name);
        properties.put("parentWorkspaceFolder.workspaceFolderId", parentFolder.getWorkspaceFolderId());
        properties.put("workspaceFolderType", workspaceFolderType);
        List workspaceFolderList = userManagementService.findByProperties(WorkspaceFolder.class, properties);
        WorkspaceFolder workspaceFolder = null;
        if (workspaceFolderList != null && workspaceFolderList.size() > 0) {
            workspaceFolder = (WorkspaceFolder)workspaceFolderList.get(0);
        } else {
            workspaceFolder = new WorkspaceFolder(name, parentFolder, userID, new Date(), new Date(), WorkspaceFolder.PUBLIC_SEQUENCES);
            userManagementService.save((Object)workspaceFolder);
        }
        return workspaceFolder;
    }

    private User getUser() throws ServletException {
        HttpSession session = SessionManager.getSession();
        UserDTO userDto = (UserDTO)session.getAttribute("user");
        User user = (User)this.getUserManagementService().findById(User.class, (Serializable)userDto.getUserID());
        if (user == null) {
            throw new ServletException(ERROR_USER_NOT_FOUND);
        }
        return user;
    }

    private void exportSubnodeTemplates(PedagogicalPlannerSequenceNode node, File outputDir) throws IOException, RepositoryCheckedException, ExportToolContentException {
        if (node != null) {
            if (node.getLearningDesignId() == null) {
                if (node.getSubnodes() != null) {
                    for (PedagogicalPlannerSequenceNode subnode : node.getSubnodes()) {
                        this.exportSubnodeTemplates(subnode, outputDir);
                    }
                }
            } else {
                ArrayList toolsErrorMsgs = new ArrayList();
                String exportedLdFilePath = this.getExportService().exportLearningDesign(node.getLearningDesignId(), toolsErrorMsgs);
                if (!toolsErrorMsgs.isEmpty()) {
                    StringBuffer errorMessages = new StringBuffer();
                    for (String error : toolsErrorMsgs) {
                        errorMessages.append(error);
                    }
                    throw new ExportToolContentException(errorMessages.toString());
                }
                FileInputStream inputStream = new FileInputStream(exportedLdFilePath);
                File ldIdDir = new File(outputDir, node.getLearningDesignId().toString());
                ldIdDir.mkdirs();
                File targetFile = new File(ldIdDir, node.getLearningDesignTitle() + FILE_EXTENSION_ZIP);
                log.debug((Object)("Preparing for zipping the template file: " + node.getLearningDesignTitle()));
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
            }
        }
    }

    private void importSubnodeTemplates(PedagogicalPlannerSequenceNode node, File inputDir, ActionMessages errors) throws ServletException {
        if (node != null) {
            node.setUid(null);
            User user = this.getUser();
            node.setUser(user);
            if (node.getLearningDesignId() == null) {
                if (node.getSubnodes() != null) {
                    for (PedagogicalPlannerSequenceNode subnode : node.getSubnodes()) {
                        this.importSubnodeTemplates(subnode, inputDir, errors);
                        subnode.setParent(node);
                    }
                }
            } else {
                File ldIdDir = new File(inputDir, node.getLearningDesignId().toString());
                String fileName = node.getLearningDesignTitle() + FILE_EXTENSION_ZIP;
                File sourceFile = new File(ldIdDir, fileName);
                log.debug((Object)("Importing a template file: " + fileName));
                LearningDesign learningDesign = this.importLearningDesign(sourceFile, errors);
                node.setLearningDesignId(learningDesign.getLearningDesignId());
                node.setLearningDesignTitle(learningDesign.getTitle());
            }
        }
    }

    private Set<Long> filterSubnodes(PedagogicalPlannerSequenceNode node, String filterText) throws ParseException, CorruptIndexException, IOException {
        Set<Document> docs;
        LinkedHashSet<Long> matchingSubnodeUids = new LinkedHashSet<Long>();
        if (!StringUtils.isEmpty((String)filterText) && !(docs = this.extractSubnodeDocuments(node)).isEmpty()) {
            MultiFieldQueryParser queryParser = new MultiFieldQueryParser(new String[]{FIELD_NAME_TITLE, FIELD_NAME_FULL_DESCRIPTION, FIELD_NAME_BRIEF_DESCRIPTION}, luceneAnalyzer);
            Query query = queryParser.parse(filterText);
            IndexWriterConfig config = new IndexWriterConfig(luceneAnalyzer.getVersion(), luceneAnalyzer);
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            IndexWriter indexWriter = new IndexWriter((Directory)luceneDir, config);
            for (Document doc : docs) {
                indexWriter.addDocument((Iterable)doc);
            }
            indexWriter.close();
            IndexSearcher searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)luceneDir));
            TopDocs topDocs = searcher.search(query, null, docs.size());
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document doc = searcher.doc(scoreDoc.doc);
                String ancestorUid = doc.get(FIELD_NAME_ANCESTOR_UID);
                Long uid = new Long(ancestorUid);
                matchingSubnodeUids.add(uid);
            }
        }
        return matchingSubnodeUids;
    }

    private Set<Document> extractSubnodeDocuments(PedagogicalPlannerSequenceNode node) {
        HashSet<Document> docs = new HashSet<Document>();
        if (node != null && node.getSubnodes() != null) {
            for (PedagogicalPlannerSequenceNode subnode : node.getSubnodes()) {
                String fullDesc;
                Document doc = new Document();
                TextField titleField = new TextField(FIELD_NAME_TITLE, subnode.getTitle(), Field.Store.NO);
                titleField.setBoost(10.0f);
                doc.add((IndexableField)titleField);
                String briefDesc = WebUtil.removeHTMLtags((String)subnode.getBriefDescription());
                if (briefDesc != null) {
                    TextField briefDescField = new TextField(FIELD_NAME_BRIEF_DESCRIPTION, briefDesc, Field.Store.NO);
                    doc.add((IndexableField)briefDescField);
                }
                if ((fullDesc = WebUtil.removeHTMLtags((String)subnode.getFullDescription())) != null) {
                    TextField fullDescField = new TextField(FIELD_NAME_FULL_DESCRIPTION, fullDesc, Field.Store.NO);
                    doc.add((IndexableField)fullDescField);
                }
                StringField uidField = new StringField(FIELD_NAME_ANCESTOR_UID, subnode.getUid().toString(), Field.Store.YES);
                doc.add((IndexableField)uidField);
                docs.add(doc);
                Set<Document> subnodeDocs = this.extractSubnodeDocuments(subnode);
                docs.addAll(subnodeDocs);
            }
        }
        return docs;
    }

    public ActionForward initGrouping(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PedagogicalPlannerGroupingForm plannerForm = (PedagogicalPlannerGroupingForm)form;
        Long groupingId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        Grouping grouping = this.getAuthoringService().getGroupingById(groupingId);
        plannerForm.fillForm(grouping);
        return mapping.findForward(FORWARD_GROUPING);
    }

    public ActionForward saveOrUpdateGroupingForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.debug((Object)"Saving grouping activity");
        PedagogicalPlannerGroupingForm plannerForm = (PedagogicalPlannerGroupingForm)form;
        ActionMessages errors = plannerForm.validate();
        if (errors.isEmpty()) {
            Grouping grouping = this.getAuthoringService().getGroupingById(plannerForm.getToolContentID());
            if (grouping.isRandomGrouping()) {
                RandomGrouping randomGrouping = (RandomGrouping)grouping;
                Integer number = StringUtils.isEmpty((String)plannerForm.getNumberOfGroups()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getNumberOfGroups()));
                randomGrouping.setNumberOfGroups(number);
                number = StringUtils.isEmpty((String)plannerForm.getLearnersPerGroup()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getLearnersPerGroup()));
                randomGrouping.setLearnersPerGroup(number);
            } else if (grouping.isLearnerChoiceGrouping()) {
                LearnerChoiceGrouping learnerChoiceGrouping = (LearnerChoiceGrouping)grouping;
                Integer number = StringUtils.isEmpty((String)plannerForm.getNumberOfGroups()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getNumberOfGroups()));
                learnerChoiceGrouping.setNumberOfGroups(number);
                number = StringUtils.isEmpty((String)plannerForm.getLearnersPerGroup()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getLearnersPerGroup()));
                learnerChoiceGrouping.setLearnersPerGroup(number);
                learnerChoiceGrouping.setEqualNumberOfLearnersPerGroup(plannerForm.getEqualGroupSizes());
                learnerChoiceGrouping.setViewStudentsBeforeSelection(plannerForm.getViewStudentsBeforeSelection());
            } else {
                Integer number = StringUtils.isEmpty((String)plannerForm.getNumberOfGroups()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getNumberOfGroups()));
                grouping.setMaxNumberOfGroups(number);
            }
        } else {
            this.saveMessages(request, errors);
        }
        return mapping.findForward(FORWARD_GROUPING);
    }

    private List<PedagogicalPlannerSequenceNodeDTO> getRecentlyModifiedLearnindDesignsAsNodes() throws ServletException {
        User user = this.getUser();
        Set recentLDs = user.getRecentlyModifiedLearningDesigns();
        LinkedList<PedagogicalPlannerSequenceNodeDTO> recentNodes = new LinkedList<PedagogicalPlannerSequenceNodeDTO>();
        for (Long learningDesignId : recentLDs) {
            LearningDesign learningDesign = this.getAuthoringService().getLearningDesign(learningDesignId);
            PedagogicalPlannerSequenceNodeDTO node = new PedagogicalPlannerSequenceNodeDTO();
            node.setTitle(learningDesign.getTitle());
            node.setLearningDesignId(learningDesignId);
            recentNodes.add(node);
        }
        return recentNodes;
    }

    private void updateRecentLearningDesignList(Long learningDesignId) throws ServletException {
        User user = this.getUser();
        Set recentLDs = user.getRecentlyModifiedLearningDesigns();
        boolean ldFound = false;
        Iterator iter = recentLDs.iterator();
        while (iter.hasNext()) {
            Long recentLD = (Long)iter.next();
            if (!recentLD.equals(learningDesignId)) continue;
            iter.remove();
            this.getUserManagementService().saveUser(user);
            ldFound = true;
            break;
        }
        if (!ldFound && recentLDs.size() >= 10) {
            iter.remove();
        }
        recentLDs.add(learningDesignId);
        this.getUserManagementService().save((Object)user);
    }

    public ActionForward saveSequenceDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"Saving sequence title");
        String sequenceTitle = WebUtil.readStrParam((HttpServletRequest)request, (String)"sequenceTitle", (boolean)true);
        Long learningDesignID = WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId");
        Integer callAttemptedID = WebUtil.readIntParam((HttpServletRequest)request, (String)"callAttemptedID");
        String responseSuffix = "&" + callAttemptedID;
        if (StringUtils.isEmpty((String)sequenceTitle)) {
            String blankTitleError = this.getMessageService().getMessage("error.planner.title.blank");
            this.writeAJAXResponse(response, blankTitleError + responseSuffix);
        } else {
            LearningDesign learningDesign = this.getAuthoringService().getLearningDesign(learningDesignID);
            learningDesign.setTitle(sequenceTitle);
            String activityMetadataString = WebUtil.readStrParam((HttpServletRequest)request, (String)"activityMetadataField", (boolean)true);
            if (!StringUtils.isEmpty((String)activityMetadataString)) {
                String[] activityMetadataEntries = activityMetadataString.split("&");
                TreeMap<Long, PedagogicalPlannerActivityMetadata> activitiesMetadata = new TreeMap<Long, PedagogicalPlannerActivityMetadata>();
                for (String activityMetadataEntry : activityMetadataEntries) {
                    String[] keyAndValue = activityMetadataEntry.split("=");
                    String[] keyParts = keyAndValue[0].split("\\.");
                    String toolContentIdString = keyParts[0].substring(ACTIVITY_METADATA_PREFIX.length());
                    Long toolContentId = Long.parseLong(toolContentIdString);
                    PedagogicalPlannerActivityMetadata plannerMetadata = (PedagogicalPlannerActivityMetadata)activitiesMetadata.get(toolContentId);
                    if (plannerMetadata == null) {
                        plannerMetadata = new PedagogicalPlannerActivityMetadata();
                        activitiesMetadata.put(toolContentId, plannerMetadata);
                    }
                    String fieldName = keyParts[1];
                    String value = keyAndValue[1];
                    if (ACTIVITY_METADATA_COLLAPSED.equalsIgnoreCase(fieldName)) {
                        plannerMetadata.setCollapsed(Boolean.valueOf(Boolean.parseBoolean(value)));
                        continue;
                    }
                    if (ACTIVITY_METADATA_EXPANDED.equalsIgnoreCase(fieldName)) {
                        plannerMetadata.setExpanded(Boolean.valueOf(Boolean.parseBoolean(value)));
                        continue;
                    }
                    if (ACTIVITY_METADATA_HIDDEN.equalsIgnoreCase(fieldName)) {
                        plannerMetadata.setHidden(Boolean.valueOf(Boolean.parseBoolean(value)));
                        continue;
                    }
                    if (!ACTIVITY_METADATA_EDITING_ADVICE.equalsIgnoreCase(fieldName)) continue;
                    plannerMetadata.setEditingAdvice(value);
                }
                if (!activitiesMetadata.isEmpty()) {
                    for (Activity activity : learningDesign.getActivities()) {
                        ToolActivity toolActivity;
                        PedagogicalPlannerActivityMetadata plannerMetadata;
                        if (!activity.isToolActivity() || (plannerMetadata = (PedagogicalPlannerActivityMetadata)activitiesMetadata.get((toolActivity = (ToolActivity)(activity = this.getActivityDAO().getActivityByActivityId(activity.getActivityId()))).getToolContentId())) == null) continue;
                        PedagogicalPlannerActivityMetadata storedMetadata = toolActivity.getPlannerMetadata();
                        if (storedMetadata == null) {
                            plannerMetadata.setActivity(toolActivity);
                            toolActivity.setPlannerMetadata(plannerMetadata);
                            continue;
                        }
                        storedMetadata.copyProperties(plannerMetadata);
                    }
                }
            }
            learningDesign.setLastModifiedDateTime(new Date());
            String copyMode = WebUtil.readStrParam((HttpServletRequest)request, (String)"copyMode", (boolean)true);
            if (COPY_MODE_MOVE_CURRRENT.equalsIgnoreCase(copyMode)) {
                User user = this.getUser();
                WorkspaceFolder userFolder = user.getWorkspaceFolder();
                learningDesign.setWorkspaceFolder(userFolder);
            }
            this.getAuthoringService().saveLearningDesign(learningDesign);
            this.updateRecentLearningDesignList(learningDesignID);
            this.writeAJAXResponse(response, "OK" + responseSuffix);
        }
        return null;
    }

    public ActionForward exportTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId");
        ArrayList toolsErrorMsgs = new ArrayList();
        ActionMessages errors = new ActionMessages();
        String zipFilePath = null;
        boolean valid = false;
        try {
            zipFilePath = this.getExportService().exportLearningDesign(learningDesignId, toolsErrorMsgs);
            if (toolsErrorMsgs.isEmpty()) {
                String zipfile = FileUtil.getFileName((String)zipFilePath);
                zipfile = zipfile.replaceAll(" ", "_");
                String filename = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)zipfile);
                log.debug((Object)("Final filename to export: " + filename));
                response.setContentType("application/x-download");
                response.setHeader("Content-Disposition", "attachment;filename=" + filename);
                valid = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        if (!valid) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_EXPORT_TEMPLATE));
            this.saveErrors(request, errors);
            for (String error : toolsErrorMsgs) {
                log.error((Object)error);
            }
            LearningDesign learningDesign = this.getAuthoringService().getLearningDesign(learningDesignId);
            errors = this.openTemplate(request, learningDesign);
            if (!errors.isEmpty()) {
                throw new ServletException(this.getMessageService().getMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
            }
            return mapping.findForward("template");
        }
        FileUtils.copyFile((File)new File(zipFilePath), (OutputStream)response.getOutputStream());
        return null;
    }

    public ActionForward addRemoveEditors(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        if (this.canEditNode(request, nodeUid)) {
            List existingUsers = this.getPedagogicalPlannerDAO().getNodeUsers(nodeUid, Role.ROLE_SYSADMIN);
            Integer orgId = this.getUserManagementService().getRootOrganisation().getOrganisationId();
            Vector potentialUsersVector = this.getUserManagementService().getUsersFromOrganisationByRole(orgId, "SYSADMIN", true);
            Set allInheritedUsers = this.getPedagogicalPlannerDAO().getInheritedNodeUsers(nodeUid, Role.ROLE_SYSADMIN);
            ArrayList<User> filteredInheritedUsers = new ArrayList<User>();
            for (Object o : allInheritedUsers) {
                User u = (User)o;
                if (existingUsers.contains(u)) continue;
                filteredInheritedUsers.add(u);
            }
            ArrayList<User> potentialUsers = new ArrayList<User>();
            for (Object o : potentialUsersVector) {
                User u = (User)o;
                if (existingUsers.contains(u) || allInheritedUsers.contains(u) || StringUtils.equals((String)u.getLogin(), (String)request.getRemoteUser())) continue;
                potentialUsers.add(u);
            }
            request.setAttribute("existingUsers", (Object)existingUsers);
            request.setAttribute("potentialUsers", potentialUsers);
            request.setAttribute("inheritedUsers", filteredInheritedUsers);
            return mapping.findForward("editAuthors");
        }
        log.debug((Object)"Unauthorised attempt to access add/remove editors page.");
        throw new UserAccessDeniedException();
    }

    public ActionForward addEditor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId", (boolean)false);
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        if (this.canEditNode(request, nodeUid)) {
            this.getPedagogicalPlannerDAO().saveNodeRole(userId, nodeUid, Role.ROLE_SYSADMIN);
        } else {
            log.debug((Object)"Unauthorised attempt to add editor to node.");
        }
        return null;
    }

    public ActionForward removeEditor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userId", (boolean)false);
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)false);
        if (this.canEditNode(request, nodeUid)) {
            this.getPedagogicalPlannerDAO().removeNodeRole(userId, nodeUid, Role.ROLE_SYSADMIN);
        } else {
            log.debug((Object)"Unauthorised attempt to remove editor from node.");
        }
        return null;
    }

    private boolean canEditNode(HttpServletRequest request, Long nodeUid) {
        return this.isNodeOwnerOrSuperuser(request, nodeUid) || this.isEditor(request, nodeUid);
    }

    private boolean isNodeOwnerOrSuperuser(HttpServletRequest request, Long nodeUid) {
        if (request.isUserInRole("SYSADMIN")) {
            return true;
        }
        if (nodeUid == null) {
            return this.getUserManagementService().isUserSysAdmin();
        }
        User user = this.getUserManagementService().getUserByLogin(request.getRemoteUser());
        PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
        User nodeOwner = node.getUser();
        return nodeOwner != null && user.equals((Object)nodeOwner);
    }

    private boolean isEditor(HttpServletRequest request, Long nodeUid) {
        User user = this.getUserManagementService().getUserByLogin(request.getRemoteUser());
        return this.getPedagogicalPlannerDAO().isEditor(user.getUserId(), nodeUid, Role.ROLE_SYSADMIN);
    }

    private boolean canRemoveSubtree(HttpServletRequest request, Long nodeUid) {
        if (nodeUid == null || request.isUserInRole("SYSADMIN")) {
            return true;
        }
        boolean isOwner = this.isNodeOwnerOrSuperuser(request, nodeUid);
        boolean isPlainEditor = this.isEditor(request, nodeUid);
        if (isOwner || isPlainEditor) {
            PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
            Integer nodePermissions = node.getPermissions();
            if (isOwner || nodePermissions == null || (nodePermissions & 8) != 0) {
                Set subnodes = node.getSubnodes();
                if (subnodes != null && !subnodes.isEmpty()) {
                    for (PedagogicalPlannerSequenceNode subnode : subnodes) {
                        if (this.canRemoveSubtree(request, subnode.getUid())) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private IExportToolContentService getExportService() {
        if (exportService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            exportService = (IExportToolContentService)ctx.getBean("exportToolContentService");
        }
        return exportService;
    }

    private IAuthoringService getAuthoringService() {
        if (authoringService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            authoringService = (IAuthoringService)ctx.getBean("authoringService");
        }
        return authoringService;
    }

    private IMonitoringService getMonitoringService() {
        if (monitoringService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            monitoringService = (IMonitoringService)ctx.getBean("monitoringService");
        }
        return monitoringService;
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private MessageService getMessageService() {
        if (messageService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            messageService = (MessageService)ctx.getBean("centralMessageService");
        }
        return messageService;
    }

    private PedagogicalPlannerDAO getPedagogicalPlannerDAO() {
        if (pedagogicalPlannerDAO == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            pedagogicalPlannerDAO = (PedagogicalPlannerDAO)wac.getBean("pedagogicalPlannerDAO");
        }
        return pedagogicalPlannerDAO;
    }

    private IActivityDAO getActivityDAO() {
        if (activityDAO == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            activityDAO = (IActivityDAO)wac.getBean("activityDAO");
        }
        return activityDAO;
    }

    static {
        luceneDir = new RAMDirectory();
        luceneAnalyzer = new StandardAnalyzer();
    }
}

