/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.CSSThemeUtil;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class CssTag
extends TagSupport {
    private static final long serialVersionUID = -3143529984657965761L;
    private static final Logger log = Logger.getLogger(CssTag.class);
    private static final String RTL_DIR = "rtl";
    private String suffix = null;
    private String webapp = null;

    public int doStartTag() throws JspException {
        String serverURL = Configuration.get((String)ConfigurationKeys.SERVER_URL);
        String string = serverURL = serverURL == null ? null : serverURL.trim();
        if (serverURL != null) {
            try {
                HttpSession session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
                String pageDirection = (String)session.getAttribute("page_direction");
                boolean rtl = RTL_DIR.equalsIgnoreCase(pageDirection);
                List themeList = CSSThemeUtil.getAllUserThemes();
                String customStylesheetLink = null;
                for (String theme : themeList) {
                    if (theme != null) {
                        theme = this.appendStyle(theme, rtl);
                        customStylesheetLink = this.generateLink(theme, serverURL);
                    }
                    if (customStylesheetLink == null) continue;
                    JspWriter writer = this.pageContext.getOut();
                    writer.println(customStylesheetLink);
                }
            }
            catch (IOException e) {
                log.error((Object)"CssTag unable to write out CSS details due to IOException.", (Throwable)e);
            }
        } else {
            log.warn((Object)"CSSTag unable to write out CSS entries as the server url is missing from the configuration file.");
        }
        return 0;
    }

    private String appendStyle(String stylesheetName, boolean rtl) {
        if (stylesheetName != null) {
            StringBuilder bldr = new StringBuilder(stylesheetName);
            if (rtl) {
                bldr.append("_").append(RTL_DIR);
            }
            bldr.append("_");
            bldr.append(this.suffix != null ? this.suffix : "learner");
            return bldr.toString();
        }
        return null;
    }

    private String generateLink(String stylesheetName, String serverURL) {
        StringBuilder bldr = new StringBuilder("<link href=\"").append(serverURL);
        if (!serverURL.endsWith("/")) {
            bldr.append("/");
        }
        if (this.webapp != null) {
            bldr.append(this.webapp).append("/");
        }
        bldr.append("css/").append(stylesheetName).append(".css\" rel=\"stylesheet\" type=\"text/css\">");
        return bldr.toString();
    }

    public int doEndTag() {
        return 6;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getWebapp() {
        return this.webapp;
    }

    public void setWebapp(String webapp) {
        this.webapp = webapp;
    }
}

