/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortraitTag
extends BodyTagSupport {
    private static final long serialVersionUID = -3143529984657965761L;
    private static final Logger log = Logger.getLogger(PortraitTag.class);
    private static final int NUM_COLORS = 7;
    private IUserManagementService userManagementService;
    private static final String CSS_ROUND = " portrait-round";
    private static final String PORTRAIT_VERSION_SUFFIX = " portrait-color-";
    private static final String STYLE_SMALL = "small";
    private static final String[] CSS_SMALL = new String[]{"portrait-sm", "&version=4"};
    private static final String CSS_GENERIC_SMALL = "portrait-generic-sm";
    private static final String STYLE_MEDIUM = "medium";
    private static final String[] CSS_MEDIUM = new String[]{"portrait-md", "&version=3"};
    private static final String CSS_GENERIC_MEDIUM = "portrait-generic-md";
    private static final String STYLE_LARGE = "large";
    private static final String[] CSS_LARGE = new String[]{"portrait-lg", "&version=2"};
    private static final String CSS_GENERIC_LARGE = "portrait-generic-lg";
    private static final String STYLE_XLARGE = "xlarge";
    private static final String[] CSS_XLARGE = new String[]{"portrait-xl", "&version=1"};
    private static final String CSS_GENERIC_XLARGE = "portrait-generic-xl";
    private String userId = null;
    private String size = null;
    private String round = null;
    private String hover = null;

    public int doStartTag() throws JspException {
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        String serverURL = Configuration.get((String)ConfigurationKeys.SERVER_URL);
        serverURL = serverURL == null ? null : serverURL.trim();
        try {
            if (this.userId != null && this.userId.length() > 0) {
                String code = null;
                HashMap<String, String> cache = this.getPortraitCache();
                code = cache.get(this.userId);
                if (code == null) {
                    Integer userIdInt = Integer.decode(this.userId);
                    User user = (User)this.getUserManagementService().findById(User.class, (Serializable)userIdInt);
                    boolean isHover = this.hover != null ? Boolean.valueOf(this.hover) : false;
                    code = isHover ? this.buildHoverUrl(user) : this.buildDivUrl(user);
                    cache.put(this.userId, code);
                }
                JspWriter writer = this.pageContext.getOut();
                writer.print(code);
            }
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("PortraitId unable to write out portrait details as userId is invalid. " + this.userId), (Throwable)nfe);
        }
        catch (IOException ioe) {
            log.error((Object)("PortraitId unable to write out portrait details due to IOException. UserId is " + this.userId), (Throwable)ioe);
        }
        catch (Exception e) {
            log.error((Object)("PortraitId unable to write out portrait details due to an exception. UserId is " + this.userId), (Throwable)e);
        }
        return 0;
    }

    private String buildDivUrl(User user) {
        Long portraitId;
        Long l = portraitId = user != null ? user.getPortraitUuid() : null;
        if (portraitId != null) {
            boolean isRound = this.round != null ? Boolean.valueOf(this.round) : true;
            String[] sizes = this.getSizeClass();
            StringBuilder bldr = new StringBuilder("<img class=\"").append(sizes[0]);
            if (isRound) {
                bldr.append(CSS_ROUND);
            }
            String serverURL = Configuration.get((String)ConfigurationKeys.SERVER_URL);
            bldr.append("\" src='").append(serverURL);
            if (!serverURL.endsWith("/")) {
                bldr.append("/");
            }
            bldr.append("download?preferDownload=false&uuid=").append(portraitId).append(sizes[1]).append("'></img>");
            return bldr.toString();
        }
        return "<div class=\"" + this.getGenericSizeClass() + PORTRAIT_VERSION_SUFFIX + user.getUserId() % 7 + "\"></div>";
    }

    private String buildHoverUrl(User user) {
        String linkText;
        Long portraitId = user != null ? user.getPortraitUuid() : null;
        String string = linkText = this.getBodyContent() != null ? this.getBodyContent().getString() : null;
        if (portraitId != null) {
            String fullName = user.getFullName();
            if (linkText == null || linkText.length() == 0) {
                linkText = fullName;
            }
            return "<a tabindex=\"0\" class=\"popover-link new-popover\" role=\"button\" data-toggle=\"popover\" data-id=\"popover-" + this.userId + "\" data-portrait=\"" + portraitId + "\" data-fullname=\"" + fullName + "\">" + linkText + "</a>";
        }
        return linkText != null ? linkText : "";
    }

    private IUserManagementService getUserManagementService() {
        if (this.userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
            this.userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return this.userManagementService;
    }

    private HashMap<String, String> getPortraitCache() {
        HashMap cache = (HashMap)this.pageContext.getAttribute("portraitCache");
        if (cache == null) {
            cache = new HashMap();
            this.pageContext.setAttribute("portraitCache", cache);
        }
        return cache;
    }

    private String[] getSizeClass() {
        if (this.size != null) {
            if (this.size.equalsIgnoreCase(STYLE_MEDIUM)) {
                return CSS_MEDIUM;
            }
            if (this.size.equalsIgnoreCase(STYLE_LARGE)) {
                return CSS_LARGE;
            }
            if (this.size.equalsIgnoreCase(STYLE_XLARGE)) {
                return CSS_XLARGE;
            }
        }
        return CSS_SMALL;
    }

    private String getGenericSizeClass() {
        if (this.size != null) {
            if (this.size.equalsIgnoreCase(STYLE_MEDIUM)) {
                return CSS_GENERIC_MEDIUM;
            }
            if (this.size.equalsIgnoreCase(STYLE_LARGE)) {
                return CSS_GENERIC_LARGE;
            }
            if (this.size.equalsIgnoreCase(STYLE_XLARGE)) {
                return CSS_GENERIC_XLARGE;
            }
        }
        return CSS_GENERIC_SMALL;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getRound() {
        return this.round;
    }

    public void setRound(String round) {
        this.round = round;
    }

    public String getHover() {
        return this.hover;
    }

    public void setHover(String hover) {
        this.hover = hover;
    }
}

