/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.LearningDesignService;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LearningDesignSVGServlet
extends HttpServlet {
    private static final long serialVersionUID = -1918180868204870617L;
    private static Logger log = Logger.getLogger(LearningDesignSVGServlet.class);
    private static IntegrationService integrationService = null;
    private ILearningDesignService learningDesignService = null;
    private ILessonService lessonService = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String serverId = request.getParameter("serverId");
            String datetime = request.getParameter("datetime");
            String hashValue = request.getParameter("hashValue");
            String username = request.getParameter("username");
            Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lsId", (boolean)true);
            Long learningDesignId = lessonId == null ? WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId") : this.lessonService.getLessonDetails(lessonId).getLearningDesignID();
            if (serverId == null || datetime == null || hashValue == null || username == null) {
                String msg = "Parameters missing";
                log.error((Object)msg);
                response.sendError(400, "Parameters missing");
            }
            if (request.getCharacterEncoding() == null) {
                log.debug((Object)"request.getCharacterEncoding is empty, parsing username and courseName as 8859_1 to UTF-8...");
                username = new String(username.getBytes("8859_1"), "UTF-8");
            }
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            String imagePath = LearningDesignService.getLearningDesignSVGPath((long)learningDesignId);
            File imageFile = new File(imagePath);
            if (!imageFile.canRead()) {
                response.sendError(404);
                return;
            }
            boolean download = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"download", (boolean)false);
            if (download) {
                String name = this.learningDesignService.getLearningDesignDTO(learningDesignId, Configuration.get((String)ConfigurationKeys.SERVER_LANGUAGE)).getTitle();
                name = name + ".svg";
                name = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)name);
                response.setContentType("application/x-download");
                response.setHeader("Content-Disposition", "attachment;filename=" + name);
            } else {
                response.setContentType("image/svg+xml");
            }
            FileInputStream input = new FileInputStream(imagePath);
            ServletOutputStream output = response.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
        catch (Exception e) {
            log.error((Object)"Problem with LearningDesignSVGServlet request", (Throwable)e);
            response.sendError(400, "Problem with LearningDesignSVGServlet request");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void init() throws ServletException {
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        this.learningDesignService = (ILearningDesignService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("learningDesignService");
        this.lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("lessonService");
    }
}

