/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice.xml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.exception.RepositoryCheckedException;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.workspace.dto.FolderContentDTO;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.lamsfoundation.lams.workspace.web.WorkspaceAction;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LearningDesignRepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = -4962711640290319063L;
    private static Logger log = Logger.getLogger(LearningDesignRepositoryServlet.class);
    private static IntegrationService integrationService = null;
    private static IWorkspaceManagementService service = null;
    private static MessageService msgService = null;
    private static IExportToolContentService exportToolContentService = null;
    private static final String PARAM_LEARING_DESIGN_ID = "learningDesignID";

    public void destroy() {
        super.destroy();
    }

    private ContentTreeNode buildContentTree(Integer userId, Integer mode) throws IOException, UserAccessDeniedException, RepositoryCheckedException {
        log.debug((Object)("User Id - " + userId));
        FolderContentDTO rootFolder = new FolderContentDTO(msgService.getMessage("label.workspace.root_folder"), msgService.getMessage("folder"), null, null, "Folder", Long.valueOf(WorkspaceAction.BOOTSTRAP_FOLDER_ID.longValue()), WorkspaceFolder.READ_ACCESS, null);
        ContentTreeNode root = new ContentTreeNode(rootFolder);
        FolderContentDTO userFolder = service.getUserWorkspaceFolder(userId);
        root.addChild(this.buildContentTreeNode(userFolder, userId, mode));
        FolderContentDTO dummyOrgFolder = new FolderContentDTO(msgService.getMessage("organisations"), msgService.getMessage("folder"), null, null, "Folder", new Long(WorkspaceAction.ORG_FOLDER_ID.longValue()), WorkspaceFolder.READ_ACCESS, null);
        ContentTreeNode dummyOrgNode = new ContentTreeNode(dummyOrgFolder);
        Vector orgFolders = service.getAccessibleOrganisationWorkspaceFolders(userId);
        for (int i = 0; i < orgFolders.size(); ++i) {
            FolderContentDTO orgFolder = (FolderContentDTO)orgFolders.get(i);
            dummyOrgNode.addChild(this.buildContentTreeNode(orgFolder, userId, mode));
        }
        root.addChild(dummyOrgNode);
        FolderContentDTO publicFolder = service.getPublicWorkspaceFolder(userId);
        if (publicFolder != null) {
            root.addChild(this.buildContentTreeNode(publicFolder, userId, mode));
        }
        return root;
    }

    private ContentTreeNode buildContentTreeNode(FolderContentDTO folder, Integer userId, Integer mode) throws UserAccessDeniedException, RepositoryCheckedException {
        log.debug((Object)("build content tree node for folder - " + folder.getName()));
        ContentTreeNode node = new ContentTreeNode(folder);
        if (folder.getResourceType().equals("Folder")) {
            log.debug((Object)(folder.getName() + " is a folder"));
            WorkspaceFolder wsfolder = service.getWorkspaceFolder(folder.getResourceID().intValue());
            Vector<FolderContentDTO> items = service.getFolderContentsExcludeHome(userId, wsfolder, mode);
            for (int i = 0; i < items.size(); ++i) {
                FolderContentDTO content = items.get(i);
                node.addChild(this.buildContentTreeNode(content, userId, mode));
            }
        }
        return node;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String serverId = request.getParameter("serverId");
            String datetime = request.getParameter("datetime");
            String hashValue = request.getParameter("hashValue");
            String username = request.getParameter("username");
            String courseId = request.getParameter("courseId");
            String courseName = request.getParameter("courseName");
            String country = request.getParameter("country");
            String locale = request.getParameter("lang");
            Integer mode = WebUtil.readIntParam((HttpServletRequest)request, (String)"mode", (boolean)true);
            String method = request.getParameter("method");
            String usePrefix = request.getParameter("usePrefix");
            boolean isUpdateUserDetails = false;
            String firstName = request.getParameter("firstName");
            String lastName = request.getParameter("lastName");
            String email = request.getParameter("email");
            if (serverId == null || datetime == null || hashValue == null || username == null || courseId == null || country == null || locale == null) {
                String msg = "Parameters missing";
                log.error((Object)msg);
                response.sendError(400, "Parameters missing");
            }
            if (request.getCharacterEncoding() == null) {
                log.debug((Object)"request.getCharacterEncoding is empty, parsing username and courseName as 8859_1 to UTF-8...");
                username = new String(username.getBytes("8859_1"), "UTF-8");
                if (courseName != null) {
                    courseName = new String(courseName.getBytes("8859_1"), "UTF-8");
                }
            }
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            if (method != null && method.equals("exportLD")) {
                this.exportLD(request, response);
            } else if (method != null && (method.equals("getLearningDesignsJSON") || method.equals("getPagedHomeLearningDesignsJSON"))) {
                Integer userId = this.getUserId(username, courseId, courseName, locale, country, usePrefix, false, firstName, lastName, email, extServer);
                boolean allowInvalidDesigns = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"allowInvalidDesigns", (boolean)false);
                String folderContentsJSON = null;
                if (method.equals("getLearningDesignsJSON")) {
                    Integer folderID = WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID", (boolean)true);
                    String designType = request.getParameter("type");
                    folderContentsJSON = service.getFolderContentsJSON(folderID, userId, allowInvalidDesigns, designType);
                } else {
                    Integer page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page", (boolean)true);
                    Integer size = WebUtil.readIntParam((HttpServletRequest)request, (String)"size", (boolean)true);
                    String sortName = request.getParameter("sortName");
                    String sortDate = request.getParameter("sortDate");
                    String search = request.getParameter("search");
                    folderContentsJSON = service.getPagedLearningDesignsJSON(userId, allowInvalidDesigns, search, page, size, sortName == null ? null : (sortName.equals("0") ? "DESC" : "ASC"), sortDate == null ? null : (sortDate.equals("0") ? "DESC" : "ASC"));
                }
                response.setContentType("application/json;charset=UTF-8");
                response.getWriter().write(folderContentsJSON);
            } else if (method != null && method.equals("deleteLearningDesignJSON")) {
                Integer userId = this.getUserId(username, courseId, courseName, locale, country, usePrefix, false, firstName, lastName, email, extServer);
                Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LEARING_DESIGN_ID);
                log.debug((Object)("User " + userId + " " + username + " deleting learning design " + learningDesignId));
                service.deleteResource(learningDesignId, "LearningDesign", userId);
            } else {
                if (mode == null) {
                    String msg = "Parameter missing: mode";
                    log.error((Object)msg);
                    response.sendError(400, msg);
                }
                ExtUserUseridMap userMap = null;
                boolean prefix = usePrefix == null ? true : Boolean.parseBoolean(usePrefix);
                userMap = firstName == null && lastName == null ? integrationService.getExtUserUseridMap(extServer, username, prefix) : integrationService.getImplicitExtUserUseridMap(extServer, username, firstName, lastName, locale, country, email, prefix, false);
                integrationService.getExtCourseClassMap(extServer, userMap, courseId, courseName, "author");
                Integer userId = userMap.getUser().getUserId();
                String contentTree = this.buildContentTree(userId, mode).toString();
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF8");
                PrintWriter out = response.getWriter();
                out.print(contentTree);
            }
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"mode is not an integer", (Throwable)nfe);
            response.sendError(400, "mode is not an integer");
        }
        catch (AuthenticationException e) {
            log.error((Object)"can not authenticate", (Throwable)e);
            response.sendError(400, "can not authenticate");
        }
        catch (UserInfoFetchException e) {
            log.error((Object)"can not retrieve user information", (Throwable)e);
            response.sendError(400, "can not retrieve user information");
        }
        catch (UserAccessDeniedException e) {
            log.error((Object)"user access denied", (Throwable)e);
            response.sendError(400, "user access denied");
        }
        catch (RepositoryCheckedException e) {
            log.error((Object)"repository checked", (Throwable)e);
            response.sendError(400, "repository checked");
        }
        catch (Exception e) {
            log.error((Object)"Problem with LearningDesignRepositoryServlet request", (Throwable)e);
            response.sendError(400, "Problem with LearningDesignRepositoryServlet request");
        }
    }

    private Integer getUserId(String username, String courseId, String courseName, String locale, String country, String usePrefix, boolean isUpdateUserDetails, String firstName, String lastName, String email, ExtServer extServer) throws UserInfoFetchException, UserInfoValidationException {
        ExtUserUseridMap userMap = null;
        boolean prefix = usePrefix == null ? true : Boolean.parseBoolean(usePrefix);
        userMap = firstName == null && lastName == null ? integrationService.getExtUserUseridMap(extServer, username, prefix) : integrationService.getImplicitExtUserUseridMap(extServer, username, firstName, lastName, locale, country, email, prefix, isUpdateUserDetails);
        integrationService.getExtCourseClassMap(extServer, userMap, courseId, courseName, "author");
        Integer userId = userMap.getUser().getUserId();
        return userId;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void exportLD(HttpServletRequest request, HttpServletResponse response) {
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LEARING_DESIGN_ID);
        ArrayList toolsErrorMsgs = new ArrayList();
        try {
            String zipFilename = exportToolContentService.exportLearningDesign(learningDesignId, toolsErrorMsgs);
            String zipfile = FileUtil.getFileName((String)zipFilename);
            zipfile = zipfile.replaceAll(" ", "_");
            String filename = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)zipfile);
            log.debug((Object)("Final filename to export: " + filename));
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
            InputStream in = null;
            OutputStream out = null;
            try {
                int ch;
                in = new BufferedInputStream(new FileInputStream(zipFilename));
                out = response.getOutputStream();
                int count = 0;
                while ((ch = in.read()) != -1) {
                    out.write((char)ch);
                    ++count;
                }
                log.debug((Object)("Wrote out " + count + " bytes"));
                response.setContentLength(count);
                out.flush();
            }
            catch (Exception e) {
                log.error((Object)("Exception occured writing out file:" + e.getMessage()));
                throw new ExportToolContentException((Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error Closing file. File already written out - no exception being thrown.", (Throwable)e);
                }
            }
        }
        catch (Exception e1) {
            log.error((Object)("Unable to export tool content to external integrated server: " + e1.toString()));
        }
    }

    public void init() throws ServletException {
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        service = (IWorkspaceManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("workspaceManagementService");
        msgService = service.getMessageService();
        exportToolContentService = (IExportToolContentService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("exportToolContentService");
    }

    private static class ContentTreeNode {
        FolderContentDTO content;
        List<ContentTreeNode> children;

        ContentTreeNode(FolderContentDTO content) {
            this.content = content;
            this.children = new LinkedList<ContentTreeNode>();
        }

        void addChild(ContentTreeNode node) {
            this.children.add(node);
        }

        public String toString() {
            Document document = this.getDocument();
            try {
                DOMSource domSource = new DOMSource(document);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
                return writer.toString();
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public Document getDocument() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element element = this.createXML(document);
                document.appendChild(element);
                return document;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Element createXML(Document document) {
            Element elem = null;
            if (this.content.getResourceType().equals("Folder")) {
                elem = document.createElement("Folder");
                elem.setAttribute("name", this.content.getName());
                if (this.children.size() > 0) {
                    for (int i = 0; i < this.children.size(); ++i) {
                        elem.appendChild(this.children.get(i).createXML(document));
                    }
                }
            } else if (this.content.getResourceType().equals("LearningDesign")) {
                elem = document.createElement("LearningDesign");
                elem.setAttribute("name", this.content.getName());
                elem.setAttribute("resourceId", this.content.getResourceID().toString());
            }
            return elem;
        }
    }
}

