/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.events.Subscription;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class NotificationServlet
extends HttpServlet {
    private static final long serialVersionUID = 4856874776383254865L;
    private static Logger log = Logger.getLogger(NotificationServlet.class);
    private static IntegrationService integrationService = null;
    private static IEventNotificationService eventNotificationService = null;
    private static DocumentBuilder docBuilder = null;
    private static final Pattern anchorPattern = Pattern.compile("<a .*href=(['\"])(.*)\\1.*>(.*)</a>");

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String serverId = request.getParameter("serverId");
        String datetime = request.getParameter("datetime");
        String hashValue = request.getParameter("hashValue");
        String username = request.getParameter("username");
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
            String method = request.getParameter("method");
            if ("getNotifications".equalsIgnoreCase(method)) {
                this.getNotifications(userMap.getUser().getUserId(), request, response);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while getting notifications", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void init() throws ServletException {
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        eventNotificationService = (IEventNotificationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("eventNotificationService");
    }

    private void getNotifications(Integer userId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Document doc = docBuilder.newDocument();
        Element notificationsElement = doc.createElement("Notifications");
        doc.appendChild(notificationsElement);
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lsId", (boolean)true);
        Integer limit = WebUtil.readIntParam((HttpServletRequest)request, (String)"limit", (boolean)true);
        Integer offset = WebUtil.readIntParam((HttpServletRequest)request, (String)"offset", (boolean)true);
        Boolean pendingOnly = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"pendingOnly", (boolean)true);
        List subscriptions = eventNotificationService.getNotificationSubscriptions(lessonId, userId, pendingOnly.booleanValue(), limit, offset);
        for (Subscription subscription : subscriptions) {
            String message;
            Matcher matcher;
            Element notificationElement = doc.createElement("Notification");
            notificationElement.setAttribute("id", subscription.getUid().toString());
            Boolean pending = !"seen".equals(subscription.getLastOperationMessage());
            notificationElement.setAttribute("pending", pending.toString());
            Long notificationLessonId = subscription.getEvent().getEventSessionId();
            if (notificationLessonId != null) {
                notificationElement.setAttribute("lessonId", notificationLessonId.toString());
            }
            if ((matcher = anchorPattern.matcher(message = subscription.getEvent().getMessage())).find()) {
                String href = StringEscapeUtils.escapeXml((String)matcher.group(2));
                notificationElement.setAttribute("href", href);
                message = matcher.group(3);
            }
            notificationElement.appendChild(doc.createCDATASection(message));
            notificationsElement.appendChild(notificationElement);
        }
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        LSOutput lsOutput = domImplementation.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        lsOutput.setByteStream((OutputStream)response.getOutputStream());
        lsSerializer.write(doc, lsOutput);
    }

    static {
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Error while initialising XML document builder", (Throwable)e);
        }
    }
}

