/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.usermanagement.OrganisationGroup;
import org.lamsfoundation.lams.usermanagement.OrganisationGrouping;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class OrganisationGroupServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(OrganisationGroupServlet.class);
    private static IntegrationService integrationService = null;
    private static IUserManagementService userManagementService = null;
    private static DocumentBuilder docBuilder = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String serverId = request.getParameter("serverId");
        String datetime = request.getParameter("datetime");
        String hashValue = request.getParameter("hashValue");
        String username = request.getParameter("username");
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            String method = request.getParameter("method");
            if ("getGroupings".equalsIgnoreCase(method)) {
                Integer organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"courseId", (boolean)false);
                this.getGroupings(organisationId, response);
            } else {
                log.error((Object)("Unknown method: " + method));
                response.sendError(400, "Unknown method: " + method);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while getting notifications", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void init() throws ServletException {
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        userManagementService = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("userManagementService");
    }

    private void getGroupings(Integer organisationId, HttpServletResponse response) throws IOException {
        Document doc = docBuilder.newDocument();
        Element groupsElement = doc.createElement("groups");
        doc.appendChild(groupsElement);
        List groupings = userManagementService.findByProperty(OrganisationGrouping.class, "organisationId", (Object)organisationId);
        for (OrganisationGrouping grouping : groupings) {
            Element groupingElement = doc.createElement("grouping");
            groupingElement.setAttribute("id", grouping.getGroupingId().toString());
            groupingElement.setAttribute("name", StringEscapeUtils.escapeXml((String)grouping.getName()));
            groupsElement.appendChild(groupingElement);
            for (OrganisationGroup group : grouping.getGroups()) {
                Element groupElement = doc.createElement("group");
                groupElement.setAttribute("id", group.getGroupId().toString());
                groupElement.setAttribute("name", StringEscapeUtils.escapeXml((String)group.getName()));
                groupingElement.appendChild(groupElement);
                for (User user : group.getUsers()) {
                    Element userElement = doc.createElement("user");
                    userElement.setAttribute("id", user.getUserId().toString());
                    userElement.setAttribute("firstname", StringEscapeUtils.escapeXml((String)user.getFirstName()));
                    userElement.setAttribute("lastname", StringEscapeUtils.escapeXml((String)user.getLastName()));
                    groupElement.appendChild(userElement);
                }
            }
        }
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        LSOutput lsOutput = domImplementation.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        lsOutput.setByteStream((OutputStream)response.getOutputStream());
        lsSerializer.write(doc, lsOutput);
    }

    static {
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Error while initialising XML document builder", (Throwable)e);
        }
    }
}

