/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WorkspaceAction
extends LamsDispatchAction {
    protected Logger log = Logger.getLogger((String)WorkspaceAction.class.getName());
    public static final String RESOURCE_ID = "resourceID";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final String ROLE_DELIMITER = ",";
    public static final Integer BOOTSTRAP_FOLDER_ID = new Integer(-1);
    public static final Integer ORG_FOLDER_ID = new Integer(-2);
    public static final Integer ROOT_ORG_FOLDER_ID = new Integer(1);

    private Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    public IWorkspaceManagementService getWorkspaceManagementService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IWorkspaceManagementService)webContext.getBean("workspaceManagementService");
    }

    private boolean checkResourceDummyValue(Long folderID, String resourceType) throws IOException {
        return "Folder".equals(resourceType) && (BOOTSTRAP_FOLDER_ID.equals(folderID) || ORG_FOLDER_ID.equals(folderID));
    }

    public ActionForward createFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, UserException, WorkspaceFolderException {
        Integer parentFolderID = WebUtil.readIntParam((HttpServletRequest)request, (String)"parentFolderID", (boolean)false);
        String folderName = WebUtil.readStrParam((HttpServletRequest)request, (String)"name", (boolean)false);
        Integer userID = this.getUserId();
        WorkspaceFolder newFolder = this.getWorkspaceManagementService().createFolder(parentFolderID, folderName, userID);
        response.setContentType("text/plain;charset=utf-8");
        response.getWriter().write(newFolder.getWorkspaceFolderId().toString());
        return null;
    }

    public ActionForward deleteResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long resourceID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)RESOURCE_ID));
        String resourceType = WebUtil.readStrParam((HttpServletRequest)request, (String)RESOURCE_TYPE);
        boolean isDummyValue = this.checkResourceDummyValue(resourceID, "Folder");
        if (isDummyValue) {
            throw new IOException("Can not remove this resource.");
        }
        this.getWorkspaceManagementService().deleteResource(resourceID, resourceType, this.getUserId());
        return null;
    }

    public ActionForward copyResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, LearningDesignException, UserException, WorkspaceFolderException {
        Long resourceID = WebUtil.readLongParam((HttpServletRequest)request, (String)RESOURCE_ID, (boolean)false);
        String resourceType = WebUtil.readStrParam((HttpServletRequest)request, (String)RESOURCE_TYPE, (boolean)false);
        Integer targetFolderID = WebUtil.readIntParam((HttpServletRequest)request, (String)"targetFolderID", (boolean)false);
        if (targetFolderID == null) {
            this.log.error((Object)"Can not copy resource, missing target folder ID");
            response.sendError(400, "Missing target folder ID");
            return null;
        }
        Integer copyType = WebUtil.readIntParam((HttpServletRequest)request, (String)"copyType", (boolean)true);
        Integer userID = this.getUserId();
        this.getWorkspaceManagementService().copyResource(resourceID, resourceType, copyType, targetFolderID, userID);
        return null;
    }

    public ActionForward moveResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long resourceID = WebUtil.readLongParam((HttpServletRequest)request, (String)RESOURCE_ID, (boolean)false);
        String resourceType = WebUtil.readStrParam((HttpServletRequest)request, (String)RESOURCE_TYPE, (boolean)false);
        Integer targetFolderID = WebUtil.readIntParam((HttpServletRequest)request, (String)"targetFolderID", (boolean)false);
        if (targetFolderID == null) {
            this.log.error((Object)"Can not move resource, missing target folder ID");
            response.sendError(400, "Missing target folder ID");
            return null;
        }
        try {
            this.getWorkspaceManagementService().moveResource(resourceID, resourceType, targetFolderID);
        }
        catch (WorkspaceFolderException e) {
            this.log.error((Object)"Error while moving a resource", (Throwable)e);
            response.sendError(400, "Error while moving a resource");
            return null;
        }
        return null;
    }

    public ActionForward renameResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, UserException, WorkspaceFolderException {
        Integer userID = this.getUserId();
        Long resourceID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)RESOURCE_ID));
        String resourceType = WebUtil.readStrParam((HttpServletRequest)request, (String)RESOURCE_TYPE);
        boolean isDummyValue = this.checkResourceDummyValue(resourceID, "Folder");
        if (isDummyValue) {
            throw new IOException("Can not rename this resource");
        }
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
        this.getWorkspaceManagementService().renameResource(resourceID, resourceType, name, userID);
        return null;
    }
}

