/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.dto;

import java.util.ArrayList;
import java.util.Date;
import org.lamsfoundation.lams.gradebook.dto.GradebookGridRowDTO;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.usermanagement.User;

public class GBUserGridRowDTO
extends GradebookGridRowDTO {
    private Date startDate;
    private String output;
    private String activityUrl;
    private String firstName;
    private String lastName;
    private String currentActivity;

    public GBUserGridRowDTO() {
    }

    public GBUserGridRowDTO(User user) {
        this.id = user.getUserId().toString();
        this.rowName = user.getLastName() + " " + user.getFirstName();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
    }

    @Override
    public ArrayList<String> toStringArray(GBGridView view) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.id.toString());
        if (view == GBGridView.MON_USER) {
            ret.add(this.rowName);
            ret.add(this.status);
            ret.add(this.timeTaken != null ? this.convertTimeToString(this.timeTaken) : "-");
            ret.add(this.feedback);
            ret.add(this.markToString());
        } else if (view == GBGridView.MON_ACTIVITY) {
            ret.add(this.marksAvailable != null ? this.marksAvailable.toString() : "");
            if (this.activityUrl != null && this.activityUrl.length() != 0) {
                ret.add("<a href='javascript:launchPopup(\"" + this.activityUrl + "\",\"" + this.rowName + "\",796,570)'>" + this.rowName + "</a>");
            } else {
                ret.add(this.rowName);
            }
            ret.add(this.status);
            ret.add(this.startDate != null ? this.convertDateToString(this.startDate, DEFAULT_DATE_FORMAT) : "-");
            ret.add(this.timeTaken != null ? this.convertTimeToString(this.timeTaken) : "-");
            ret.add(this.output != null ? this.output.toString() : "-");
            ret.add(this.feedback);
            ret.add(this.markToString());
        } else if (view == GBGridView.MON_COURSE) {
            ret.add(this.rowName);
            ret.add(this.status);
            ret.add(this.timeTaken != null ? this.convertTimeToString(this.timeTaken) : "-");
            ret.add(this.feedback);
            ret.add(this.markToString());
        }
        return ret;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getActivityUrl() {
        return this.activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCurrentActivity() {
        return this.currentActivity;
    }

    public void setCurrentActivity(String currentActivity) {
        this.currentActivity = currentActivity;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startTime) {
        this.startDate = startTime;
    }
}

