/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.dto;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import org.lamsfoundation.lams.gradebook.util.GBGridView;

public abstract class GradebookGridRowDTO {
    protected static final String CELL_EMPTY = "-";
    protected static final DateFormat DEFAULT_DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    protected String id;
    protected String rowName;
    protected Long timeTaken;
    protected Long averageTimeTaken;
    protected Double mark;
    protected Double averageMark;
    protected Long marksAvailable;
    protected String status;
    protected String feedback;

    public abstract ArrayList<String> toStringArray(GBGridView var1);

    protected String convertTimeToString(Long timeInMillis) {
        StringBuilder sb = new StringBuilder();
        if (timeInMillis != null && timeInMillis > 1000L) {
            long totalTimeInSeconds = timeInMillis / 1000L;
            long seconds = totalTimeInSeconds >= 60L ? totalTimeInSeconds % 60L : totalTimeInSeconds;
            long minutes = (totalTimeInSeconds /= 60L) >= 60L ? totalTimeInSeconds % 60L : totalTimeInSeconds;
            long hours = (totalTimeInSeconds /= 60L) >= 24L ? totalTimeInSeconds % 24L : totalTimeInSeconds;
            long days = totalTimeInSeconds /= 24L;
            if (days != 0L) {
                sb.append("" + days + "d, ");
            }
            if (hours != 0L) {
                sb.append("" + hours + "h, ");
            }
            if (minutes != 0L) {
                sb.append("" + minutes + "m, ");
            }
            if (seconds != 0L) {
                sb.append("" + seconds + "s");
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    protected String convertDateToString(Date date, DateFormat format) {
        if (date != null) {
            DateFormat usedFormat = format == null ? DEFAULT_DATE_FORMAT : format;
            return usedFormat.format(date);
        }
        return null;
    }

    protected String markToString() {
        if (this.mark != null) {
            String markStr = new DecimalFormat("##0.00").format(this.mark);
            if (this.marksAvailable != null) {
                return "<font color='green'>" + markStr + "/" + this.marksAvailable.toString() + "</font>";
            }
            return markStr;
        }
        if (this.marksAvailable != null) {
            return "<font color='red'>-/" + this.marksAvailable.toString() + "</font>";
        }
        return CELL_EMPTY;
    }

    protected String averageMarkToString() {
        if (this.averageMark != null) {
            String avgStr = new DecimalFormat("##0.00").format(this.averageMark);
            if (this.marksAvailable != null) {
                return avgStr + "/" + this.marksAvailable.toString();
            }
            return avgStr;
        }
        return CELL_EMPTY;
    }

    protected String toItalic(String string) {
        return "<i>" + string + "</i>";
    }

    public Long getTimeTaken() {
        return this.timeTaken;
    }

    public Long getTimeTakenSeconds() {
        if (this.timeTaken != null) {
            return this.timeTaken / 1000L;
        }
        return null;
    }

    public void setTimeTaken(Long timeTaken) {
        this.timeTaken = timeTaken;
    }

    public Double getMark() {
        return this.mark;
    }

    public void setMark(Double mark) {
        this.mark = mark;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRowName() {
        return this.rowName;
    }

    public void setRowName(String rowName) {
        this.rowName = rowName;
    }

    public Long getAverageTimeTaken() {
        return this.averageTimeTaken;
    }

    public Long getAverageTimeTakenSeconds() {
        if (this.averageTimeTaken != null) {
            return this.averageTimeTaken / 1000L;
        }
        return null;
    }

    public void setAverageTimeTaken(Long averageTimeTaken) {
        this.averageTimeTaken = averageTimeTaken;
    }

    public Double getAverageMark() {
        return this.averageMark;
    }

    public void setAverageMark(Double averageMark) {
        this.averageMark = averageMark;
    }

    public Long getMarksAvailable() {
        return this.marksAvailable;
    }

    public void setMarksAvailable(Long marksAvailable) {
        this.marksAvailable = marksAvailable;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }
}

