/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.service;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.gradebook.GradebookUserActivity;
import org.lamsfoundation.lams.gradebook.GradebookUserLesson;
import org.lamsfoundation.lams.gradebook.dao.IGradebookDAO;
import org.lamsfoundation.lams.gradebook.dto.GBActivityGridRowDTO;
import org.lamsfoundation.lams.gradebook.dto.GBLessonGridRowDTO;
import org.lamsfoundation.lams.gradebook.dto.GBUserGridRowDTO;
import org.lamsfoundation.lams.gradebook.dto.GradebookGridRowDTO;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.gradebook.util.LessonComparator;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.lesson.CompletedActivityProgress;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.tool.OutputType;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.ExcelCell;
import org.lamsfoundation.lams.util.MessageService;

public class GradebookService
implements IGradebookService {
    private static Logger logger = Logger.getLogger(GradebookService.class);
    private static final ExcelCell[] EMPTY_ROW = new ExcelCell[4];
    private ILamsCoreToolService toolService;
    private IGradebookDAO gradebookDAO;
    private ILessonService lessonService;
    private IUserManagementService userService;
    private IBaseDAO baseDAO;
    private IActivityDAO activityDAO;
    private MessageService messageService;

    @Override
    public List<GradebookGridRowDTO> getGBActivityRowsForLearner(Lesson lesson, User learner) {
        logger.debug((Object)("Getting gradebook user data for lesson: " + lesson.getLessonId() + ". For user: " + learner.getUserId()));
        ArrayList<GradebookGridRowDTO> gradebookActivityDTOs = new ArrayList<GradebookGridRowDTO>();
        Set<ToolActivity> activities = this.getLessonActivities(lesson);
        for (ToolActivity activity : activities) {
            byte activityState;
            Group group;
            String groupName = null;
            Long groupId = null;
            if (activity.getGrouping() != null && (group = activity.getGroupFor(learner)) != null) {
                groupName = group.getGroupName();
                groupId = group.getGroupId();
            }
            GBActivityGridRowDTO activityDTO = new GBActivityGridRowDTO(activity, groupName, groupId);
            activityDTO.setMarksAvailable(this.getTotalMarksAvailable(activity));
            GradebookUserActivity gradebookActivity = this.gradebookDAO.getGradebookUserDataForActivity(activity.getActivityId(), learner.getUserId());
            if (gradebookActivity != null) {
                activityDTO.setMark(gradebookActivity.getMark());
                activityDTO.setFeedback(gradebookActivity.getFeedback());
            }
            LearnerProgress learnerProgress = this.lessonService.getUserProgressForLesson(learner.getUserId(), lesson.getLessonId());
            activityDTO.setStartDate(this.getActivityStartDate(learnerProgress, (Activity)activity, learner.getTimeZone()));
            activityDTO.setTimeTaken(this.getActivityDuration(learnerProgress, (Activity)activity));
            activityDTO.setStatus(this.getActivityStatusStr(learnerProgress, (Activity)activity));
            activityDTO.setAverageMark(this.gradebookDAO.getAverageMarkForActivity(activity.getActivityId()));
            activityDTO.setAverageTimeTaken(this.gradebookDAO.getAverageDurationForActivity(activity.getActivityId()));
            ToolSession toolSession = this.toolService.getToolSessionByLearner(learner, (Activity)activity);
            if (toolSession != null && learnerProgress != null && ((activityState = learnerProgress.getProgressState((Activity)activity)) == 2 || activityState == 1)) {
                activityDTO.setActivityUrl(Configuration.get((String)ConfigurationKeys.SERVER_URL) + activity.getTool().getLearnerProgressUrl() + "&userID=" + learner.getUserId() + "&toolSessionID=" + toolSession.getToolSessionId().toString());
                activityDTO.setOutput(this.getToolOutputsStr(activity, toolSession, learner));
            }
            gradebookActivityDTOs.add(activityDTO);
        }
        return gradebookActivityDTOs;
    }

    @Override
    public List<GradebookGridRowDTO> getGBActivityRowsForLesson(Lesson lesson) {
        logger.debug((Object)("Getting gradebook data for lesson: " + lesson.getLessonId()));
        ArrayList<GradebookGridRowDTO> gradebookActivityDTOs = new ArrayList<GradebookGridRowDTO>();
        Set<ToolActivity> activities = this.getLessonActivities(lesson);
        for (ToolActivity activity : activities) {
            Grouping grouping = activity.getGrouping();
            if (grouping != null) {
                Set groups = grouping.getGroups();
                if (groups == null) continue;
                for (Group group : groups) {
                    GBActivityGridRowDTO activityDTO = this.getGradebookActivityDTO(activity, lesson, group.getGroupName(), group.getGroupId());
                    gradebookActivityDTOs.add(activityDTO);
                }
                continue;
            }
            GBActivityGridRowDTO activityDTO = this.getGradebookActivityDTO(activity, lesson, null, null);
            gradebookActivityDTOs.add(activityDTO);
        }
        return gradebookActivityDTOs;
    }

    @Override
    public List<GBUserGridRowDTO> getGBUserRowsForActivity(Lesson lesson, ToolActivity activity, Long groupId) {
        Group group;
        ArrayList<GBUserGridRowDTO> gradebookUserDTOs = new ArrayList<GBUserGridRowDTO>();
        Set learners = null;
        learners = groupId != null ? ((group = (Group)this.userService.findById(Group.class, (Serializable)groupId)) != null ? group.getUsers() : lesson.getAllLearners()) : lesson.getAllLearners();
        if (learners != null) {
            Map<Integer, LearnerProgress> userToLearnerProgressMap = this.getUserToLearnerProgressMap(lesson);
            Map<Integer, GradebookUserActivity> userToGradebookUserLessonMap = this.getUserToGradebookUserActivityMap((Activity)activity);
            Long totalMarksAvailable = this.getTotalMarksAvailable(activity);
            for (User learner : learners) {
                GradebookUserActivity gradebookUserActivity;
                byte activityState;
                GBUserGridRowDTO gUserDTO = new GBUserGridRowDTO(learner);
                gUserDTO.setMarksAvailable(totalMarksAvailable);
                LearnerProgress learnerProgress = userToLearnerProgressMap.get(learner.getUserId());
                gUserDTO.setStatus(this.getActivityStatusStr(learnerProgress, (Activity)activity));
                gUserDTO.setStartDate(this.getActivityStartDate(learnerProgress, (Activity)activity, learner.getTimeZone()));
                gUserDTO.setTimeTaken(this.getActivityDuration(learnerProgress, (Activity)activity));
                ToolSession toolSession = this.toolService.getToolSessionByLearner(learner, (Activity)activity);
                if (toolSession != null && learnerProgress != null && ((activityState = learnerProgress.getProgressState((Activity)activity)) == 2 || activityState == 1)) {
                    gUserDTO.setActivityUrl(Configuration.get((String)ConfigurationKeys.SERVER_URL) + activity.getTool().getLearnerProgressUrl() + "&userID=" + learner.getUserId() + "&toolSessionID=" + toolSession.getToolSessionId().toString());
                    gUserDTO.setOutput(this.getToolOutputsStr(activity, toolSession, learner));
                }
                if ((gradebookUserActivity = userToGradebookUserLessonMap.get(learner.getUserId())) != null) {
                    gUserDTO.setFeedback(gradebookUserActivity.getFeedback());
                    gUserDTO.setMark(gradebookUserActivity.getMark());
                }
                gradebookUserDTOs.add(gUserDTO);
            }
        }
        return gradebookUserDTOs;
    }

    public ArrayList<GBUserGridRowDTO> getGBUserRowsForLesson(Lesson lesson) {
        Set learners;
        ArrayList<GBUserGridRowDTO> gradebookUserDTOs = new ArrayList<GBUserGridRowDTO>();
        if (lesson != null && (learners = lesson.getAllLearners()) != null) {
            Map<Integer, LearnerProgress> userToLearnerProgressMap = this.getUserToLearnerProgressMap(lesson);
            Map<Integer, GradebookUserLesson> userToGradebookUserLessonMap = this.getUserToGradebookUserLessonMap(lesson);
            for (User learner : learners) {
                GradebookUserLesson gradebookUserLesson;
                LearnerProgress learnerProgress = userToLearnerProgressMap.get(learner.getUserId());
                GBUserGridRowDTO gradebookUserDTO = new GBUserGridRowDTO(learner);
                gradebookUserDTO.setStatus(this.getLessonStatusStr(learnerProgress));
                if (learnerProgress != null && learnerProgress.getCurrentActivity() != null) {
                    gradebookUserDTO.setCurrentActivity(learnerProgress.getCurrentActivity().getTitle());
                }
                if (learnerProgress != null && learnerProgress.getStartDate() != null && learnerProgress.getFinishDate() != null) {
                    gradebookUserDTO.setTimeTaken(learnerProgress.getFinishDate().getTime() - learnerProgress.getStartDate().getTime());
                }
                if ((gradebookUserLesson = userToGradebookUserLessonMap.get(learner.getUserId())) != null) {
                    gradebookUserDTO.setMark(gradebookUserLesson.getMark());
                    gradebookUserDTO.setFeedback(gradebookUserLesson.getFeedback());
                }
                gradebookUserDTOs.add(gradebookUserDTO);
            }
        }
        return gradebookUserDTOs;
    }

    @Override
    public ArrayList<GBUserGridRowDTO> getGBUserRowsForOrganisation(Organisation organisation) {
        List learners;
        ArrayList<GBUserGridRowDTO> gradebookUserDTOs = new ArrayList<GBUserGridRowDTO>();
        if (organisation != null && (learners = this.userService.getUsersFromOrganisation(organisation.getOrganisationId())) != null) {
            for (User learner : learners) {
                GBUserGridRowDTO gradebookUserDTO = new GBUserGridRowDTO(learner);
                gradebookUserDTOs.add(gradebookUserDTO);
            }
        }
        return gradebookUserDTOs;
    }

    @Override
    public GradebookUserLesson getGradebookUserLesson(Long lessonID, Integer userID) {
        return this.gradebookDAO.getGradebookUserDataForLesson(lessonID, userID);
    }

    @Override
    public GradebookUserActivity getGradebookUserActivity(Long activityID, Integer userID) {
        return this.gradebookDAO.getGradebookUserDataForActivity(activityID, userID);
    }

    @Override
    public Double getAverageMarkForActivity(Long activityID) {
        return this.gradebookDAO.getAverageMarkForActivity(activityID);
    }

    @Override
    public Double getAverageMarkForLesson(Long lessonID) {
        return this.gradebookDAO.getAverageMarkForLesson(lessonID);
    }

    @Override
    public void updateUserLessonGradebookMark(Lesson lesson, User learner, Double mark) {
        if (lesson != null && learner != null) {
            GradebookUserLesson gradebookUserLesson = this.gradebookDAO.getGradebookUserDataForLesson(lesson.getLessonId(), learner.getUserId());
            if (gradebookUserLesson == null) {
                gradebookUserLesson = new GradebookUserLesson(lesson, learner);
            }
            gradebookUserLesson.setMark(mark);
            this.gradebookDAO.insertOrUpdate((Object)gradebookUserLesson);
        }
    }

    @Override
    public void updateUserActivityGradebookMark(Lesson lesson, User learner, Activity activity, Double mark, Boolean markedInGradebook) {
        if (lesson != null && activity != null && learner != null && activity.isToolActivity()) {
            GradebookUserActivity gradebookUserActivity = this.gradebookDAO.getGradebookUserDataForActivity(activity.getActivityId(), learner.getUserId());
            if (gradebookUserActivity == null) {
                gradebookUserActivity = new GradebookUserActivity((ToolActivity)activity, learner);
            }
            gradebookUserActivity.setMark(mark);
            gradebookUserActivity.setMarkedInGradebook(markedInGradebook);
            this.gradebookDAO.insertOrUpdate((Object)gradebookUserActivity);
            GradebookUserLesson gradebookUserLesson = this.gradebookDAO.getGradebookUserDataForLesson(lesson.getLessonId(), learner.getUserId());
            if (gradebookUserLesson == null) {
                gradebookUserLesson = new GradebookUserLesson();
                gradebookUserLesson.setLearner(learner);
                gradebookUserLesson.setLesson(lesson);
            }
            this.aggregateTotalMarkForLesson(gradebookUserLesson);
        }
    }

    @Override
    public void updateUserLessonGradebookFeedback(Lesson lesson, User learner, String feedback) {
        GradebookUserLesson gradebookUserLesson = this.gradebookDAO.getGradebookUserDataForLesson(lesson.getLessonId(), learner.getUserId());
        if (gradebookUserLesson == null) {
            gradebookUserLesson = new GradebookUserLesson(lesson, learner);
        }
        gradebookUserLesson.setFeedback(feedback);
        this.gradebookDAO.insertOrUpdate((Object)gradebookUserLesson);
    }

    @Override
    public void updateUserActivityGradebookFeedback(Activity activity, User learner, String feedback) {
        GradebookUserActivity gradebookUserActivity = this.gradebookDAO.getGradebookUserDataForActivity(activity.getActivityId(), learner.getUserId());
        if (gradebookUserActivity == null) {
            gradebookUserActivity = new GradebookUserActivity((ToolActivity)activity, learner);
        }
        gradebookUserActivity.setFeedback(feedback);
        this.gradebookDAO.insertOrUpdate((Object)gradebookUserActivity);
    }

    @Override
    public List<GBLessonGridRowDTO> getGBLessonRows(Organisation organisation, User user, User viewer, GBGridView view) {
        ArrayList<GBLessonGridRowDTO> lessonRows = new ArrayList<GBLessonGridRowDTO>();
        if (organisation != null) {
            List lessons = this.lessonService.getLessonsByGroupAndUser(user.getUserId(), organisation.getOrganisationId());
            if (lessons != null) {
                for (Lesson lesson : lessons) {
                    Integer organisationToCheckPermission = organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE) ? organisation.getOrganisationId() : organisation.getParentOrganisation().getOrganisationId();
                    boolean hasTeacherPermission = lesson.getLessonClass().isStaffMember(viewer) || this.userService.isUserInRole(viewer.getUserId(), organisationToCheckPermission, "GROUP MANAGER");
                    boolean marksReleased = lesson.getMarksReleased() != null && lesson.getMarksReleased() != false;
                    boolean hasLearnerPermission = lesson.getAllLearners().contains(user);
                    if (!(view == GBGridView.MON_COURSE && hasTeacherPermission || view == GBGridView.LRN_COURSE && hasLearnerPermission && marksReleased || view == GBGridView.MON_USER && hasTeacherPermission && hasLearnerPermission)) continue;
                    GBLessonGridRowDTO lessonRow = new GBLessonGridRowDTO();
                    lessonRow.setLessonName(lesson.getLessonName());
                    lessonRow.setId(lesson.getLessonId().toString());
                    lessonRow.setStartDate(this.getLocaleDateString(viewer, lesson.getStartDateTime()));
                    if (view == GBGridView.MON_COURSE) {
                        lessonRow.setAverageTimeTaken(this.gradebookDAO.getAverageDurationLesson(lesson.getLessonId()));
                        lessonRow.setAverageMark(this.gradebookDAO.getAverageMarkForLesson(lesson.getLessonId()));
                        String gbMonURL = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "gradebook/gradebookMonitoring.do?lessonID=" + lesson.getLessonId().toString();
                        lessonRow.setGradebookMonitorURL(gbMonURL);
                    } else if (view == GBGridView.LRN_COURSE || view == GBGridView.MON_USER) {
                        GradebookUserLesson gbLesson = this.gradebookDAO.getGradebookUserDataForLesson(lesson.getLessonId(), user.getUserId());
                        lessonRow.setAverageTimeTaken(this.gradebookDAO.getAverageDurationLesson(lesson.getLessonId()));
                        lessonRow.setAverageMark(this.gradebookDAO.getAverageMarkForLesson(lesson.getLessonId()));
                        if (gbLesson != null) {
                            lessonRow.setMark(gbLesson.getMark());
                            lessonRow.setFeedback(gbLesson.getFeedback());
                        }
                        LearnerProgress learnerProgress = this.lessonService.getUserProgressForLesson(user.getUserId(), lesson.getLessonId());
                        lessonRow.setStatus(this.getLessonStatusStr(learnerProgress));
                        if (learnerProgress != null) {
                            if (learnerProgress.getStartDate() != null && learnerProgress.getFinishDate() != null) {
                                lessonRow.setTimeTaken(learnerProgress.getFinishDate().getTime() - learnerProgress.getStartDate().getTime());
                            }
                            lessonRow.setFinishDate(this.getLocaleDateString(user, learnerProgress.getFinishDate()));
                        }
                    }
                    if (lesson.getOrganisation().getOrganisationId() != organisation.getOrganisationId()) {
                        lessonRow.setSubGroup(lesson.getOrganisation().getName());
                    } else {
                        lessonRow.setSubGroup("");
                    }
                    lessonRows.add(lessonRow);
                }
            }
        } else {
            logger.error((Object)"Request for gradebook grid with a null organisation");
        }
        return lessonRows;
    }

    private HashMap<ToolActivity, List<GBUserGridRowDTO>> getDataForLessonGradebookExport(Lesson lesson) {
        HashMap<ToolActivity, List<GBUserGridRowDTO>> activityToUserDTOMap = new HashMap<ToolActivity, List<GBUserGridRowDTO>>();
        TreeSet learners = lesson.getAllLearners();
        if (learners == null) {
            learners = new TreeSet();
        }
        Map<Integer, LearnerProgress> userToLearnerProgressMap = this.getUserToLearnerProgressMap(lesson);
        List toolSessions = this.toolService.getToolSessionsByLesson(lesson);
        Set<ToolActivity> activities = this.getLessonActivities(lesson);
        Map<Long, Long> activityToTotalMarkMap = this.getActivityToTotalMarkMap(activities);
        for (ToolActivity activity : activities) {
            Map<Integer, GradebookUserActivity> userToGradebookUserActivityMap = this.getUserToGradebookUserActivityMap((Activity)activity);
            ArrayList<GBUserGridRowDTO> userDTOs = new ArrayList<GBUserGridRowDTO>();
            for (User learner : learners) {
                GradebookUserActivity gradebookUserActivity;
                byte activityState;
                GBUserGridRowDTO userDTO = new GBUserGridRowDTO(learner);
                Long activityTotalMarks = activityToTotalMarkMap.get(activity.getActivityId());
                userDTO.setMarksAvailable(activityTotalMarks);
                LearnerProgress learnerProgress = userToLearnerProgressMap.get(learner.getUserId());
                userDTO.setTimeTaken(this.getActivityDuration(learnerProgress, (Activity)activity));
                ToolSession toolSession = null;
                for (ToolSession dbToolSession : toolSessions) {
                    if (!dbToolSession.getToolActivity().getActivityId().equals(activity.getActivityId()) || !dbToolSession.getLearners().contains(learner)) continue;
                    toolSession = dbToolSession;
                }
                if (toolSession != null && learnerProgress != null && ((activityState = learnerProgress.getProgressState((Activity)activity)) == 2 || activityState == 1)) {
                    userDTO.setActivityUrl(Configuration.get((String)ConfigurationKeys.SERVER_URL) + activity.getTool().getLearnerProgressUrl() + "&userID=" + learner.getUserId() + "&toolSessionID=" + toolSession.getToolSessionId().toString());
                    userDTO.setOutput(this.getToolOutputsStr(activity, toolSession, learner));
                }
                if ((gradebookUserActivity = userToGradebookUserActivityMap.get(learner.getUserId())) != null) {
                    userDTO.setFeedback(gradebookUserActivity.getFeedback());
                    userDTO.setMark(gradebookUserActivity.getMark());
                }
                userDTOs.add(userDTO);
            }
            activityToUserDTOMap.put(activity, userDTOs);
        }
        return activityToUserDTOMap;
    }

    @Override
    public LinkedHashMap<String, ExcelCell[][]> exportLessonGradebook(Lesson lesson) {
        LinkedHashMap<String, ExcelCell[][]> dataToExport = new LinkedHashMap<String, ExcelCell[][]>();
        LinkedList<ExcelCell[]> rowList = new LinkedList<ExcelCell[]>();
        ExcelCell[] lessonAverageMark = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.average.lesson.mark"), Boolean.valueOf(true)), new ExcelCell((Object)this.getAverageMarkForLesson(lesson.getLessonId()), Boolean.valueOf(false))};
        rowList.add(lessonAverageMark);
        ExcelCell[] lessonAverageTimeTaken = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.average.lesson.time.taken"), Boolean.valueOf(true)), new ExcelCell((Object)(this.gradebookDAO.getAverageDurationLesson(lesson.getLessonId()) / 1000L), Boolean.valueOf(false))};
        rowList.add(lessonAverageTimeTaken);
        rowList.add(EMPTY_ROW);
        List<GradebookGridRowDTO> activityRows = this.getGBActivityRowsForLesson(lesson);
        ExcelCell[] activityAverageTitle = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.activities"), Boolean.valueOf(true))};
        rowList.add(activityAverageTitle);
        ExcelCell[] activityAverageRow = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.activity"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.columntitle.competences"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.average.time.taken.seconds"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.columntitle.averageMark"), Boolean.valueOf(true))};
        rowList.add(activityAverageRow);
        for (GBActivityGridRowDTO gBActivityGridRowDTO : activityRows) {
            ExcelCell[] activityDataRow = new ExcelCell[]{new ExcelCell((Object)gBActivityGridRowDTO.getRowName(), Boolean.valueOf(false)), new ExcelCell((Object)gBActivityGridRowDTO.getCompetences(), Boolean.valueOf(false)), new ExcelCell((Object)gBActivityGridRowDTO.getAverageTimeTakenSeconds(), Boolean.valueOf(false)), new ExcelCell((Object)gBActivityGridRowDTO.getAverageMark(), Boolean.valueOf(false))};
            rowList.add(activityDataRow);
        }
        rowList.add(EMPTY_ROW);
        ExcelCell[] excelCellArray = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.total.marks.for.lesson"), Boolean.valueOf(true))};
        rowList.add(excelCellArray);
        List userRows = this.getGBUserRowsForLesson(lesson);
        ExcelCell[] userTitleRow = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.last.name"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.first.name"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.exportcourse.progress"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.time.taken.seconds"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.total.mark"), Boolean.valueOf(true))};
        rowList.add(userTitleRow);
        for (GBUserGridRowDTO userRow : userRows) {
            ExcelCell[] userDataRow = new ExcelCell[]{new ExcelCell((Object)userRow.getLastName(), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getFirstName(), Boolean.valueOf(false)), new ExcelCell((Object)this.getProgressMessage(userRow), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getTimeTakenSeconds(), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getMark(), Boolean.valueOf(false))};
            rowList.add(userDataRow);
        }
        ExcelCell[][] summaryData = (ExcelCell[][])rowList.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.getMessage("gradebook.export.lesson.summary"), summaryData);
        HashMap<ToolActivity, List<GBUserGridRowDTO>> activityToUserDTOMap = this.getDataForLessonGradebookExport(lesson);
        LinkedList<ExcelCell[]> rowList1 = new LinkedList<ExcelCell[]>();
        for (ToolActivity activity : activityToUserDTOMap.keySet()) {
            ExcelCell[] activityTitleRow = new ExcelCell[5];
            activityTitleRow[0] = new ExcelCell((Object)activity.getTitle(), Boolean.valueOf(true));
            rowList1.add(activityTitleRow);
            ExcelCell[] titleRow = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.last.name"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.first.name"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.time.taken.seconds"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.outputs"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.columntitle.mark"), Boolean.valueOf(true))};
            rowList1.add(titleRow);
            List<GBUserGridRowDTO> userRows2 = activityToUserDTOMap.get(activity);
            for (GBUserGridRowDTO userRow : userRows2) {
                ExcelCell[] userDataRow = new ExcelCell[]{new ExcelCell((Object)userRow.getLastName(), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getFirstName(), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getTimeTakenSeconds(), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getOutput(), Boolean.valueOf(false)), new ExcelCell((Object)userRow.getMark(), Boolean.valueOf(false))};
                rowList1.add(userDataRow);
            }
            rowList1.add(EMPTY_ROW);
        }
        ExcelCell[][] activityData = (ExcelCell[][])rowList1.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.getMessage("gradebook.gridtitle.activitygrid"), activityData);
        TreeSet learners = lesson.getAllLearners();
        if (learners == null) {
            learners = new TreeSet();
        }
        LinkedList<ExcelCell[]> rowList2 = new LinkedList<ExcelCell[]>();
        for (User learner : learners) {
            ArrayList<GBActivityGridRowDTO> activityDTOs = new ArrayList<GBActivityGridRowDTO>();
            for (ToolActivity activity : activityToUserDTOMap.keySet()) {
                Group group;
                List<GBUserGridRowDTO> userDTOs = activityToUserDTOMap.get(activity);
                GBUserGridRowDTO userDTO = null;
                for (GBUserGridRowDTO dbUserDTO : userDTOs) {
                    if (!dbUserDTO.getId().equals(learner.getUserId().toString())) continue;
                    userDTO = dbUserDTO;
                }
                String groupName = null;
                Long groupId = null;
                if (activity.getGrouping() != null && (group = activity.getGroupFor(learner)) != null) {
                    groupName = group.getGroupName();
                    groupId = group.getGroupId();
                }
                GBActivityGridRowDTO activityDTO = new GBActivityGridRowDTO(activity, groupName, groupId);
                activityDTO.setMarksAvailable(userDTO.getMarksAvailable());
                activityDTO.setStatus(userDTO.getStatus());
                activityDTO.setStartDate(userDTO.getStartDate());
                activityDTO.setTimeTaken(userDTO.getTimeTaken());
                activityDTO.setActivityUrl(userDTO.getActivityUrl());
                activityDTO.setOutput(userDTO.getOutput());
                activityDTO.setFeedback(userDTO.getFeedback());
                activityDTO.setMark(userDTO.getMark());
                activityDTOs.add(activityDTO);
            }
            ExcelCell[] activityTitleRow = new ExcelCell[4];
            activityTitleRow[0] = new ExcelCell((Object)learner.getFullName(), Boolean.valueOf(true));
            rowList2.add(activityTitleRow);
            ExcelCell[] titleRow = new ExcelCell[]{new ExcelCell((Object)this.getMessage("gradebook.export.activity"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.time.taken.seconds"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.export.outputs"), Boolean.valueOf(true)), new ExcelCell((Object)this.getMessage("gradebook.columntitle.mark"), Boolean.valueOf(true))};
            rowList2.add(titleRow);
            for (GBActivityGridRowDTO activityRow : activityDTOs) {
                ExcelCell[] activityDataRow = new ExcelCell[]{new ExcelCell((Object)activityRow.getRowName(), Boolean.valueOf(false)), new ExcelCell((Object)activityRow.getTimeTakenSeconds(), Boolean.valueOf(false)), new ExcelCell((Object)activityRow.getOutput(), Boolean.valueOf(false)), new ExcelCell((Object)activityRow.getMark(), Boolean.valueOf(false))};
                rowList2.add(activityDataRow);
            }
            rowList2.add(EMPTY_ROW);
        }
        ExcelCell[][] userData = (ExcelCell[][])rowList2.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.getMessage("gradebook.export.learner.view"), userData);
        return dataToExport;
    }

    @Override
    public LinkedHashMap<String, ExcelCell[][]> exportCourseGradebook(Integer userId, Integer organisationId) {
        LinkedHashMap<String, ExcelCell[][]> dataToExport = new LinkedHashMap<String, ExcelCell[][]>();
        Organisation organisation = (Organisation)this.userService.findById(Organisation.class, (Serializable)organisationId);
        LinkedList<ExcelCell[]> rowList = new LinkedList<ExcelCell[]>();
        User user = (User)this.userService.findById(User.class, (Serializable)userId);
        TreeSet<Lesson> lessonsFromDB = new TreeSet<Lesson>(new LessonComparator());
        lessonsFromDB.addAll(this.lessonService.getLessonsByGroupAndUser(userId, organisationId));
        Integer organisationToCheckPermission = organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE) ? organisation.getOrganisationId() : organisation.getParentOrganisation().getOrganisationId();
        LinkedList<Lesson> lessons = new LinkedList<Lesson>();
        for (Lesson lesson : lessonsFromDB) {
            if (!lesson.getLessonClass().isStaffMember(user) && !this.userService.isUserInRole(userId, organisationToCheckPermission, "GROUP MANAGER")) continue;
            lessons.add(lesson);
        }
        if (lessons != null && lessons.size() > 0) {
            LinkedHashSet allLearners = new LinkedHashSet();
            for (Lesson lesson : lessons) {
                Set dbLessonUsers = lesson.getAllLearners();
                allLearners.addAll(dbLessonUsers);
            }
            int numberOfCellsInARow = 2 + lessons.size() * 4;
            ExcelCell[] lessonsNames = new ExcelCell[numberOfCellsInARow];
            int i = 0;
            lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
            lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
            for (Lesson lesson : lessons) {
                lessonsNames[i++] = new ExcelCell((Object)this.messageService.getMessage("gradebook.exportcourse.lesson", new Object[]{lesson.getLessonName()}), Boolean.valueOf(true));
                lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
                lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
                lessonsNames[i++] = new ExcelCell((Object)"", Boolean.valueOf(false));
            }
            rowList.add(lessonsNames);
            ExcelCell[] headerRow = new ExcelCell[numberOfCellsInARow];
            i = 0;
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.last.name"), Boolean.valueOf(true));
            headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.first.name"), Boolean.valueOf(true));
            for (Lesson lesson : lessons) {
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.exportcourse.progress"), Boolean.valueOf(true));
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.time.taken.seconds"), Boolean.valueOf(true));
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.exportcourse.lessonFeedback"), Boolean.valueOf(true));
                headerRow[i++] = new ExcelCell((Object)this.getMessage("gradebook.export.total.mark"), Boolean.valueOf(true));
            }
            rowList.add(headerRow);
            for (User learner : allLearners) {
                List<GBUserGridRowDTO> userRows = this.getGBUserRowsForUser(learner, lessons, organisationId);
                i = 0;
                ExcelCell[] userDataRow = new ExcelCell[numberOfCellsInARow];
                userDataRow[i++] = new ExcelCell((Object)learner.getLastName(), Boolean.valueOf(false));
                userDataRow[i++] = new ExcelCell((Object)learner.getFirstName(), Boolean.valueOf(false));
                for (GBUserGridRowDTO userRow : userRows) {
                    userDataRow[i++] = new ExcelCell((Object)this.getProgressMessage(userRow), Boolean.valueOf(false));
                    userDataRow[i++] = new ExcelCell((Object)userRow.getTimeTakenSeconds(), Boolean.valueOf(false));
                    userDataRow[i++] = new ExcelCell((Object)userRow.getFeedback(), Boolean.valueOf(false));
                    userDataRow[i++] = new ExcelCell((Object)userRow.getMark(), Boolean.valueOf(false));
                }
                rowList.add(userDataRow);
            }
        }
        ExcelCell[][] summaryData = (ExcelCell[][])rowList.toArray((T[])new ExcelCell[0][]);
        dataToExport.put(this.getMessage("gradebook.exportcourse.course.summary"), summaryData);
        return dataToExport;
    }

    @Override
    public void updateActivityMark(Double mark, String feedback, Integer userID, Long toolSessionID, Boolean markedInGradebook) {
        ToolActivity activity;
        GradebookUserActivity gradebookUserActivity;
        ToolSession toolSession = this.toolService.getToolSessionById(toolSessionID);
        User learner = (User)this.userService.findById(User.class, (Serializable)userID);
        if (!(learner == null || toolSession == null || (gradebookUserActivity = this.getGradebookUserActivity((activity = toolSession.getToolActivity()).getActivityId(), userID)) != null && gradebookUserActivity.getMarkedInGradebook().booleanValue())) {
            this.updateUserActivityGradebookMark(toolSession.getLesson(), learner, (Activity)activity, mark, markedInGradebook);
        }
    }

    @Override
    public Activity getActivityById(Long activityID) {
        return this.activityDAO.getActivityByActivityId(activityID);
    }

    private Set<ToolActivity> getLessonActivities(Lesson lesson) {
        TreeSet<Activity> activities = new TreeSet<Activity>();
        TreeSet<ToolActivity> toolActivities = new TreeSet<ToolActivity>();
        Activity firstActivity = this.activityDAO.getActivityByActivityId(lesson.getLearningDesign().getFirstActivity().getActivityId());
        activities.add(firstActivity);
        activities.addAll(lesson.getLearningDesign().getActivities());
        for (Activity activity : activities) {
            if (!(activity instanceof ToolActivity)) continue;
            ToolActivity toolActivity = (ToolActivity)activity;
            toolActivities.add(toolActivity);
        }
        return toolActivities;
    }

    private List<GBUserGridRowDTO> getGBUserRowsForUser(User learner, List<Lesson> lessons, Integer organisationId) {
        LinkedList<GBUserGridRowDTO> gradebookUserDTOs = new LinkedList<GBUserGridRowDTO>();
        Map<Long, LearnerProgress> lessonLearnerProgressMap = this.getLessonToLearnerProgressMap(learner, organisationId);
        Map<Long, GradebookUserLesson> gradebookUserLessonMap = this.getLessonToGradebookUserLessonMap(learner, organisationId);
        for (Lesson lesson : lessons) {
            GBUserGridRowDTO gradebookUserDTO = new GBUserGridRowDTO(learner);
            if (lesson.getAllLearners().contains(learner)) {
                GradebookUserLesson gradebookUserLesson;
                LearnerProgress learnerProgress = lessonLearnerProgressMap.get(lesson.getLessonId());
                gradebookUserDTO.setStatus(this.getLessonStatusStr(learnerProgress));
                if (learnerProgress != null && learnerProgress.getCurrentActivity() != null) {
                    gradebookUserDTO.setCurrentActivity(learnerProgress.getCurrentActivity().getTitle());
                }
                if (learnerProgress != null && learnerProgress.getStartDate() != null && learnerProgress.getFinishDate() != null) {
                    gradebookUserDTO.setTimeTaken(learnerProgress.getFinishDate().getTime() - learnerProgress.getStartDate().getTime());
                }
                if ((gradebookUserLesson = gradebookUserLessonMap.get(lesson.getLessonId())) != null) {
                    gradebookUserDTO.setMark(gradebookUserLesson.getMark());
                    gradebookUserDTO.setFeedback(gradebookUserLesson.getFeedback());
                }
            } else {
                gradebookUserDTO.setStatus("n/a");
            }
            gradebookUserDTOs.add(gradebookUserDTO);
        }
        return gradebookUserDTOs;
    }

    private String getLocaleDateString(User user, Date date) {
        if (user == null || date == null) {
            return null;
        }
        Locale locale = new Locale(user.getLocale().getLanguageIsoCode(), user.getLocale().getCountryIsoCode());
        String dateStr = DateFormat.getDateTimeInstance(3, 2, locale).format(date);
        return dateStr;
    }

    private String getProgressMessage(GBUserGridRowDTO userRow) {
        String originalStatus = userRow.getStatus();
        String status = originalStatus.contains("tick.png") ? this.getMessage("gradebook.exportcourse.ok") : (originalStatus.contains("cog.png") ? this.getMessage("gradebook.exportcourse.current.activity", new String[]{userRow.getCurrentActivity()}) : originalStatus);
        return status;
    }

    private void aggregateTotalMarkForLesson(GradebookUserLesson gradebookUserLesson) {
        Double totalMark = this.gradebookDAO.getGradebookUserActivityMarkSum(gradebookUserLesson.getLesson().getLessonId(), gradebookUserLesson.getLearner().getUserId());
        gradebookUserLesson.setMark(totalMark);
        this.gradebookDAO.insertOrUpdate((Object)gradebookUserLesson);
    }

    private GBActivityGridRowDTO getGradebookActivityDTO(ToolActivity activity, Lesson lesson, String groupName, Long groupId) {
        GBActivityGridRowDTO activityDTO = new GBActivityGridRowDTO(activity, groupName, groupId);
        if (groupName != null && groupId != null) {
            activityDTO.setAverageMark(this.gradebookDAO.getAverageMarkForGroupedActivity(activity.getActivityId(), groupId));
            activityDTO.setAverageTimeTaken(this.gradebookDAO.getAverageDurationForGroupedActivity(activity.getActivityId(), groupId));
        } else {
            activityDTO.setAverageMark(this.gradebookDAO.getAverageMarkForActivity(activity.getActivityId()));
            activityDTO.setAverageTimeTaken(this.gradebookDAO.getAverageDurationForActivity(activity.getActivityId()));
        }
        activityDTO.setMarksAvailable(this.getTotalMarksAvailable(activity));
        String monitorUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL) + activity.getTool().getMonitorUrl() + "?" + "contentFolderID" + "=" + lesson.getLearningDesign().getContentFolderID() + "&" + "toolContentID" + "=" + activity.getToolContentId();
        activityDTO.setMonitorUrl(monitorUrl);
        return activityDTO;
    }

    private Date getActivityStartDate(LearnerProgress learnerProgress, Activity activity, String timeZone) {
        CompletedActivityProgress compProg;
        Date startDate = null;
        if (learnerProgress != null && (startDate = (Date)learnerProgress.getAttemptedActivities().get(activity)) == null && (compProg = (CompletedActivityProgress)learnerProgress.getCompletedActivities().get(activity)) != null) {
            startDate = compProg.getStartDate();
        }
        if (startDate != null) {
            if (StringUtils.isBlank((String)timeZone)) {
                logger.warn((Object)"No user time zone provided, leaving server default");
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Adjusting time according to zone \"" + timeZone + "\""));
                }
                TimeZone userTimeZone = TimeZone.getTimeZone(timeZone);
                startDate = DateUtil.convertToTimeZoneFromDefault((TimeZone)userTimeZone, (Date)startDate);
            }
        }
        return startDate;
    }

    private Long getActivityDuration(LearnerProgress learnerProgress, Activity activity) {
        CompletedActivityProgress compProg;
        if (learnerProgress != null && learnerProgress.getCompletedActivities().get(activity) != null && (compProg = (CompletedActivityProgress)learnerProgress.getCompletedActivities().get(activity)) != null) {
            Date startTime = compProg.getStartDate();
            Date endTime = compProg.getFinishDate();
            if (startTime != null && endTime != null) {
                return endTime.getTime() - startTime.getTime();
            }
        }
        return null;
    }

    private String getLessonStatusStr(LearnerProgress learnerProgress) {
        String status = "-";
        String IMAGES_DIR = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "images";
        if (learnerProgress != null) {
            if (learnerProgress.isComplete()) {
                status = "<img src='" + IMAGES_DIR + "/tick.png' />";
            } else if (learnerProgress.getAttemptedActivities() != null && learnerProgress.getAttemptedActivities().size() > 0) {
                status = "<img src='" + IMAGES_DIR + "/cog.png' title='" + learnerProgress.getCurrentActivity().getTitle() + "' />";
            }
        }
        return status;
    }

    private String getActivityStatusStr(LearnerProgress learnerProgress, Activity activity) {
        String IMAGES_DIR = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "images";
        if (learnerProgress != null) {
            byte statusByte = learnerProgress.getProgressState(activity);
            if (statusByte == 2) {
                return "<img src='" + IMAGES_DIR + "/cog.png' title='" + learnerProgress.getCurrentActivity().getTitle() + "' />";
            }
            if (statusByte == 1) {
                return "<img src='" + IMAGES_DIR + "/tick.png' />";
            }
        }
        return "-";
    }

    private String getToolOutputsStr(ToolActivity toolAct, ToolSession toolSession, User learner) {
        String toolOutputsStr = "";
        boolean noOutputs = true;
        if (toolAct != null && toolSession != null && learner != null) {
            SortedMap map = this.toolService.getOutputDefinitionsFromTool(toolAct.getToolContentId(), 1);
            HashSet<ToolOutput> toolOutputs = new HashSet<ToolOutput>();
            if (map.keySet().size() > 0) {
                for (String outputName : map.keySet()) {
                    try {
                        ToolOutput toolOutput = this.toolService.getOutputFromTool(outputName, toolSession, learner.getUserId());
                        if (toolOutput == null || toolOutput.getValue().getType() == OutputType.OUTPUT_COMPLEX) continue;
                        toolOutputs.add(toolOutput);
                        toolOutputsStr = toolOutputsStr + toolOutput.getDescription() + ": " + toolOutput.getValue().getString();
                        toolOutputsStr = toolOutputsStr + "<br />";
                        noOutputs = false;
                    }
                    catch (RuntimeException e) {
                        logger.debug((Object)("Runtime exception when attempted to get outputs for activity: " + toolAct.getActivityId() + ", continuing for other activities"), (Throwable)e);
                    }
                }
            }
        }
        if (noOutputs) {
            toolOutputsStr = "-";
        }
        return toolOutputsStr;
    }

    private Long getTotalMarksAvailable(ToolActivity activity) {
        SortedMap map = this.toolService.getOutputDefinitionsFromTool(activity.getToolContentId(), 1);
        Set actEvals = activity.getActivityEvaluations();
        if (map != null) {
            for (String key : map.keySet()) {
                ToolOutputDefinition definition = (ToolOutputDefinition)map.get(key);
                if (actEvals != null && actEvals.size() > 0) {
                    ActivityEvaluation actEval = (ActivityEvaluation)actEvals.iterator().next();
                    if (!actEval.getToolOutputDefinition().equals(key)) continue;
                    Object upperLimit = definition.getEndValue();
                    if (upperLimit == null || !(upperLimit instanceof Long)) break;
                    return (Long)upperLimit;
                }
                if (definition.isDefaultGradebookMark() == null || !definition.isDefaultGradebookMark().booleanValue()) continue;
                Object upperLimit = definition.getEndValue();
                if (upperLimit == null || !(upperLimit instanceof Long)) break;
                return (Long)upperLimit;
            }
        }
        return null;
    }

    private Map<Integer, LearnerProgress> getUserToLearnerProgressMap(Lesson lesson) {
        List learnerProgressList;
        if (lesson != null && (learnerProgressList = this.lessonService.getUserProgressForLesson(lesson.getLessonId())) != null && learnerProgressList.size() > 0) {
            HashMap<Integer, LearnerProgress> map = new HashMap<Integer, LearnerProgress>();
            for (LearnerProgress learnerProgress : learnerProgressList) {
                map.put(learnerProgress.getUser().getUserId(), learnerProgress);
            }
            return map;
        }
        return new HashMap<Integer, LearnerProgress>();
    }

    private Map<Integer, GradebookUserActivity> getUserToGradebookUserActivityMap(Activity activity) {
        List gradebookUserActivities;
        if (activity != null && (gradebookUserActivities = this.gradebookDAO.getAllGradebookUserActivitiesForActivity(activity.getActivityId())) != null && gradebookUserActivities.size() > 0) {
            HashMap<Integer, GradebookUserActivity> map = new HashMap<Integer, GradebookUserActivity>();
            for (GradebookUserActivity gradebookUserActivity : gradebookUserActivities) {
                map.put(gradebookUserActivity.getLearner().getUserId(), gradebookUserActivity);
            }
            return map;
        }
        return new HashMap<Integer, GradebookUserActivity>();
    }

    private Map<Long, Long> getActivityToTotalMarkMap(Collection<ToolActivity> activities) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (ToolActivity activity : activities) {
            map.put(activity.getActivityId(), this.getTotalMarksAvailable(activity));
        }
        return map;
    }

    private Map<Long, LearnerProgress> getLessonToLearnerProgressMap(User user, Integer organisationId) {
        String query;
        List learnerProgressList;
        if (user != null && (learnerProgressList = this.baseDAO.find(query = "select lp from LearnerProgress lp where lp.user.userId=? and (lp.lesson.organisation.organisationId=? or lp.lesson.organisation.parentOrganisation.organisationId=?)", new Object[]{user.getUserId(), organisationId, organisationId})) != null && learnerProgressList.size() > 0) {
            HashMap<Long, LearnerProgress> map = new HashMap<Long, LearnerProgress>();
            for (LearnerProgress learnerProgress : learnerProgressList) {
                map.put(learnerProgress.getLesson().getLessonId(), learnerProgress);
            }
            return map;
        }
        return new HashMap<Long, LearnerProgress>();
    }

    private Map<Integer, GradebookUserLesson> getUserToGradebookUserLessonMap(Lesson lesson) {
        String query;
        List gradebookUserLessons;
        if (lesson != null && (gradebookUserLessons = this.baseDAO.find(query = "select ul from GradebookUserLesson ul where ul.lesson.lessonId=?", new Object[]{lesson.getLessonId()})) != null && gradebookUserLessons.size() > 0) {
            HashMap<Integer, GradebookUserLesson> map = new HashMap<Integer, GradebookUserLesson>();
            for (GradebookUserLesson gradebookUserLesson : gradebookUserLessons) {
                map.put(gradebookUserLesson.getLearner().getUserId(), gradebookUserLesson);
            }
            return map;
        }
        return new HashMap<Integer, GradebookUserLesson>();
    }

    private Map<Long, GradebookUserLesson> getLessonToGradebookUserLessonMap(User user, Integer organisationId) {
        String query;
        List gradebookUserLessons;
        if (user != null && (gradebookUserLessons = this.baseDAO.find(query = "select ul from GradebookUserLesson ul where ul.learner.userId=? and (ul.lesson.organisation.organisationId=? or ul.lesson.organisation.parentOrganisation.organisationId=?)", new Object[]{user.getUserId(), organisationId, organisationId})) != null && gradebookUserLessons.size() > 0) {
            HashMap<Long, GradebookUserLesson> map = new HashMap<Long, GradebookUserLesson>();
            for (GradebookUserLesson gradebookUserLesson : gradebookUserLessons) {
                map.put(gradebookUserLesson.getLesson().getLessonId(), gradebookUserLesson);
            }
            return map;
        }
        return new HashMap<Long, GradebookUserLesson>();
    }

    @Override
    public String getMessage(String key) {
        return this.messageService.getMessage(key);
    }

    public String getMessage(String key, Object[] args) {
        return this.messageService.getMessage(key, args);
    }

    public ILamsCoreToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsCoreToolService toolService) {
        this.toolService = toolService;
    }

    public IGradebookDAO getGradebookDAO() {
        return this.gradebookDAO;
    }

    public void setGradebookDAO(IGradebookDAO gradebookDAO) {
        this.gradebookDAO = gradebookDAO;
    }

    public ILessonService getLessonService() {
        return this.lessonService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public IUserManagementService getUserService() {
        return this.userService;
    }

    public void setUserService(IUserManagementService userService) {
        this.userService = userService;
    }

    public IBaseDAO getBaseDAO() {
        return this.baseDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public IActivityDAO getActivityDAO() {
        return this.activityDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

