/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.lamsfoundation.lams.gradebook.dto.GradebookGridRowDTO;
import org.lamsfoundation.lams.gradebook.dto.comparators.GBAverageMarkComparator;
import org.lamsfoundation.lams.gradebook.dto.comparators.GBAverageTimeTakenComparator;
import org.lamsfoundation.lams.gradebook.dto.comparators.GBIDComparator;
import org.lamsfoundation.lams.gradebook.dto.comparators.GBMarkComparator;
import org.lamsfoundation.lams.gradebook.dto.comparators.GBRowNameComparator;
import org.lamsfoundation.lams.gradebook.dto.comparators.GBStartDateComparator;
import org.lamsfoundation.lams.gradebook.dto.comparators.GBTimeTakenComparator;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.util.WebUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GradebookUtil {
    public static String toGridXML(List gridRows, GBGridView view, String sortBy, boolean isSearch, String searchField, String searchOper, String searchString, String sortOrder, int rowLimit, int page) {
        gridRows = GradebookUtil.makeGridRowAlterations(gridRows, sortBy, isSearch, searchField, searchOper, searchString, sortOrder, rowLimit, page);
        int totalPages = 1;
        if (rowLimit < gridRows.size()) {
            totalPages = new Double(Math.ceil(new Integer(gridRows.size()).doubleValue() / new Integer(rowLimit).doubleValue())).intValue();
            int firstRow = (page - 1) * rowLimit;
            int lastRow = firstRow + rowLimit;
            gridRows = lastRow > gridRows.size() ? gridRows.subList(firstRow, gridRows.size()) : gridRows.subList(firstRow, lastRow);
        }
        return GradebookUtil.toGridXML(gridRows, page, totalPages, view);
    }

    public static String toGridXML(List gridRows, int page, int totalPages, GBGridView view) {
        String xml = "";
        try {
            Document document = GradebookUtil.getDocument();
            Element rootElement = document.createElement("rows");
            Element pageElement = document.createElement("page");
            pageElement.appendChild(document.createTextNode("" + page));
            rootElement.appendChild(pageElement);
            Element totalPageElement = document.createElement("total");
            totalPageElement.appendChild(document.createTextNode("" + totalPages));
            rootElement.appendChild(totalPageElement);
            Element recordsElement = document.createElement("records");
            recordsElement.appendChild(document.createTextNode("" + gridRows.size()));
            rootElement.appendChild(recordsElement);
            for (GradebookGridRowDTO gridRow : gridRows) {
                Element rowElement = document.createElement("row");
                rowElement.setAttribute("id", gridRow.getId().toString());
                ArrayList<Object> gridRowStringArray = new ArrayList();
                gridRowStringArray = gridRow.toStringArray(view);
                for (String string : gridRowStringArray) {
                    Element cellElement = document.createElement("cell");
                    String string2 = string != null ? string : "";
                    cellElement.appendChild(document.createTextNode(string2));
                    rowElement.appendChild(cellElement);
                }
                rootElement.appendChild(rowElement);
            }
            document.appendChild(rootElement);
            xml = GradebookUtil.getStringFromDocument(document);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return xml;
    }

    private static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        return document;
    }

    private static String getStringFromDocument(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    private static List makeGridRowAlterations(List gridRows, String sortBy, boolean isSearch, String searchField, String searchOper, String searchString, String sortOrder, int rowLimit, int page) {
        if (sortBy != null) {
            if (sortBy.equals("rowName")) {
                Collections.sort(gridRows, new GBRowNameComparator());
            } else if (sortBy.equals("mark")) {
                Collections.sort(gridRows, new GBMarkComparator());
            } else if (sortBy.equals("id")) {
                Collections.sort(gridRows, new GBIDComparator());
            } else if (sortBy.equals("timeTaken")) {
                Collections.sort(gridRows, new GBTimeTakenComparator());
            } else if (sortBy.equals("avgTimeTaken")) {
                Collections.sort(gridRows, new GBAverageTimeTakenComparator());
            } else if (sortBy.equals("avgMark")) {
                Collections.sort(gridRows, new GBAverageMarkComparator());
            } else if (sortBy.equals("startDate")) {
                Collections.sort(gridRows, new GBStartDateComparator());
            } else {
                Collections.sort(gridRows, new GBRowNameComparator());
            }
        } else {
            Collections.sort(gridRows, new GBRowNameComparator());
        }
        if (isSearch && searchField != null && searchOper != null && searchString != null) {
            gridRows = GradebookUtil.doRowNameSearch(gridRows, searchField, searchOper, searchString.toLowerCase());
        }
        if (sortOrder != null && sortOrder.equals("desc")) {
            Collections.reverse(gridRows);
        }
        return gridRows;
    }

    private static List doRowNameSearch(List gradebookRows, String searchField, String searchOper, String searchString) {
        ArrayList<GradebookGridRowDTO> ret = new ArrayList<GradebookGridRowDTO>();
        if (searchField.equals("rowName")) {
            for (GradebookGridRowDTO userRow : gradebookRows) {
                String rowName = userRow.getRowName();
                rowName = rowName.toLowerCase();
                if (searchOper.equals("eq")) {
                    if (!rowName.equals(searchString)) continue;
                    ret.add(userRow);
                    continue;
                }
                if (searchOper.equals("ne")) {
                    if (rowName.equals(searchString)) continue;
                    ret.add(userRow);
                    continue;
                }
                if (searchOper.equals("bw")) {
                    if (!rowName.startsWith(searchString)) continue;
                    ret.add(userRow);
                    continue;
                }
                if (searchOper.equals("ew")) {
                    if (!rowName.endsWith(searchString)) continue;
                    ret.add(userRow);
                    continue;
                }
                if (!searchOper.equals("cn") || !rowName.contains(searchString)) continue;
                ret.add(userRow);
            }
        }
        return ret;
    }

    public static GBGridView readGBGridViewParam(HttpServletRequest request, String param_mode, boolean optional) {
        String view = WebUtil.readStrParam((HttpServletRequest)request, (String)param_mode, (boolean)optional);
        if (view == null) {
            return null;
        }
        if (view.equals("monUserView")) {
            return GBGridView.MON_USER;
        }
        if (view.equals("monActivityView")) {
            return GBGridView.MON_ACTIVITY;
        }
        if (view.equals("monCourse")) {
            return GBGridView.MON_COURSE;
        }
        if (view.equals("lrnCourse")) {
            return GBGridView.LRN_COURSE;
        }
        if (view.equals("lrnActivity")) {
            return GBGridView.LRN_ACTIVITY;
        }
        throw new IllegalArgumentException("[" + view + "] is not a legal gradebook view");
    }
}

