/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.web.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.gradebook.GradebookUserLesson;
import org.lamsfoundation.lams.gradebook.dto.GBLessonGridRowDTO;
import org.lamsfoundation.lams.gradebook.dto.GradebookGridRowDTO;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.gradebook.util.GradebookUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GradebookAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(GradebookAction.class);
    private static IGradebookService gradebookService;
    private static IUserManagementService userService;
    private static ILessonService lessonService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ActionForward getActivityGridData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        void var17_20;
        UserDTO userDTO;
        this.initServices();
        int page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
        int rowLimit = WebUtil.readIntParam((HttpServletRequest)request, (String)"rows");
        String sortOrder = WebUtil.readStrParam((HttpServletRequest)request, (String)"sord");
        String sortBy = WebUtil.readStrParam((HttpServletRequest)request, (String)"sidx", (boolean)true);
        Boolean isSearch = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"_search");
        String searchField = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchField", (boolean)true);
        String searchOper = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchOper", (boolean)true);
        String searchString = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchString", (boolean)true);
        GBGridView view = GradebookUtil.readGBGridViewParam(request, "view", false);
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Integer userID = null;
        if (view == GBGridView.MON_USER) {
            userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
        } else if (view == GBGridView.LRN_ACTIVITY && (userDTO = this.getUser()) != null) {
            userID = userDTO.getUserID();
        }
        Lesson lesson = lessonService.getLesson(lessonID);
        if (lesson == null) {
            logger.error((Object)("No lesson could be found for: " + lessonID));
            return null;
        }
        ArrayList arrayList = new ArrayList();
        if (view == GBGridView.MON_USER || view == GBGridView.LRN_ACTIVITY) {
            User learner = (User)userService.findById(User.class, (Serializable)userID);
            if (learner == null) {
                logger.error((Object)("No learner found for: " + userID));
                return null;
            }
            List<GradebookGridRowDTO> list = gradebookService.getGBActivityRowsForLearner(lesson, learner);
        } else if (view == GBGridView.MON_ACTIVITY) {
            List<GradebookGridRowDTO> list = gradebookService.getGBActivityRowsForLesson(lesson);
        }
        if (sortBy == null || sortBy.equals("")) {
            sortBy = "startDate";
        }
        String ret = GradebookUtil.toGridXML((List)var17_20, view, sortBy, isSearch, searchField, searchOper, searchString, sortOrder, rowLimit, page);
        this.writeResponse(response, "text/xml", "UTF8", ret);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionForward getUserGridData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<Object> gradebookUserDTOs;
        GBGridView view;
        String searchString;
        String searchOper;
        String searchField;
        Boolean isSearch;
        String sortBy;
        String sortOrder;
        int rowLimit;
        int page;
        block8: {
            Integer organisationID;
            block9: {
                this.initServices();
                page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
                rowLimit = WebUtil.readIntParam((HttpServletRequest)request, (String)"rows");
                sortOrder = WebUtil.readStrParam((HttpServletRequest)request, (String)"sord");
                sortBy = WebUtil.readStrParam((HttpServletRequest)request, (String)"sidx", (boolean)true);
                isSearch = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"_search");
                searchField = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchField", (boolean)true);
                searchOper = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchOper", (boolean)true);
                searchString = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchString", (boolean)true);
                view = GradebookUtil.readGBGridViewParam(request, "view", false);
                Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)true);
                organisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID", (boolean)true);
                gradebookUserDTOs = new ArrayList();
                if (lessonID == null) break block9;
                Lesson lesson = lessonService.getLesson(lessonID);
                if (lesson == null) {
                    logger.error((Object)("No lesson could be found for: " + lessonID));
                    return null;
                }
                if (view == GBGridView.MON_USER || view == GBGridView.MON_COURSE) {
                    gradebookUserDTOs = gradebookService.getGBUserRowsForLesson(lesson);
                    break block8;
                } else if (view == GBGridView.MON_ACTIVITY) {
                    String rowID = WebUtil.readStrParam((HttpServletRequest)request, (String)"activityID");
                    Long activityID = null;
                    String[] split = rowID.split("_");
                    activityID = split.length == 2 ? Long.valueOf(Long.parseLong(split[0])) : Long.valueOf(Long.parseLong(rowID));
                    Long groupId = WebUtil.readLongParam((HttpServletRequest)request, (String)"groupId", (boolean)true);
                    Activity activity = gradebookService.getActivityById(activityID);
                    if (activity != null && activity instanceof ToolActivity) {
                        gradebookUserDTOs = gradebookService.getGBUserRowsForActivity(lesson, (ToolActivity)activity, groupId);
                        break block8;
                    } else {
                        logger.error((Object)("No activity found for: " + activityID));
                        return null;
                    }
                }
                break block8;
            }
            if (organisationID == null) {
                logger.error((Object)"Missing parameters: either lessonID or organisationID should be specified.");
                return null;
            }
            Organisation org = (Organisation)userService.findById(Organisation.class, (Serializable)organisationID);
            if (org == null) {
                logger.error((Object)("No organisation could be found for: " + organisationID));
                return null;
            }
            gradebookUserDTOs = gradebookService.getGBUserRowsForOrganisation(org);
        }
        String ret = GradebookUtil.toGridXML(gradebookUserDTOs, view, sortBy, isSearch, searchField, searchOper, searchString, sortOrder, rowLimit, page);
        this.writeResponse(response, "text/xml", "UTF8", ret);
        return null;
    }

    public ActionForward getCourseGridData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user;
        this.initServices();
        int page = WebUtil.readIntParam((HttpServletRequest)request, (String)"page");
        int rowLimit = WebUtil.readIntParam((HttpServletRequest)request, (String)"rows");
        String sortOrder = WebUtil.readStrParam((HttpServletRequest)request, (String)"sord");
        String sortBy = WebUtil.readStrParam((HttpServletRequest)request, (String)"sidx", (boolean)true);
        Boolean isSearch = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"_search");
        String searchField = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchField", (boolean)true);
        String searchOper = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchOper", (boolean)true);
        String searchString = WebUtil.readStrParam((HttpServletRequest)request, (String)"searchString", (boolean)true);
        GBGridView view = GradebookUtil.readGBGridViewParam(request, "view", false);
        Integer courseID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        Organisation organisation = (Organisation)userService.findById(Organisation.class, (Serializable)courseID);
        Set lessons = organisation.getLessons();
        if (lessons == null) {
            return null;
        }
        if (view == GBGridView.MON_USER) {
            Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
            user = (User)userService.findById(User.class, (Serializable)userID);
        } else {
            user = this.getRealUser();
        }
        User viewer = this.getRealUser();
        if (organisation == null || user == null || viewer == null) {
            logger.error((Object)("Error: request for course gradebook data with null course or user. CourseID: " + courseID));
            return null;
        }
        List<GBLessonGridRowDTO> gradebookLessonDTOs = gradebookService.getGBLessonRows(organisation, user, viewer, view);
        if (sortBy == null) {
            sortBy = "id";
        }
        String ret = GradebookUtil.toGridXML(gradebookLessonDTOs, view, sortBy, isSearch, searchField, searchOper, searchString, sortOrder, rowLimit, page);
        this.writeResponse(response, "text/xml", "UTF8", ret);
        return null;
    }

    public ActionForward getLessonMarkAggregate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
        Lesson lesson = lessonService.getLesson(lessonID);
        User learner = (User)userService.findById(User.class, (Serializable)userID);
        if (lesson != null && learner != null) {
            GradebookUserLesson lessonMark = gradebookService.getGradebookUserLesson(lessonID, userID);
            this.writeResponse(response, "text/plain", "UTF8", lessonMark.getMark().toString());
        } else {
            logger.error((Object)("Error: request for course gradebook data with null user or lesson. lessonID: " + lessonID));
        }
        return null;
    }

    public ActionForward getActivityMarkAverage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Activity activity = gradebookService.getActivityById(activityID);
        if (activity != null) {
            Double averageMark = gradebookService.getAverageMarkForActivity(activityID);
            if (averageMark != null) {
                this.writeResponse(response, "text/plain", "UTF8", averageMark.toString());
            } else {
                this.writeResponse(response, "text/plain", "UTF8", "-");
            }
        } else {
            logger.error((Object)("Error: request for course gradebook data with null activity. actvity: " + activityID));
        }
        return null;
    }

    public ActionForward getLessonMarkAverage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Lesson lesson = lessonService.getLesson(lessonID);
        if (lesson != null) {
            Double averageMark = gradebookService.getAverageMarkForLesson(lessonID);
            if (averageMark != null) {
                this.writeResponse(response, "text/plain", "UTF8", averageMark.toString());
            } else {
                this.writeResponse(response, "text/plain", "UTF8", "-");
            }
        } else {
            logger.error((Object)("Error: request for course gradebook data with null lesson. lesson: " + lessonID));
        }
        return null;
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private User getRealUser() {
        UserDTO userDTO = this.getUser();
        if (userDTO != null) {
            return this.getUserService().getUserByLogin(userDTO.getLogin());
        }
        return null;
    }

    private void initServices() {
        this.getUserService();
        this.getLessonService();
        this.getGradebookService();
    }

    private IUserManagementService getUserService() {
        if (userService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private IGradebookService getGradebookService() {
        if (gradebookService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            gradebookService = (IGradebookService)ctx.getBean("gradebookService");
        }
        return gradebookService;
    }
}

