/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.web.action;

import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GradebookLearningAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(GradebookLearningAction.class);
    private static IGradebookService gradebookService;
    private static IUserManagementService userService;
    private static ILessonService lessonService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    public ActionForward courseLearner(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.initServices();
            Integer oranisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
            logger.debug((Object)("request learnerGradebook for organisation: " + oranisationID.toString()));
            UserDTO user = this.getUser();
            if (user == null) {
                logger.error((Object)"User missing from session. ");
                return mapping.findForward("error");
            }
            Organisation organisation = (Organisation)userService.findById(Organisation.class, (Serializable)oranisationID);
            if (organisation == null) {
                logger.error((Object)("Organisation " + oranisationID + " does not exist. Unable to load gradebook"));
                return mapping.findForward("error");
            }
            if (!userService.isUserInRole(user.getUserID(), oranisationID, "LEARNER")) {
                logger.error((Object)("User " + user.getLogin() + " is not a learner in the requested course. Cannot access the course for gradebook."));
                return this.displayMessage(mapping, request, "error.authorisation");
            }
            request.setAttribute("organisationID", (Object)oranisationID);
            request.setAttribute("organisationName", (Object)organisation.getName());
            request.setAttribute("fullName", (Object)(user.getFirstName() + " " + user.getLastName()));
            return mapping.findForward("learnercoursegradebook");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load gradebook monitor", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private ActionForward displayMessage(ActionMapping mapping, HttpServletRequest req, String messageKey) {
        req.setAttribute("messageKey", (Object)messageKey);
        return mapping.findForward("message");
    }

    private void initServices() {
        this.getUserService();
        this.getLessonService();
        this.getGradebookService();
    }

    private IUserManagementService getUserService() {
        if (userService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private IGradebookService getGradebookService() {
        if (gradebookService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            gradebookService = (IGradebookService)ctx.getBean("gradebookService");
        }
        return gradebookService;
    }
}

