/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.gradebook.web.action;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.gradebook.util.GBGridView;
import org.lamsfoundation.lams.gradebook.util.GradebookUtil;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.ExcelCell;
import org.lamsfoundation.lams.util.ExcelUtil;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GradebookMonitoringAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(GradebookMonitoringAction.class);
    private static IGradebookService gradebookService;
    private static IUserManagementService userService;
    private static ILessonService lessonService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Lesson lesson;
            this.initServices();
            Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            logger.debug((Object)("request monitorGradebook for lesson: " + lessonId.toString()));
            UserDTO user = this.getUser();
            if (user == null) {
                logger.error((Object)"User missing from session. ");
                return mapping.findForward("error");
            }
            Lesson lesson2 = lesson = lessonId != null ? lessonService.getLesson(lessonId) : null;
            if (lesson == null) {
                logger.error((Object)("Lesson " + lessonId + " does not exist. Unable to monitor lesson"));
                return mapping.findForward("error");
            }
            if (lesson.getLessonClass() == null || !lesson.getLessonClass().isStaffMember(this.getRealUser(user))) {
                logger.error((Object)("User " + user.getLogin() + " is not a monitor in the requested lesson. Cannot access the lesson for monitor."));
                return this.displayMessage(mapping, request, "error.authorisation");
            }
            logger.debug((Object)"user is staff");
            boolean marksReleased = lesson.getMarksReleased() != null && lesson.getMarksReleased() != false;
            LessonDetailsDTO lessonDetatilsDTO = lesson.getLessonDetails();
            request.setAttribute("lessonDetails", (Object)lessonDetatilsDTO);
            request.setAttribute("marksReleased", (Object)marksReleased);
            return mapping.findForward("monitorgradebook");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load gradebook monitor", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward courseMonitor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.initServices();
            Integer oranisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
            logger.debug((Object)("request monitorGradebook for organisation: " + oranisationID.toString()));
            UserDTO user = this.getUser();
            if (user == null) {
                logger.error((Object)"User missing from session. ");
                return mapping.findForward("error");
            }
            Organisation organisation = (Organisation)userService.findById(Organisation.class, (Serializable)oranisationID);
            if (organisation == null) {
                logger.error((Object)("Organisation " + oranisationID + " does not exist. Unable to load gradebook"));
                return mapping.findForward("error");
            }
            if (!userService.isUserInRole(user.getUserID(), oranisationID, "MONITOR")) {
                logger.error((Object)("User " + user.getLogin() + " is not a monitor in the requested course. Cannot access the course for gradebook."));
                return this.displayMessage(mapping, request, "error.authorisation");
            }
            logger.debug((Object)"user is staff");
            request.setAttribute("organisationID", (Object)oranisationID);
            request.setAttribute("organisationName", (Object)organisation.getName());
            return mapping.findForward("monitorcoursegradebook");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load gradebook monitor", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward updateUserLessonGradebookData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"id");
        String markStr = WebUtil.readStrParam((HttpServletRequest)request, (String)"mark", (boolean)true);
        String feedback = WebUtil.readStrParam((HttpServletRequest)request, (String)"feedback", (boolean)true);
        Lesson lesson = lessonService.getLesson(lessonID);
        User learner = (User)userService.findById(User.class, (Serializable)userID);
        if (lesson != null || learner != null) {
            if (markStr != null && !markStr.equals("")) {
                Double mark = Double.parseDouble(markStr);
                gradebookService.updateUserLessonGradebookMark(lesson, learner, mark);
            }
            if (feedback != null) {
                gradebookService.updateUserLessonGradebookFeedback(lesson, learner, feedback);
            }
        } else {
            logger.error((Object)("No lesson could be found for: " + lessonID));
        }
        return null;
    }

    public ActionForward updateUserActivityGradebookData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        GBGridView view = GradebookUtil.readGBGridViewParam(request, "view", false);
        Long activityID = null;
        Integer userID = null;
        if (view == GBGridView.MON_ACTIVITY) {
            String rowID = WebUtil.readStrParam((HttpServletRequest)request, (String)"activityID");
            String[] split = rowID.split("_");
            activityID = split.length == 2 ? Long.valueOf(Long.parseLong(split[0])) : Long.valueOf(Long.parseLong(rowID));
            userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"id");
        } else if (view == GBGridView.MON_USER) {
            activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"id");
            userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
        }
        String markStr = WebUtil.readStrParam((HttpServletRequest)request, (String)"mark", (boolean)true);
        String feedback = WebUtil.readStrParam((HttpServletRequest)request, (String)"feedback", (boolean)true);
        Activity activity = (Activity)userService.findById(Activity.class, (Serializable)activityID);
        User learner = (User)userService.findById(User.class, (Serializable)userID);
        Lesson lesson = lessonService.getLesson(lessonID);
        if (lesson != null && activity != null && learner != null && activity.isToolActivity()) {
            if (markStr != null && !markStr.equals("")) {
                Double mark = Double.parseDouble(markStr);
                gradebookService.updateUserActivityGradebookMark(lesson, learner, activity, mark, true);
            }
            if (feedback != null) {
                gradebookService.updateUserActivityGradebookFeedback(activity, learner, feedback);
            }
        } else {
            logger.error((Object)("Lesson or activity missing for lesson: " + lessonID + "and activity: " + activityID));
        }
        return null;
    }

    public ActionForward toggleReleaseMarks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Lesson lesson = lessonService.getLesson(lessonID);
        boolean marksReleased = lesson.getMarksReleased() != null && lesson.getMarksReleased() != false;
        lesson.setMarksReleased(Boolean.valueOf(!marksReleased));
        userService.save((Object)lesson);
        this.writeResponse(response, "text/plain", "UTF8", "success");
        return null;
    }

    public ActionForward exportExcelLessonGradebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        Lesson lesson = lessonService.getLesson(lessonID);
        if (lesson == null) {
            String errorMsg = "Attempt to retrieve gradebook data for null lesson";
            logger.error((Object)errorMsg);
            throw new Exception(errorMsg);
        }
        String fileName = lesson.getLessonName().replaceAll(" ", "_") + ".xlsx";
        fileName = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)fileName);
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        logger.debug((Object)("Exporting to a spreadsheet gradebook lesson: " + lessonID));
        ServletOutputStream out = response.getOutputStream();
        LinkedHashMap<String, ExcelCell[][]> dataToExport = gradebookService.exportLessonGradebook(lesson);
        String downloadTokenValue = WebUtil.readStrParam((HttpServletRequest)request, (String)"downloadTokenValue");
        Cookie fileDownloadTokenCookie = new Cookie("fileDownloadToken", downloadTokenValue);
        fileDownloadTokenCookie.setPath("/");
        response.addCookie(fileDownloadTokenCookie);
        ExcelUtil.createExcel((OutputStream)out, dataToExport, (String)gradebookService.getMessage("gradebook.export.dateheader"), (boolean)true);
        return null;
    }

    public ActionForward exportExcelCourseGradebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initServices();
        Integer oranisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID");
        User user = this.getRealUser(this.getUser());
        Organisation organisation = (Organisation)userService.findById(Organisation.class, (Serializable)oranisationID);
        if (organisation == null || user == null) {
            String errorMsg = "Organisation " + oranisationID + " does not exist or user is null. Unable to load gradebook";
            logger.error((Object)errorMsg);
            throw new Exception(errorMsg);
        }
        Integer organisationId = organisation.getOrganisationId();
        logger.debug((Object)("Exporting to a spreadsheet course: " + organisationId));
        LinkedHashMap<String, ExcelCell[][]> dataToExport = gradebookService.exportCourseGradebook(user.getUserId(), organisationId);
        String fileName = organisation.getName().replaceAll(" ", "_") + ".xlsx";
        fileName = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)fileName);
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        String downloadTokenValue = WebUtil.readStrParam((HttpServletRequest)request, (String)"downloadTokenValue");
        Cookie fileDownloadTokenCookie = new Cookie("fileDownloadToken", downloadTokenValue);
        fileDownloadTokenCookie.setPath("/");
        response.addCookie(fileDownloadTokenCookie);
        ServletOutputStream out = response.getOutputStream();
        ExcelUtil.createExcel((OutputStream)out, dataToExport, (String)gradebookService.getMessage("gradebook.export.dateheader"), (boolean)true);
        return null;
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private User getRealUser(UserDTO dto) {
        return this.getUserService().getUserByLogin(dto.getLogin());
    }

    private ActionForward displayMessage(ActionMapping mapping, HttpServletRequest req, String messageKey) {
        req.setAttribute("messageKey", (Object)messageKey);
        return mapping.findForward("message");
    }

    private void initServices() {
        this.getUserService();
        this.getLessonService();
        this.getGradebookService();
    }

    private IUserManagementService getUserService() {
        if (userService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userService;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private IGradebookService getGradebookService() {
        if (gradebookService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            gradebookService = (IGradebookService)ctx.getBean("gradebookService");
        }
        return gradebookService;
    }
}

